/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.hibernate;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.hibernate.ejb.packaging.Scanner;
import org.jboss.classloading.plugins.visitor.FederatedResourceVisitor;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.scanning.hibernate.HibernateScanningPluginFactory;
import org.jboss.scanning.hibernate.PackageVisitor;
import org.jboss.scanning.hibernate.PatternVisitor;
import org.jboss.scanning.hibernate.ScannerImpl;
import org.jboss.scanning.hibernate.SingleAnnotationVisitor;
import org.jboss.scanning.plugins.helpers.DeploymentUtilsFactory;
import org.jboss.scanning.plugins.visitor.ReflectProvider;
import org.jboss.scanning.spi.helpers.AbstractScanningPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateScanningPlugin
extends AbstractScanningPlugin<ScannerImpl, Scanner> {
    private final ScannerImpl scanner;
    private final ResourceVisitor visitor;

    public HibernateScanningPlugin(DeploymentUnit unit, HibernateScanningPluginFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        this.scanner = new ScannerImpl(unit);
        ArrayList<Object> visitors = new ArrayList<Object>();
        visitors.add(new PackageVisitor(this.scanner));
        for (String pattern : factory.getPatterns()) {
            PatternVisitor rv = new PatternVisitor(pattern, this.scanner);
            visitors.add(rv);
        }
        ReflectProvider provider = DeploymentUtilsFactory.getProvider((DeploymentUnit)unit);
        for (Class<? extends Annotation> annotation : factory.getAnnotations()) {
            SingleAnnotationVisitor rv = new SingleAnnotationVisitor(provider, annotation, this.scanner);
            visitors.add((Object)rv);
        }
        this.visitor = new FederatedResourceVisitor(visitors.toArray(new ResourceVisitor[visitors.size()]));
    }

    protected ScannerImpl doCreateHandle() {
        return this.scanner;
    }

    public void cleanupHandle(Scanner handle) {
        if (handle instanceof ScannerImpl) {
            ((ScannerImpl)((Object)ScannerImpl.class.cast(handle))).cleanup();
        }
    }

    public Class<Scanner> getHandleInterface() {
        return Scanner.class;
    }

    public ResourceFilter getFilter() {
        return this.visitor.getFilter();
    }

    public void visit(ResourceContext resource) {
        this.visitor.visit(resource);
    }
}

