/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.microcontainer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.system.Service;
import org.jboss.system.ServiceController;

public class ServiceProxy
implements InvocationHandler {
    private static Map<String, Integer> serviceOpMap = new HashMap<String, Integer>();
    private static Service NO_LIFECYCLE_CALLOUT;
    private boolean[] hasOp = new boolean[]{false, false, false, false};
    private ObjectName objectName;
    private MBeanServer server;
    private boolean hasJBossInternalLifecycle;

    public static Service getServiceProxy(ObjectName objectName, MBeanServer server) throws Exception {
        return ServiceProxy.getServiceProxy(objectName, server, true);
    }

    public static Service getServiceProxy(ObjectName objectName, MBeanServer server, boolean includeLifecycle) throws Exception {
        if (includeLifecycle) {
            MBeanInfo info = server.getMBeanInfo(objectName);
            MBeanOperationInfo[] opInfo = info.getOperations();
            Class[] interfaces = new Class[]{Service.class};
            ServiceProxy handler = new ServiceProxy(objectName, server, opInfo);
            return (Service)Proxy.newProxyInstance(Service.class.getClassLoader(), interfaces, (InvocationHandler)handler);
        }
        return NO_LIFECYCLE_CALLOUT;
    }

    public ServiceProxy(ObjectName objectName, MBeanServer server, MBeanOperationInfo[] opInfo) {
        this.server = server;
        this.objectName = objectName;
        for (MBeanOperationInfo info : opInfo) {
            String name = info.getName();
            if (name.equals("jbossInternalLifecycle")) {
                this.hasJBossInternalLifecycle = true;
                continue;
            }
            Integer opID = serviceOpMap.get(name);
            if (opID == null || !info.getReturnType().equals("void") || info.getSignature().length != 0) continue;
            this.hasOp[opID.intValue()] = true;
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (this.hasJBossInternalLifecycle) {
            try {
                this.server.invoke(this.objectName, "jbossInternalLifecycle", new Object[]{name}, ServiceController.JBOSS_INTERNAL_LIFECYCLE_SIG);
                return null;
            }
            catch (Exception e) {
                throw JMXExceptionDecoder.decode((Throwable)e);
            }
        }
        Integer opID = serviceOpMap.get(name);
        if (opID != null && this.hasOp[opID]) {
            try {
                String[] sig = new String[]{};
                this.server.invoke(this.objectName, name, args, sig);
            }
            catch (Exception e) {
                throw JMXExceptionDecoder.decode((Throwable)e);
            }
        }
        return null;
    }

    static {
        serviceOpMap.put("create", 0);
        serviceOpMap.put("start", 1);
        serviceOpMap.put("destroy", 2);
        serviceOpMap.put("stop", 3);
        Class[] interfaces = new Class[]{Service.class};
        NO_LIFECYCLE_CALLOUT = (Service)Proxy.newProxyInstance(Service.class.getClassLoader(), interfaces, (InvocationHandler)NoLifecycleCallout.INSTANCE);
    }

    private static class NoLifecycleCallout
    implements InvocationHandler {
        private static NoLifecycleCallout INSTANCE = new NoLifecycleCallout();

        private NoLifecycleCallout() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return null;
        }
    }
}

