/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.codehaus.mojo.exec.Classpath;
import org.codehaus.mojo.exec.StreamLog;
import org.codehaus.mojo.exec.UrlUtils;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public class ExecMojo
extends AbstractExecMojo {
    private String executable;
    private File workingDirectory;
    private File outputFile;
    private List arguments;
    private File basedir;
    private Map environmentVariables = new HashMap();
    private MavenSession session;
    private int[] successCodes;
    private boolean longClasspath;
    private boolean background;
    private String backgroundPollingAddress;
    private int backgroundPollingTimeout = 60;
    public static final String CLASSPATH_TOKEN = "%classpath";

    public void execute() throws MojoExecutionException {
        try {
            if (this.isSkip()) {
                this.getLog().info((CharSequence)"skipping execute as per configuration");
                return;
            }
            if (this.basedir == null) {
                throw new IllegalStateException("basedir is null. Should not be possible.");
            }
            String argsProp = this.getSystemProperty("exec.args");
            ArrayList<String> commandArguments = new ArrayList<String>();
            if (this.hasCommandlineArgs()) {
                String[] args = this.parseCommandlineArgs();
                for (int i = 0; i < args.length; ++i) {
                    if (this.isLongClassPathArgument(args[i])) {
                        commandArguments.add("-jar");
                        File tmpFile = this.createJar(this.computeClasspath(null), args[i + 2]);
                        commandArguments.add(tmpFile.getAbsolutePath());
                        i += 2;
                        continue;
                    }
                    if (CLASSPATH_TOKEN.equals(args[i])) {
                        commandArguments.add(this.computeClasspathString(null));
                        continue;
                    }
                    commandArguments.add(args[i]);
                }
            } else {
                if (!StringUtils.isEmpty((String)argsProp)) {
                    this.getLog().debug((CharSequence)("got arguments from system properties: " + argsProp));
                    try {
                        String[] args = CommandLineUtils.translateCommandline((String)argsProp);
                        commandArguments.addAll(Arrays.asList(args));
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("Couldn't parse systemproperty 'exec.args'");
                    }
                }
                if (this.arguments != null) {
                    for (int i = 0; i < this.arguments.size(); ++i) {
                        String arg;
                        Object argument = this.arguments.get(i);
                        if (argument == null) {
                            throw new MojoExecutionException("Misconfigured argument, value is null. Set the argument to an empty value if this is the required behaviour.");
                        }
                        if (argument instanceof String && this.isLongClassPathArgument((String)argument)) {
                            commandArguments.add("-jar");
                            File tmpFile = this.createJar(this.computeClasspath((Classpath)this.arguments.get(i + 1)), (String)this.arguments.get(i + 2));
                            commandArguments.add(tmpFile.getAbsolutePath());
                            i += 2;
                            continue;
                        }
                        if (argument instanceof Classpath) {
                            Classpath specifiedClasspath = (Classpath)argument;
                            arg = this.computeClasspathString(specifiedClasspath);
                            commandArguments.add(arg);
                            continue;
                        }
                        arg = argument.toString();
                        commandArguments.add(arg);
                    }
                }
            }
            HashMap<Object, Object> enviro = new HashMap<Object, Object>();
            try {
                Properties systemEnvVars = CommandLineUtils.getSystemEnvVars();
                enviro.putAll(systemEnvVars);
            }
            catch (IOException x) {
                this.getLog().error((CharSequence)"Could not assign default system environment variables.", (Throwable)x);
            }
            if (this.environmentVariables != null) {
                Iterator iter = this.environmentVariables.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)this.environmentVariables.get(key);
                    enviro.put(key, value);
                }
            }
            if (this.workingDirectory == null) {
                this.workingDirectory = this.basedir;
            }
            if (!this.workingDirectory.exists()) {
                this.getLog().debug((CharSequence)("Making working directory '" + this.workingDirectory.getAbsolutePath() + "'."));
                if (!this.workingDirectory.mkdirs()) {
                    throw new MojoExecutionException("Could not make working directory: '" + this.workingDirectory.getAbsolutePath() + "'");
                }
            }
            CommandLine commandLine = this.getExecutablePath(enviro, this.workingDirectory);
            DefaultExecutor exec = new DefaultExecutor();
            String[] args = new String[commandArguments.size()];
            for (int i = 0; i < commandArguments.size(); ++i) {
                args[i] = (String)commandArguments.get(i);
            }
            commandLine.addArguments(args, false);
            exec.setWorkingDirectory(this.workingDirectory);
            this.fillSuccessCodes((Executor)exec);
            PrintStream stdout = System.out;
            PrintStream stderr = System.err;
            try {
                this.getLog().debug((CharSequence)("Executing command line: " + commandLine));
                int resultCode = this.executeCommandLine((Executor)exec, commandLine, enviro, stdout, stderr);
                if (this.isResultCodeAFailure(resultCode)) {
                    throw new MojoExecutionException("Result of " + commandLine + " execution is: '" + resultCode + "'.");
                }
            }
            catch (ExecuteException e) {
                throw new MojoExecutionException("Command execution failed.", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Command execution failed.", (Exception)e);
            }
            this.registerSourceRoots();
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O Error", (Exception)e);
        }
    }

    private void fillSuccessCodes(Executor exec) {
        if (this.successCodes != null && this.successCodes.length > 0) {
            exec.setExitValues(this.successCodes);
        }
    }

    boolean isResultCodeAFailure(int result) {
        if (this.successCodes == null || this.successCodes.length == 0) {
            return result != 0;
        }
        for (int index = 0; index < this.successCodes.length; ++index) {
            if (this.successCodes[index] != result) continue;
            return false;
        }
        return true;
    }

    private boolean isLongClassPathArgument(String arg) {
        return this.longClasspath && ("-classpath".equals(arg) || "-cp".equals(arg));
    }

    private Log getExecOutputLog() {
        Log log = this.getLog();
        if (this.outputFile != null) {
            try {
                if (!this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
                    this.getLog().warn((CharSequence)("Could not create non existing parent directories for log file: " + this.outputFile));
                }
                PrintStream stream = new PrintStream(new FileOutputStream(this.outputFile));
                log = new StreamLog(stream);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Could not open " + this.outputFile + ". Using default log"), (Throwable)e);
            }
        }
        return log;
    }

    private String computeClasspathString(Classpath specifiedClasspath) {
        List resultList = this.computeClasspath(specifiedClasspath);
        StringBuffer theClasspath = new StringBuffer();
        Iterator it = resultList.iterator();
        while (it.hasNext()) {
            String str = (String)it.next();
            ExecMojo.addToClasspath(theClasspath, str);
        }
        return theClasspath.toString();
    }

    private List computeClasspath(Classpath specifiedClasspath) {
        List artifacts = new ArrayList();
        ArrayList theClasspathFiles = new ArrayList();
        ArrayList<String> resultList = new ArrayList<String>();
        this.collectProjectArtifactsAndClasspath(artifacts, theClasspathFiles);
        if (specifiedClasspath != null && specifiedClasspath.getDependencies() != null) {
            artifacts = this.filterArtifacts(artifacts, specifiedClasspath.getDependencies());
        }
        Iterator it = theClasspathFiles.iterator();
        while (it.hasNext()) {
            File f = (File)it.next();
            resultList.add(f.getAbsolutePath());
        }
        it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            this.getLog().debug((CharSequence)("dealing with " + artifact));
            resultList.add(artifact.getFile().getAbsolutePath());
        }
        return resultList;
    }

    private static void addToClasspath(StringBuffer theClasspath, String toAdd) {
        if (theClasspath.length() > 0) {
            theClasspath.append(File.pathSeparator);
        }
        theClasspath.append(toAdd);
    }

    private List filterArtifacts(List artifacts, Collection dependencies) {
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new IncludesArtifactFilter(new ArrayList(dependencies)));
        ArrayList<Artifact> filteredArtifacts = new ArrayList<Artifact>();
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (!filter.include(artifact)) continue;
            this.getLog().debug((CharSequence)("filtering in " + artifact));
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    CommandLine getExecutablePath(Map enviro, File dir) {
        CommandLine toRet;
        File execFile = new File(this.executable);
        String exec = null;
        if (execFile.isFile()) {
            this.getLog().debug((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.executable));
            exec = execFile.getAbsolutePath();
        }
        if (exec == null) {
            Toolchain tc = this.getToolchain();
            if (tc != null) {
                this.getLog().info((CharSequence)("Toolchain in exec-maven-plugin: " + tc));
                exec = tc.findTool(this.executable);
            } else if (OS.isFamilyWindows()) {
                String path;
                String ex = this.executable.indexOf(".") < 0 ? this.executable + ".bat" : this.executable;
                File f = new File(dir, ex);
                if (f.isFile()) {
                    exec = ex;
                }
                if (exec == null && (path = (String)enviro.get("PATH")) != null) {
                    String[] elems = StringUtils.split((String)path, (String)File.pathSeparator);
                    for (int i = 0; i < elems.length; ++i) {
                        f = new File(new File(elems[i]), ex);
                        if (!f.isFile()) continue;
                        exec = ex;
                        break;
                    }
                }
            }
        }
        if (exec == null) {
            exec = this.executable;
        }
        if (OS.isFamilyWindows() && exec.toLowerCase(Locale.getDefault()).endsWith(".bat")) {
            toRet = new CommandLine("cmd");
            toRet.addArgument("/c");
            toRet.addArgument(exec);
        } else {
            toRet = new CommandLine(exec);
        }
        return toRet;
    }

    protected int executeCommandLine(Executor exec, CommandLine commandLine, Map enviro, OutputStream out, OutputStream err) throws ExecuteException, IOException {
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(out, err, System.in));
        return exec.execute(commandLine, enviro);
    }

    protected void executeCommandLineInBackground(Executor exec, final CommandLine commandLine, Map enviro, OutputStream out, OutputStream err) throws ExecuteException, IOException, MojoExecutionException {
        ExecuteResultHandler resultHandler = new ExecuteResultHandler(){

            public void onProcessComplete(int resultCode) {
                if (ExecMojo.this.isResultCodeAFailure(resultCode)) {
                    ExecMojo.this.getLog().error((CharSequence)("Background process with command line [" + commandLine + "] failed with exit code " + resultCode + "."));
                } else {
                    ExecMojo.this.getLog().info((CharSequence)("Background process with command line [" + commandLine + "] completed with exit code " + resultCode + "."));
                }
            }

            public void onProcessFailed(ExecuteException e) {
                ExecMojo.this.getLog().error((CharSequence)("An error occurred executing background process with command line [" + commandLine + "]."), (Throwable)e);
            }
        };
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(out, err, System.in));
        exec.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        exec.execute(commandLine, enviro, resultHandler);
        if (this.backgroundPollingAddress != null) {
            int colonIndex = this.backgroundPollingAddress.lastIndexOf(58);
            if (colonIndex == -1) {
                throw new IllegalStateException("backgroundBlockingAddress has an illegal value - it should be host:port.");
            }
            String host = this.backgroundPollingAddress.substring(0, colonIndex);
            int port = Integer.valueOf(this.backgroundPollingAddress.substring(colonIndex + 1));
            this.getLog().info((CharSequence)("Attempting to connect to " + this.backgroundPollingAddress + " - will timeout after one minute..."));
            InetAddress address = InetAddress.getByName(host);
            InetSocketAddress socketAddress = new InetSocketAddress(address, port);
            int pollingTimeoutMillis = this.backgroundPollingTimeout * 1000;
            boolean connected = this.pollSocketAddress(socketAddress, pollingTimeoutMillis);
            if (connected) {
                this.getLog().info((CharSequence)("Connected to " + this.backgroundPollingAddress + " - assuming process with command line [" + commandLine + "] has fully started."));
            } else {
                throw new MojoExecutionException("Failed to connect to " + this.backgroundPollingAddress + " within one minute.");
            }
        }
    }

    private boolean pollSocketAddress(SocketAddress address, int timeout) {
        long startTime = System.currentTimeMillis();
        boolean connected = false;
        while (System.currentTimeMillis() - startTime < (long)timeout) {
            Socket socket = new Socket();
            try {
                this.getLog().debug((CharSequence)("Attempting to connect to " + address + "..."));
                socket.setReuseAddress(true);
                socket.connect(address, 3000);
                connected = true;
                try {
                    socket.close();
                    this.getLog().debug((CharSequence)("Closed connection to " + address + "."));
                }
                catch (IOException e) {
                    this.getLog().debug((CharSequence)("Failed to close connection to " + address + ": " + e));
                }
                break;
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Failed to connect to " + address + ": " + e));
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e1) {}
            }
        }
        return connected;
    }

    void setExecutable(String executable) {
        this.executable = executable;
    }

    String getExecutable() {
        return this.executable;
    }

    void setWorkingDirectory(String workingDir) {
        this.setWorkingDirectory(new File(workingDir));
    }

    void setWorkingDirectory(File workingDir) {
        this.workingDirectory = workingDir;
    }

    void setArguments(List arguments) {
        this.arguments = arguments;
    }

    void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    protected String getSystemProperty(String key) {
        return System.getProperty(key);
    }

    public void setSuccessCodes(Integer[] list) {
        this.successCodes = new int[list.length];
        for (int index = 0; index < list.length; ++index) {
            this.successCodes[index] = list[index];
        }
    }

    public int[] getSuccessCodes() {
        return this.successCodes;
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }

    public String getBackgroundPollingAddress() {
        return this.backgroundPollingAddress;
    }

    public void setBackgroundPollingAddress(String backgroundPollingAddress) {
        this.backgroundPollingAddress = backgroundPollingAddress;
    }

    public int getBackgroundPollingTimeout() {
        return this.backgroundPollingTimeout;
    }

    public void setBackgroundPollingTimeout(int backgroundPollingTimeout) {
        if (backgroundPollingTimeout < 0) {
            throw new IllegalArgumentException("backgroundPollingTimeout cannot be negative.");
        }
        this.backgroundPollingTimeout = backgroundPollingTimeout > 0 ? backgroundPollingTimeout : Integer.MAX_VALUE;
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        try {
            ToolchainManager toolchainManager;
            if (this.session != null && (toolchainManager = (ToolchainManager)this.session.getContainer().lookup(ToolchainManager.ROLE)) != null) {
                tc = toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return tc;
    }

    private File createJar(List classPath, String mainClass) throws IOException {
        File file = File.createTempFile("maven-exec", ".jar");
        file.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(file);
        JarOutputStream jos = new JarOutputStream(fos);
        jos.setLevel(0);
        JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
        jos.putNextEntry(je);
        Manifest man = new Manifest();
        String cp = "";
        Iterator it = classPath.iterator();
        while (it.hasNext()) {
            String el = (String)it.next();
            cp = cp + UrlUtils.getURL(new File(el)).toExternalForm() + " ";
        }
        man.getMainAttributes().putValue("Manifest-Version", "1.0");
        man.getMainAttributes().putValue("Class-Path", cp.trim());
        man.getMainAttributes().putValue("Main-Class", mainClass);
        man.write(jos);
        jos.close();
        return file;
    }
}

