/*
 * Decompiled with CFR 0.152.
 */
package com.rd.draw.drawer.type;

import android.graphics.Canvas;
import android.graphics.Paint;
import androidx.annotation.NonNull;
import com.rd.animation.data.Value;
import com.rd.animation.data.type.SwapAnimationValue;
import com.rd.draw.data.Indicator;
import com.rd.draw.data.Orientation;
import com.rd.draw.drawer.type.BaseDrawer;

public class SwapDrawer
extends BaseDrawer {
    public SwapDrawer(@NonNull Paint paint, @NonNull Indicator indicator) {
        super(paint, indicator);
    }

    public void draw(@NonNull Canvas canvas, @NonNull Value value, int position, int coordinateX, int coordinateY) {
        if (!(value instanceof SwapAnimationValue)) {
            return;
        }
        SwapAnimationValue v = (SwapAnimationValue)value;
        int selectedColor = this.indicator.getSelectedColor();
        int unselectedColor = this.indicator.getUnselectedColor();
        int radius = this.indicator.getRadius();
        int selectedPosition = this.indicator.getSelectedPosition();
        int selectingPosition = this.indicator.getSelectingPosition();
        int lastSelectedPosition = this.indicator.getLastSelectedPosition();
        int coordinate = v.getCoordinate();
        int color = unselectedColor;
        if (this.indicator.isInteractiveAnimation()) {
            if (position == selectingPosition) {
                coordinate = v.getCoordinate();
                color = selectedColor;
            } else if (position == selectedPosition) {
                coordinate = v.getCoordinateReverse();
                color = unselectedColor;
            }
        } else if (position == lastSelectedPosition) {
            coordinate = v.getCoordinate();
            color = selectedColor;
        } else if (position == selectedPosition) {
            coordinate = v.getCoordinateReverse();
            color = unselectedColor;
        }
        this.paint.setColor(color);
        if (this.indicator.getOrientation() == Orientation.HORIZONTAL) {
            canvas.drawCircle((float)coordinate, (float)coordinateY, (float)radius, this.paint);
        } else {
            canvas.drawCircle((float)coordinateX, (float)coordinate, (float)radius, this.paint);
        }
    }
}

