/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A map that contains tag keys and tag values to attach to an Amazon Web Services X-Ray group or sampling rule. For
 * more information about ways to use tags, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in
 * the <i>Amazon Web Services General Reference</i>.
 * </p>
 * <p>
 * The following restrictions apply to tags:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Maximum number of user-applied tags per resource: 50
 * </p>
 * </li>
 * <li>
 * <p>
 * Tag keys and values are case sensitive.
 * </p>
 * </li>
 * <li>
 * <p>
 * Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use. You cannot edit or
 * delete system tags.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Tag implements SdkPojo, Serializable, ToCopyableBuilder<Tag.Builder, Tag> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(Tag::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(Tag::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private Tag(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * A tag key, such as <code>Stage</code> or <code>Name</code>. A tag key cannot be empty. The key can be a maximum
     * of 128 characters, and can contain only Unicode letters, numbers, or separators, or the following special
     * characters: <code>+ - = . _ : /</code>
     * </p>
     * 
     * @return A tag key, such as <code>Stage</code> or <code>Name</code>. A tag key cannot be empty. The key can be a
     *         maximum of 128 characters, and can contain only Unicode letters, numbers, or separators, or the following
     *         special characters: <code>+ - = . _ : /</code>
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * An optional tag value, such as <code>Production</code> or <code>test-only</code>. The value can be a maximum of
     * 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters:
     * <code>+ - = . _ : /</code>
     * </p>
     * 
     * @return An optional tag value, such as <code>Production</code> or <code>test-only</code>. The value can be a
     *         maximum of 255 characters, and contain only Unicode letters, numbers, or separators, or the following
     *         special characters: <code>+ - = . _ : /</code>
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag other = (Tag) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Tag").add("Key", key()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tag, T> g) {
        return obj -> g.apply((Tag) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Tag> {
        /**
         * <p>
         * A tag key, such as <code>Stage</code> or <code>Name</code>. A tag key cannot be empty. The key can be a
         * maximum of 128 characters, and can contain only Unicode letters, numbers, or separators, or the following
         * special characters: <code>+ - = . _ : /</code>
         * </p>
         * 
         * @param key
         *        A tag key, such as <code>Stage</code> or <code>Name</code>. A tag key cannot be empty. The key can be
         *        a maximum of 128 characters, and can contain only Unicode letters, numbers, or separators, or the
         *        following special characters: <code>+ - = . _ : /</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * An optional tag value, such as <code>Production</code> or <code>test-only</code>. The value can be a maximum
         * of 255 characters, and contain only Unicode letters, numbers, or separators, or the following special
         * characters: <code>+ - = . _ : /</code>
         * </p>
         * 
         * @param value
         *        An optional tag value, such as <code>Production</code> or <code>test-only</code>. The value can be a
         *        maximum of 255 characters, and contain only Unicode letters, numbers, or separators, or the following
         *        special characters: <code>+ - = . _ : /</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Tag model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Tag build() {
            return new Tag(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
