/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics that describe how the incident has impacted a service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestImpactStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<RequestImpactStatistics.Builder, RequestImpactStatistics> {
    private static final SdkField<Long> FAULT_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FaultCount").getter(getter(RequestImpactStatistics::faultCount)).setter(setter(Builder::faultCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultCount").build()).build();

    private static final SdkField<Long> OK_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("OkCount")
            .getter(getter(RequestImpactStatistics::okCount)).setter(setter(Builder::okCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OkCount").build()).build();

    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalCount").getter(getter(RequestImpactStatistics::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAULT_COUNT_FIELD,
            OK_COUNT_FIELD, TOTAL_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long faultCount;

    private final Long okCount;

    private final Long totalCount;

    private RequestImpactStatistics(BuilderImpl builder) {
        this.faultCount = builder.faultCount;
        this.okCount = builder.okCount;
        this.totalCount = builder.totalCount;
    }

    /**
     * <p>
     * The number of requests that have resulted in a fault,
     * </p>
     * 
     * @return The number of requests that have resulted in a fault,
     */
    public final Long faultCount() {
        return faultCount;
    }

    /**
     * <p>
     * The number of successful requests.
     * </p>
     * 
     * @return The number of successful requests.
     */
    public final Long okCount() {
        return okCount;
    }

    /**
     * <p>
     * The total number of requests to the service.
     * </p>
     * 
     * @return The total number of requests to the service.
     */
    public final Long totalCount() {
        return totalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(faultCount());
        hashCode = 31 * hashCode + Objects.hashCode(okCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestImpactStatistics)) {
            return false;
        }
        RequestImpactStatistics other = (RequestImpactStatistics) obj;
        return Objects.equals(faultCount(), other.faultCount()) && Objects.equals(okCount(), other.okCount())
                && Objects.equals(totalCount(), other.totalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestImpactStatistics").add("FaultCount", faultCount()).add("OkCount", okCount())
                .add("TotalCount", totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaultCount":
            return Optional.ofNullable(clazz.cast(faultCount()));
        case "OkCount":
            return Optional.ofNullable(clazz.cast(okCount()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestImpactStatistics, T> g) {
        return obj -> g.apply((RequestImpactStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestImpactStatistics> {
        /**
         * <p>
         * The number of requests that have resulted in a fault,
         * </p>
         * 
         * @param faultCount
         *        The number of requests that have resulted in a fault,
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faultCount(Long faultCount);

        /**
         * <p>
         * The number of successful requests.
         * </p>
         * 
         * @param okCount
         *        The number of successful requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okCount(Long okCount);

        /**
         * <p>
         * The total number of requests to the service.
         * </p>
         * 
         * @param totalCount
         *        The total number of requests to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Long totalCount);
    }

    static final class BuilderImpl implements Builder {
        private Long faultCount;

        private Long okCount;

        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestImpactStatistics model) {
            faultCount(model.faultCount);
            okCount(model.okCount);
            totalCount(model.totalCount);
        }

        public final Long getFaultCount() {
            return faultCount;
        }

        public final void setFaultCount(Long faultCount) {
            this.faultCount = faultCount;
        }

        @Override
        public final Builder faultCount(Long faultCount) {
            this.faultCount = faultCount;
            return this;
        }

        public final Long getOkCount() {
            return okCount;
        }

        public final void setOkCount(Long okCount) {
            this.okCount = okCount;
        }

        @Override
        public final Builder okCount(Long okCount) {
            this.okCount = okCount;
            return this;
        }

        public final Long getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public RequestImpactStatistics build() {
            return new RequestImpactStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
