/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSamplingRulesResponse extends XRayResponse implements
        ToCopyableBuilder<GetSamplingRulesResponse.Builder, GetSamplingRulesResponse> {
    private static final SdkField<List<SamplingRuleRecord>> SAMPLING_RULE_RECORDS_FIELD = SdkField
            .<List<SamplingRuleRecord>> builder(MarshallingType.LIST)
            .memberName("SamplingRuleRecords")
            .getter(getter(GetSamplingRulesResponse::samplingRuleRecords))
            .setter(setter(Builder::samplingRuleRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingRuleRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SamplingRuleRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(SamplingRuleRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetSamplingRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLING_RULE_RECORDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SamplingRuleRecord> samplingRuleRecords;

    private final String nextToken;

    private GetSamplingRulesResponse(BuilderImpl builder) {
        super(builder);
        this.samplingRuleRecords = builder.samplingRuleRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SamplingRuleRecords property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSamplingRuleRecords() {
        return samplingRuleRecords != null && !(samplingRuleRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Rule definitions and metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSamplingRuleRecords} method.
     * </p>
     * 
     * @return Rule definitions and metadata.
     */
    public final List<SamplingRuleRecord> samplingRuleRecords() {
        return samplingRuleRecords;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSamplingRuleRecords() ? samplingRuleRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSamplingRulesResponse)) {
            return false;
        }
        GetSamplingRulesResponse other = (GetSamplingRulesResponse) obj;
        return hasSamplingRuleRecords() == other.hasSamplingRuleRecords()
                && Objects.equals(samplingRuleRecords(), other.samplingRuleRecords())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSamplingRulesResponse")
                .add("SamplingRuleRecords", hasSamplingRuleRecords() ? samplingRuleRecords() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SamplingRuleRecords":
            return Optional.ofNullable(clazz.cast(samplingRuleRecords()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSamplingRulesResponse, T> g) {
        return obj -> g.apply((GetSamplingRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSamplingRulesResponse> {
        /**
         * <p>
         * Rule definitions and metadata.
         * </p>
         * 
         * @param samplingRuleRecords
         *        Rule definitions and metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingRuleRecords(Collection<SamplingRuleRecord> samplingRuleRecords);

        /**
         * <p>
         * Rule definitions and metadata.
         * </p>
         * 
         * @param samplingRuleRecords
         *        Rule definitions and metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingRuleRecords(SamplingRuleRecord... samplingRuleRecords);

        /**
         * <p>
         * Rule definitions and metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.SamplingRuleRecord.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.xray.model.SamplingRuleRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.SamplingRuleRecord.Builder#build()} is called immediately
         * and its result is passed to {@link #samplingRuleRecords(List<SamplingRuleRecord>)}.
         * 
         * @param samplingRuleRecords
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.SamplingRuleRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samplingRuleRecords(java.util.Collection<SamplingRuleRecord>)
         */
        Builder samplingRuleRecords(Consumer<SamplingRuleRecord.Builder>... samplingRuleRecords);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private List<SamplingRuleRecord> samplingRuleRecords = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSamplingRulesResponse model) {
            super(model);
            samplingRuleRecords(model.samplingRuleRecords);
            nextToken(model.nextToken);
        }

        public final List<SamplingRuleRecord.Builder> getSamplingRuleRecords() {
            List<SamplingRuleRecord.Builder> result = SamplingRuleRecordListCopier.copyToBuilder(this.samplingRuleRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSamplingRuleRecords(Collection<SamplingRuleRecord.BuilderImpl> samplingRuleRecords) {
            this.samplingRuleRecords = SamplingRuleRecordListCopier.copyFromBuilder(samplingRuleRecords);
        }

        @Override
        public final Builder samplingRuleRecords(Collection<SamplingRuleRecord> samplingRuleRecords) {
            this.samplingRuleRecords = SamplingRuleRecordListCopier.copy(samplingRuleRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samplingRuleRecords(SamplingRuleRecord... samplingRuleRecords) {
            samplingRuleRecords(Arrays.asList(samplingRuleRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samplingRuleRecords(Consumer<SamplingRuleRecord.Builder>... samplingRuleRecords) {
            samplingRuleRecords(Stream.of(samplingRuleRecords).map(c -> SamplingRuleRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetSamplingRulesResponse build() {
            return new GetSamplingRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
