/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration document that specifies encryption configuration settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionConfig.Builder, EncryptionConfig> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyId")
            .getter(getter(EncryptionConfig::keyId)).setter(setter(Builder::keyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EncryptionConfig::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(EncryptionConfig::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, STATUS_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String keyId;

    private final String status;

    private final String type;

    private EncryptionConfig(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID of the KMS key used for encryption, if applicable.
     * </p>
     * 
     * @return The ID of the KMS key used for encryption, if applicable.
     */
    public final String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The encryption status. While the status is <code>UPDATING</code>, X-Ray may encrypt data with a combination of
     * the new and old settings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EncryptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The encryption status. While the status is <code>UPDATING</code>, X-Ray may encrypt data with a
     *         combination of the new and old settings.
     * @see EncryptionStatus
     */
    public final EncryptionStatus status() {
        return EncryptionStatus.fromValue(status);
    }

    /**
     * <p>
     * The encryption status. While the status is <code>UPDATING</code>, X-Ray may encrypt data with a combination of
     * the new and old settings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EncryptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The encryption status. While the status is <code>UPDATING</code>, X-Ray may encrypt data with a
     *         combination of the new and old settings.
     * @see EncryptionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of encryption. Set to <code>KMS</code> for encryption with KMS keys. Set to <code>NONE</code> for
     * default encryption.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of encryption. Set to <code>KMS</code> for encryption with KMS keys. Set to <code>NONE</code>
     *         for default encryption.
     * @see EncryptionType
     */
    public final EncryptionType type() {
        return EncryptionType.fromValue(type);
    }

    /**
     * <p>
     * The type of encryption. Set to <code>KMS</code> for encryption with KMS keys. Set to <code>NONE</code> for
     * default encryption.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of encryption. Set to <code>KMS</code> for encryption with KMS keys. Set to <code>NONE</code>
     *         for default encryption.
     * @see EncryptionType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfig)) {
            return false;
        }
        EncryptionConfig other = (EncryptionConfig) obj;
        return Objects.equals(keyId(), other.keyId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionConfig").add("KeyId", keyId()).add("Status", statusAsString())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfig, T> g) {
        return obj -> g.apply((EncryptionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionConfig> {
        /**
         * <p>
         * The ID of the KMS key used for encryption, if applicable.
         * </p>
         * 
         * @param keyId
         *        The ID of the KMS key used for encryption, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The encryption status. While the status is <code>UPDATING</code>, X-Ray may encrypt data with a combination
         * of the new and old settings.
         * </p>
         * 
         * @param status
         *        The encryption status. While the status is <code>UPDATING</code>, X-Ray may encrypt data with a
         *        combination of the new and old settings.
         * @see EncryptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The encryption status. While the status is <code>UPDATING</code>, X-Ray may encrypt data with a combination
         * of the new and old settings.
         * </p>
         * 
         * @param status
         *        The encryption status. While the status is <code>UPDATING</code>, X-Ray may encrypt data with a
         *        combination of the new and old settings.
         * @see EncryptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionStatus
         */
        Builder status(EncryptionStatus status);

        /**
         * <p>
         * The type of encryption. Set to <code>KMS</code> for encryption with KMS keys. Set to <code>NONE</code> for
         * default encryption.
         * </p>
         * 
         * @param type
         *        The type of encryption. Set to <code>KMS</code> for encryption with KMS keys. Set to <code>NONE</code>
         *        for default encryption.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of encryption. Set to <code>KMS</code> for encryption with KMS keys. Set to <code>NONE</code> for
         * default encryption.
         * </p>
         * 
         * @param type
         *        The type of encryption. Set to <code>KMS</code> for encryption with KMS keys. Set to <code>NONE</code>
         *        for default encryption.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder type(EncryptionType type);
    }

    static final class BuilderImpl implements Builder {
        private String keyId;

        private String status;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfig model) {
            keyId(model.keyId);
            status(model.status);
            type(model.type);
        }

        public final String getKeyId() {
            return keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EncryptionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EncryptionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public EncryptionConfig build() {
            return new EncryptionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
