/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a folder.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FolderMetadata implements SdkPojo, Serializable, ToCopyableBuilder<FolderMetadata.Builder, FolderMetadata> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(FolderMetadata::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(FolderMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CREATOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorId").getter(getter(FolderMetadata::creatorId)).setter(setter(Builder::creatorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorId").build()).build();

    private static final SdkField<String> PARENT_FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentFolderId").getter(getter(FolderMetadata::parentFolderId)).setter(setter(Builder::parentFolderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentFolderId").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(FolderMetadata::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedTimestamp").getter(getter(FolderMetadata::modifiedTimestamp))
            .setter(setter(Builder::modifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedTimestamp").build()).build();

    private static final SdkField<String> RESOURCE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceState").getter(getter(FolderMetadata::resourceStateAsString))
            .setter(setter(Builder::resourceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceState").build()).build();

    private static final SdkField<String> SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Signature").getter(getter(FolderMetadata::signature)).setter(setter(Builder::signature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signature").build()).build();

    private static final SdkField<List<String>> LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Labels")
            .getter(getter(FolderMetadata::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Size")
            .getter(getter(FolderMetadata::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final SdkField<Long> LATEST_VERSION_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LatestVersionSize").getter(getter(FolderMetadata::latestVersionSize))
            .setter(setter(Builder::latestVersionSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            CREATOR_ID_FIELD, PARENT_FOLDER_ID_FIELD, CREATED_TIMESTAMP_FIELD, MODIFIED_TIMESTAMP_FIELD, RESOURCE_STATE_FIELD,
            SIGNATURE_FIELD, LABELS_FIELD, SIZE_FIELD, LATEST_VERSION_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String creatorId;

    private final String parentFolderId;

    private final Instant createdTimestamp;

    private final Instant modifiedTimestamp;

    private final String resourceState;

    private final String signature;

    private final List<String> labels;

    private final Long size;

    private final Long latestVersionSize;

    private FolderMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.creatorId = builder.creatorId;
        this.parentFolderId = builder.parentFolderId;
        this.createdTimestamp = builder.createdTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.resourceState = builder.resourceState;
        this.signature = builder.signature;
        this.labels = builder.labels;
        this.size = builder.size;
        this.latestVersionSize = builder.latestVersionSize;
    }

    /**
     * <p>
     * The ID of the folder.
     * </p>
     * 
     * @return The ID of the folder.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the folder.
     * </p>
     * 
     * @return The name of the folder.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the creator.
     * </p>
     * 
     * @return The ID of the creator.
     */
    public final String creatorId() {
        return creatorId;
    }

    /**
     * <p>
     * The ID of the parent folder.
     * </p>
     * 
     * @return The ID of the parent folder.
     */
    public final String parentFolderId() {
        return parentFolderId;
    }

    /**
     * <p>
     * The time when the folder was created.
     * </p>
     * 
     * @return The time when the folder was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time when the folder was updated.
     * </p>
     * 
     * @return The time when the folder was updated.
     */
    public final Instant modifiedTimestamp() {
        return modifiedTimestamp;
    }

    /**
     * <p>
     * The resource state of the folder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceState}
     * will return {@link ResourceStateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStateAsString}.
     * </p>
     * 
     * @return The resource state of the folder.
     * @see ResourceStateType
     */
    public final ResourceStateType resourceState() {
        return ResourceStateType.fromValue(resourceState);
    }

    /**
     * <p>
     * The resource state of the folder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceState}
     * will return {@link ResourceStateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStateAsString}.
     * </p>
     * 
     * @return The resource state of the folder.
     * @see ResourceStateType
     */
    public final String resourceStateAsString() {
        return resourceState;
    }

    /**
     * <p>
     * The unique identifier created from the subfolders and documents of the folder.
     * </p>
     * 
     * @return The unique identifier created from the subfolders and documents of the folder.
     */
    public final String signature() {
        return signature;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of labels on the folder.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return List of labels on the folder.
     */
    public final List<String> labels() {
        return labels;
    }

    /**
     * <p>
     * The size of the folder metadata.
     * </p>
     * 
     * @return The size of the folder metadata.
     */
    public final Long size() {
        return size;
    }

    /**
     * <p>
     * The size of the latest version of the folder metadata.
     * </p>
     * 
     * @return The size of the latest version of the folder metadata.
     */
    public final Long latestVersionSize() {
        return latestVersionSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(creatorId());
        hashCode = 31 * hashCode + Objects.hashCode(parentFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(signature());
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FolderMetadata)) {
            return false;
        }
        FolderMetadata other = (FolderMetadata) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(creatorId(), other.creatorId()) && Objects.equals(parentFolderId(), other.parentFolderId())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(modifiedTimestamp(), other.modifiedTimestamp())
                && Objects.equals(resourceStateAsString(), other.resourceStateAsString())
                && Objects.equals(signature(), other.signature()) && hasLabels() == other.hasLabels()
                && Objects.equals(labels(), other.labels()) && Objects.equals(size(), other.size())
                && Objects.equals(latestVersionSize(), other.latestVersionSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FolderMetadata").add("Id", id())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("CreatorId", creatorId())
                .add("ParentFolderId", parentFolderId()).add("CreatedTimestamp", createdTimestamp())
                .add("ModifiedTimestamp", modifiedTimestamp()).add("ResourceState", resourceStateAsString())
                .add("Signature", signature()).add("Labels", hasLabels() ? labels() : null).add("Size", size())
                .add("LatestVersionSize", latestVersionSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreatorId":
            return Optional.ofNullable(clazz.cast(creatorId()));
        case "ParentFolderId":
            return Optional.ofNullable(clazz.cast(parentFolderId()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "ModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(modifiedTimestamp()));
        case "ResourceState":
            return Optional.ofNullable(clazz.cast(resourceStateAsString()));
        case "Signature":
            return Optional.ofNullable(clazz.cast(signature()));
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "LatestVersionSize":
            return Optional.ofNullable(clazz.cast(latestVersionSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FolderMetadata, T> g) {
        return obj -> g.apply((FolderMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FolderMetadata> {
        /**
         * <p>
         * The ID of the folder.
         * </p>
         * 
         * @param id
         *        The ID of the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the folder.
         * </p>
         * 
         * @param name
         *        The name of the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the creator.
         * </p>
         * 
         * @param creatorId
         *        The ID of the creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorId(String creatorId);

        /**
         * <p>
         * The ID of the parent folder.
         * </p>
         * 
         * @param parentFolderId
         *        The ID of the parent folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentFolderId(String parentFolderId);

        /**
         * <p>
         * The time when the folder was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the folder was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time when the folder was updated.
         * </p>
         * 
         * @param modifiedTimestamp
         *        The time when the folder was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedTimestamp(Instant modifiedTimestamp);

        /**
         * <p>
         * The resource state of the folder.
         * </p>
         * 
         * @param resourceState
         *        The resource state of the folder.
         * @see ResourceStateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStateType
         */
        Builder resourceState(String resourceState);

        /**
         * <p>
         * The resource state of the folder.
         * </p>
         * 
         * @param resourceState
         *        The resource state of the folder.
         * @see ResourceStateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStateType
         */
        Builder resourceState(ResourceStateType resourceState);

        /**
         * <p>
         * The unique identifier created from the subfolders and documents of the folder.
         * </p>
         * 
         * @param signature
         *        The unique identifier created from the subfolders and documents of the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(String signature);

        /**
         * <p>
         * List of labels on the folder.
         * </p>
         * 
         * @param labels
         *        List of labels on the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<String> labels);

        /**
         * <p>
         * List of labels on the folder.
         * </p>
         * 
         * @param labels
         *        List of labels on the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(String... labels);

        /**
         * <p>
         * The size of the folder metadata.
         * </p>
         * 
         * @param size
         *        The size of the folder metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);

        /**
         * <p>
         * The size of the latest version of the folder metadata.
         * </p>
         * 
         * @param latestVersionSize
         *        The size of the latest version of the folder metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionSize(Long latestVersionSize);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String creatorId;

        private String parentFolderId;

        private Instant createdTimestamp;

        private Instant modifiedTimestamp;

        private String resourceState;

        private String signature;

        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private Long size;

        private Long latestVersionSize;

        private BuilderImpl() {
        }

        private BuilderImpl(FolderMetadata model) {
            id(model.id);
            name(model.name);
            creatorId(model.creatorId);
            parentFolderId(model.parentFolderId);
            createdTimestamp(model.createdTimestamp);
            modifiedTimestamp(model.modifiedTimestamp);
            resourceState(model.resourceState);
            signature(model.signature);
            labels(model.labels);
            size(model.size);
            latestVersionSize(model.latestVersionSize);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCreatorId() {
            return creatorId;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final String getParentFolderId() {
            return parentFolderId;
        }

        public final void setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
        }

        @Override
        public final Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getModifiedTimestamp() {
            return modifiedTimestamp;
        }

        public final void setModifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public final String getResourceState() {
            return resourceState;
        }

        public final void setResourceState(String resourceState) {
            this.resourceState = resourceState;
        }

        @Override
        public final Builder resourceState(String resourceState) {
            this.resourceState = resourceState;
            return this;
        }

        @Override
        public final Builder resourceState(ResourceStateType resourceState) {
            this.resourceState(resourceState == null ? null : resourceState.toString());
            return this;
        }

        public final String getSignature() {
            return signature;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final Collection<String> getLabels() {
            if (labels instanceof SdkAutoConstructList) {
                return null;
            }
            return labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        public final Long getSize() {
            return size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final Long getLatestVersionSize() {
            return latestVersionSize;
        }

        public final void setLatestVersionSize(Long latestVersionSize) {
            this.latestVersionSize = latestVersionSize;
        }

        @Override
        public final Builder latestVersionSize(Long latestVersionSize) {
            this.latestVersionSize = latestVersionSize;
            return this;
        }

        @Override
        public FolderMetadata build() {
            return new FolderMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
