/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public class AddCommentToMethod
extends Recipe {
    private static final String COMMENT_PREFIX = "AWS SDK for Java v2 migration: ";
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="org.mockito.Matchers anyVararg()")
    private final String methodPattern;
    @Option(displayName="Comment", description="A comment to add to this method.", example="This method is not supported in AWS SDK for Java v2.")
    private final String comment;

    @JsonCreator
    public AddCommentToMethod(@JsonProperty(value="methodPattern") String methodPattern, @JsonProperty(value="comment") String comment) {
        this.methodPattern = methodPattern;
        this.comment = comment;
    }

    public String getDisplayName() {
        return "Add a comment to a method";
    }

    public String getDescription() {
        return "Add a comment to a method.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor(this.methodPattern, this.comment);
    }

    private static final class Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;
        private final String comment;
        private final Comment commentToAdd;

        Visitor(String methodPattern, String comment) {
            this.methodMatcher = new MethodMatcher(methodPattern, false);
            this.comment = AddCommentToMethod.COMMENT_PREFIX + comment;
            this.commentToAdd = new TextComment(true, this.comment, "", Markers.EMPTY);
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext executionContext) {
            J.MethodInvocation method = super.visitMethodInvocation(methodInvocation, (Object)executionContext);
            if (!this.methodMatcher.matches((MethodCall)method)) {
                return method;
            }
            J.MethodInvocation.Padding padding = method.getPadding();
            JRightPadded select = padding.getSelect();
            if (select == null) {
                return method;
            }
            Space after = select.getAfter();
            ArrayList<Comment> comments = new ArrayList<Comment>(after.getComments());
            if (comments.contains(this.commentToAdd)) {
                return method;
            }
            comments.add(this.commentToAdd);
            after = after.withComments(comments);
            return new J.MethodInvocation(method.getId(), method.getPrefix(), method.getMarkers(), select.withAfter(after), padding.getTypeParameters(), method.getName(), padding.getArguments(), method.getMethodType());
        }
    }
}

