/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.internal.UserAgentUtils;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse;

public class ListCallAnalyticsJobsIterable
implements SdkIterable<ListCallAnalyticsJobsResponse> {
    private final TranscribeClient client;
    private final ListCallAnalyticsJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCallAnalyticsJobsIterable(TranscribeClient client, ListCallAnalyticsJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCallAnalyticsJobsResponseFetcher();
    }

    public Iterator<ListCallAnalyticsJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCallAnalyticsJobsResponseFetcher
    implements SyncPageFetcher<ListCallAnalyticsJobsResponse> {
        private ListCallAnalyticsJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListCallAnalyticsJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCallAnalyticsJobsResponse nextPage(ListCallAnalyticsJobsResponse previousPage) {
            if (previousPage == null) {
                return ListCallAnalyticsJobsIterable.this.client.listCallAnalyticsJobs(ListCallAnalyticsJobsIterable.this.firstRequest);
            }
            return ListCallAnalyticsJobsIterable.this.client.listCallAnalyticsJobs((ListCallAnalyticsJobsRequest)((Object)ListCallAnalyticsJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

