/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SubtitleFormat {
    VTT("vtt"),
    SRT("srt"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SubtitleFormat> VALUE_MAP;
    private final String value;

    private SubtitleFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SubtitleFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SubtitleFormat> knownValues() {
        EnumSet<SubtitleFormat> knownValues = EnumSet.allOf(SubtitleFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SubtitleFormat.class, SubtitleFormat::toString);
    }
}

