/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OutputLocationType {
    CUSTOMER_BUCKET("CUSTOMER_BUCKET"),
    SERVICE_BUCKET("SERVICE_BUCKET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OutputLocationType> VALUE_MAP;
    private final String value;

    private OutputLocationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OutputLocationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OutputLocationType> knownValues() {
        EnumSet<OutputLocationType> knownValues = EnumSet.allOf(OutputLocationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OutputLocationType.class, OutputLocationType::toString);
    }
}

