/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FileShareType {
    NFS("NFS"),
    SMB("SMB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FileShareType> VALUE_MAP;
    private final String value;

    private FileShareType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FileShareType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FileShareType> knownValues() {
        EnumSet<FileShareType> knownValues = EnumSet.allOf(FileShareType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FileShareType.class, FileShareType::toString);
    }
}

