/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines configuration settings for an application that supports the JWT Bearer Token Authorization
 * Grant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JwtBearerGrant implements SdkPojo, Serializable, ToCopyableBuilder<JwtBearerGrant.Builder, JwtBearerGrant> {
    private static final SdkField<List<AuthorizedTokenIssuer>> AUTHORIZED_TOKEN_ISSUERS_FIELD = SdkField
            .<List<AuthorizedTokenIssuer>> builder(MarshallingType.LIST)
            .memberName("AuthorizedTokenIssuers")
            .getter(getter(JwtBearerGrant::authorizedTokenIssuers))
            .setter(setter(Builder::authorizedTokenIssuers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedTokenIssuers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthorizedTokenIssuer> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthorizedTokenIssuer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AUTHORIZED_TOKEN_ISSUERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AuthorizedTokenIssuer> authorizedTokenIssuers;

    private JwtBearerGrant(BuilderImpl builder) {
        this.authorizedTokenIssuers = builder.authorizedTokenIssuers;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedTokenIssuers property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAuthorizedTokenIssuers() {
        return authorizedTokenIssuers != null && !(authorizedTokenIssuers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of allowed token issuers trusted by the Identity Center instances for this application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedTokenIssuers} method.
     * </p>
     * 
     * @return A list of allowed token issuers trusted by the Identity Center instances for this application.
     */
    public final List<AuthorizedTokenIssuer> authorizedTokenIssuers() {
        return authorizedTokenIssuers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedTokenIssuers() ? authorizedTokenIssuers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JwtBearerGrant)) {
            return false;
        }
        JwtBearerGrant other = (JwtBearerGrant) obj;
        return hasAuthorizedTokenIssuers() == other.hasAuthorizedTokenIssuers()
                && Objects.equals(authorizedTokenIssuers(), other.authorizedTokenIssuers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JwtBearerGrant")
                .add("AuthorizedTokenIssuers", hasAuthorizedTokenIssuers() ? authorizedTokenIssuers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizedTokenIssuers":
            return Optional.ofNullable(clazz.cast(authorizedTokenIssuers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JwtBearerGrant, T> g) {
        return obj -> g.apply((JwtBearerGrant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JwtBearerGrant> {
        /**
         * <p>
         * A list of allowed token issuers trusted by the Identity Center instances for this application.
         * </p>
         * 
         * @param authorizedTokenIssuers
         *        A list of allowed token issuers trusted by the Identity Center instances for this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedTokenIssuers(Collection<AuthorizedTokenIssuer> authorizedTokenIssuers);

        /**
         * <p>
         * A list of allowed token issuers trusted by the Identity Center instances for this application.
         * </p>
         * 
         * @param authorizedTokenIssuers
         *        A list of allowed token issuers trusted by the Identity Center instances for this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedTokenIssuers(AuthorizedTokenIssuer... authorizedTokenIssuers);

        /**
         * <p>
         * A list of allowed token issuers trusted by the Identity Center instances for this application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssoadmin.model.AuthorizedTokenIssuer.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ssoadmin.model.AuthorizedTokenIssuer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssoadmin.model.AuthorizedTokenIssuer.Builder#build()} is called
         * immediately and its result is passed to {@link #authorizedTokenIssuers(List<AuthorizedTokenIssuer>)}.
         * 
         * @param authorizedTokenIssuers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssoadmin.model.AuthorizedTokenIssuer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizedTokenIssuers(java.util.Collection<AuthorizedTokenIssuer>)
         */
        Builder authorizedTokenIssuers(Consumer<AuthorizedTokenIssuer.Builder>... authorizedTokenIssuers);
    }

    static final class BuilderImpl implements Builder {
        private List<AuthorizedTokenIssuer> authorizedTokenIssuers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JwtBearerGrant model) {
            authorizedTokenIssuers(model.authorizedTokenIssuers);
        }

        public final List<AuthorizedTokenIssuer.Builder> getAuthorizedTokenIssuers() {
            List<AuthorizedTokenIssuer.Builder> result = AuthorizedTokenIssuersCopier.copyToBuilder(this.authorizedTokenIssuers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthorizedTokenIssuers(Collection<AuthorizedTokenIssuer.BuilderImpl> authorizedTokenIssuers) {
            this.authorizedTokenIssuers = AuthorizedTokenIssuersCopier.copyFromBuilder(authorizedTokenIssuers);
        }

        @Override
        public final Builder authorizedTokenIssuers(Collection<AuthorizedTokenIssuer> authorizedTokenIssuers) {
            this.authorizedTokenIssuers = AuthorizedTokenIssuersCopier.copy(authorizedTokenIssuers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTokenIssuers(AuthorizedTokenIssuer... authorizedTokenIssuers) {
            authorizedTokenIssuers(Arrays.asList(authorizedTokenIssuers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTokenIssuers(Consumer<AuthorizedTokenIssuer.Builder>... authorizedTokenIssuers) {
            authorizedTokenIssuers(Stream.of(authorizedTokenIssuers)
                    .map(c -> AuthorizedTokenIssuer.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public JwtBearerGrant build() {
            return new JwtBearerGrant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
