/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains validation parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserDataValidationParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<UserDataValidationParameters.Builder, UserDataValidationParameters> {
    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(UserDataValidationParameters::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> SCRIPT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scriptType").getter(getter(UserDataValidationParameters::scriptTypeAsString))
            .setter(setter(Builder::scriptType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            SCRIPT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Source source;

    private final String scriptType;

    private UserDataValidationParameters(BuilderImpl builder) {
        this.source = builder.source;
        this.scriptType = builder.scriptType;
    }

    /**
     * <p>
     * The location of the validation script.
     * </p>
     * 
     * @return The location of the validation script.
     */
    public final Source source() {
        return source;
    }

    /**
     * <p>
     * The type of validation script.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scriptType} will
     * return {@link ScriptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scriptTypeAsString}.
     * </p>
     * 
     * @return The type of validation script.
     * @see ScriptType
     */
    public final ScriptType scriptType() {
        return ScriptType.fromValue(scriptType);
    }

    /**
     * <p>
     * The type of validation script.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scriptType} will
     * return {@link ScriptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scriptTypeAsString}.
     * </p>
     * 
     * @return The type of validation script.
     * @see ScriptType
     */
    public final String scriptTypeAsString() {
        return scriptType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(scriptTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserDataValidationParameters)) {
            return false;
        }
        UserDataValidationParameters other = (UserDataValidationParameters) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(scriptTypeAsString(), other.scriptTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserDataValidationParameters").add("Source", source()).add("ScriptType", scriptTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "scriptType":
            return Optional.ofNullable(clazz.cast(scriptTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserDataValidationParameters, T> g) {
        return obj -> g.apply((UserDataValidationParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserDataValidationParameters> {
        /**
         * <p>
         * The location of the validation script.
         * </p>
         * 
         * @param source
         *        The location of the validation script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * <p>
         * The location of the validation script.
         * </p>
         * This is a convenience method that creates an instance of the {@link Source.Builder} avoiding the need to
         * create one manually via {@link Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The type of validation script.
         * </p>
         * 
         * @param scriptType
         *        The type of validation script.
         * @see ScriptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScriptType
         */
        Builder scriptType(String scriptType);

        /**
         * <p>
         * The type of validation script.
         * </p>
         * 
         * @param scriptType
         *        The type of validation script.
         * @see ScriptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScriptType
         */
        Builder scriptType(ScriptType scriptType);
    }

    static final class BuilderImpl implements Builder {
        private Source source;

        private String scriptType;

        private BuilderImpl() {
        }

        private BuilderImpl(UserDataValidationParameters model) {
            source(model.source);
            scriptType(model.scriptType);
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final String getScriptType() {
            return scriptType;
        }

        public final void setScriptType(String scriptType) {
            this.scriptType = scriptType;
        }

        @Override
        public final Builder scriptType(String scriptType) {
            this.scriptType = scriptType;
            return this;
        }

        @Override
        public final Builder scriptType(ScriptType scriptType) {
            this.scriptType(scriptType == null ? null : scriptType.toString());
            return this;
        }

        @Override
        public UserDataValidationParameters build() {
            return new UserDataValidationParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
