/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Launch configuration for a server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerLaunchConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerLaunchConfiguration.Builder, ServerLaunchConfiguration> {
    private static final SdkField<Server> SERVER_FIELD = SdkField.<Server> builder(MarshallingType.SDK_POJO).memberName("server")
            .getter(getter(ServerLaunchConfiguration::server)).setter(setter(Builder::server)).constructor(Server::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("server").build()).build();

    private static final SdkField<String> LOGICAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logicalId").getter(getter(ServerLaunchConfiguration::logicalId)).setter(setter(Builder::logicalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalId").build()).build();

    private static final SdkField<String> VPC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vpc")
            .getter(getter(ServerLaunchConfiguration::vpc)).setter(setter(Builder::vpc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()).build();

    private static final SdkField<String> SUBNET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("subnet")
            .getter(getter(ServerLaunchConfiguration::subnet)).setter(setter(Builder::subnet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnet").build()).build();

    private static final SdkField<String> SECURITY_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityGroup").getter(getter(ServerLaunchConfiguration::securityGroup))
            .setter(setter(Builder::securityGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroup").build()).build();

    private static final SdkField<String> EC2_KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2KeyName").getter(getter(ServerLaunchConfiguration::ec2KeyName)).setter(setter(Builder::ec2KeyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2KeyName").build()).build();

    private static final SdkField<UserData> USER_DATA_FIELD = SdkField.<UserData> builder(MarshallingType.SDK_POJO)
            .memberName("userData").getter(getter(ServerLaunchConfiguration::userData)).setter(setter(Builder::userData))
            .constructor(UserData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userData").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(ServerLaunchConfiguration::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("associatePublicIpAddress")
            .getter(getter(ServerLaunchConfiguration::associatePublicIpAddress))
            .setter(setter(Builder::associatePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatePublicIpAddress").build())
            .build();

    private static final SdkField<String> IAM_INSTANCE_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamInstanceProfileName").getter(getter(ServerLaunchConfiguration::iamInstanceProfileName))
            .setter(setter(Builder::iamInstanceProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamInstanceProfileName").build())
            .build();

    private static final SdkField<S3Location> CONFIGURE_SCRIPT_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("configureScript").getter(getter(ServerLaunchConfiguration::configureScript))
            .setter(setter(Builder::configureScript)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configureScript").build()).build();

    private static final SdkField<String> CONFIGURE_SCRIPT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configureScriptType").getter(getter(ServerLaunchConfiguration::configureScriptTypeAsString))
            .setter(setter(Builder::configureScriptType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configureScriptType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_FIELD,
            LOGICAL_ID_FIELD, VPC_FIELD, SUBNET_FIELD, SECURITY_GROUP_FIELD, EC2_KEY_NAME_FIELD, USER_DATA_FIELD,
            INSTANCE_TYPE_FIELD, ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, IAM_INSTANCE_PROFILE_NAME_FIELD, CONFIGURE_SCRIPT_FIELD,
            CONFIGURE_SCRIPT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Server server;

    private final String logicalId;

    private final String vpc;

    private final String subnet;

    private final String securityGroup;

    private final String ec2KeyName;

    private final UserData userData;

    private final String instanceType;

    private final Boolean associatePublicIpAddress;

    private final String iamInstanceProfileName;

    private final S3Location configureScript;

    private final String configureScriptType;

    private ServerLaunchConfiguration(BuilderImpl builder) {
        this.server = builder.server;
        this.logicalId = builder.logicalId;
        this.vpc = builder.vpc;
        this.subnet = builder.subnet;
        this.securityGroup = builder.securityGroup;
        this.ec2KeyName = builder.ec2KeyName;
        this.userData = builder.userData;
        this.instanceType = builder.instanceType;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.iamInstanceProfileName = builder.iamInstanceProfileName;
        this.configureScript = builder.configureScript;
        this.configureScriptType = builder.configureScriptType;
    }

    /**
     * <p>
     * The ID of the server with which the launch configuration is associated.
     * </p>
     * 
     * @return The ID of the server with which the launch configuration is associated.
     */
    public final Server server() {
        return server;
    }

    /**
     * <p>
     * The logical ID of the server in the CloudFormation template.
     * </p>
     * 
     * @return The logical ID of the server in the CloudFormation template.
     */
    public final String logicalId() {
        return logicalId;
    }

    /**
     * <p>
     * The ID of the VPC into which the server should be launched.
     * </p>
     * 
     * @return The ID of the VPC into which the server should be launched.
     */
    public final String vpc() {
        return vpc;
    }

    /**
     * <p>
     * The ID of the subnet the server should be launched into.
     * </p>
     * 
     * @return The ID of the subnet the server should be launched into.
     */
    public final String subnet() {
        return subnet;
    }

    /**
     * <p>
     * The ID of the security group that applies to the launched server.
     * </p>
     * 
     * @return The ID of the security group that applies to the launched server.
     */
    public final String securityGroup() {
        return securityGroup;
    }

    /**
     * <p>
     * The name of the Amazon EC2 SSH key to be used for connecting to the launched server.
     * </p>
     * 
     * @return The name of the Amazon EC2 SSH key to be used for connecting to the launched server.
     */
    public final String ec2KeyName() {
        return ec2KeyName;
    }

    /**
     * <p>
     * Location of the user-data script to be executed when launching the server.
     * </p>
     * 
     * @return Location of the user-data script to be executed when launching the server.
     */
    public final UserData userData() {
        return userData;
    }

    /**
     * <p>
     * The instance type to use when launching the server.
     * </p>
     * 
     * @return The instance type to use when launching the server.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * Indicates whether a publicly accessible IP address is created when launching the server.
     * </p>
     * 
     * @return Indicates whether a publicly accessible IP address is created when launching the server.
     */
    public final Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * The name of the IAM instance profile.
     * </p>
     * 
     * @return The name of the IAM instance profile.
     */
    public final String iamInstanceProfileName() {
        return iamInstanceProfileName;
    }

    /**
     * Returns the value of the ConfigureScript property for this object.
     * 
     * @return The value of the ConfigureScript property for this object.
     */
    public final S3Location configureScript() {
        return configureScript;
    }

    /**
     * <p>
     * The type of configuration script.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configureScriptType} will return {@link ScriptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #configureScriptTypeAsString}.
     * </p>
     * 
     * @return The type of configuration script.
     * @see ScriptType
     */
    public final ScriptType configureScriptType() {
        return ScriptType.fromValue(configureScriptType);
    }

    /**
     * <p>
     * The type of configuration script.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configureScriptType} will return {@link ScriptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #configureScriptTypeAsString}.
     * </p>
     * 
     * @return The type of configuration script.
     * @see ScriptType
     */
    public final String configureScriptTypeAsString() {
        return configureScriptType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(server());
        hashCode = 31 * hashCode + Objects.hashCode(logicalId());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(subnet());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(ec2KeyName());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(configureScript());
        hashCode = 31 * hashCode + Objects.hashCode(configureScriptTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerLaunchConfiguration)) {
            return false;
        }
        ServerLaunchConfiguration other = (ServerLaunchConfiguration) obj;
        return Objects.equals(server(), other.server()) && Objects.equals(logicalId(), other.logicalId())
                && Objects.equals(vpc(), other.vpc()) && Objects.equals(subnet(), other.subnet())
                && Objects.equals(securityGroup(), other.securityGroup()) && Objects.equals(ec2KeyName(), other.ec2KeyName())
                && Objects.equals(userData(), other.userData()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && Objects.equals(iamInstanceProfileName(), other.iamInstanceProfileName())
                && Objects.equals(configureScript(), other.configureScript())
                && Objects.equals(configureScriptTypeAsString(), other.configureScriptTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerLaunchConfiguration").add("Server", server()).add("LogicalId", logicalId())
                .add("Vpc", vpc()).add("Subnet", subnet()).add("SecurityGroup", securityGroup()).add("Ec2KeyName", ec2KeyName())
                .add("UserData", userData()).add("InstanceType", instanceType())
                .add("AssociatePublicIpAddress", associatePublicIpAddress())
                .add("IamInstanceProfileName", iamInstanceProfileName()).add("ConfigureScript", configureScript())
                .add("ConfigureScriptType", configureScriptTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "server":
            return Optional.ofNullable(clazz.cast(server()));
        case "logicalId":
            return Optional.ofNullable(clazz.cast(logicalId()));
        case "vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "subnet":
            return Optional.ofNullable(clazz.cast(subnet()));
        case "securityGroup":
            return Optional.ofNullable(clazz.cast(securityGroup()));
        case "ec2KeyName":
            return Optional.ofNullable(clazz.cast(ec2KeyName()));
        case "userData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "associatePublicIpAddress":
            return Optional.ofNullable(clazz.cast(associatePublicIpAddress()));
        case "iamInstanceProfileName":
            return Optional.ofNullable(clazz.cast(iamInstanceProfileName()));
        case "configureScript":
            return Optional.ofNullable(clazz.cast(configureScript()));
        case "configureScriptType":
            return Optional.ofNullable(clazz.cast(configureScriptTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerLaunchConfiguration, T> g) {
        return obj -> g.apply((ServerLaunchConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerLaunchConfiguration> {
        /**
         * <p>
         * The ID of the server with which the launch configuration is associated.
         * </p>
         * 
         * @param server
         *        The ID of the server with which the launch configuration is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder server(Server server);

        /**
         * <p>
         * The ID of the server with which the launch configuration is associated.
         * </p>
         * This is a convenience method that creates an instance of the {@link Server.Builder} avoiding the need to
         * create one manually via {@link Server#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Server.Builder#build()} is called immediately and its result is
         * passed to {@link #server(Server)}.
         * 
         * @param server
         *        a consumer that will call methods on {@link Server.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #server(Server)
         */
        default Builder server(Consumer<Server.Builder> server) {
            return server(Server.builder().applyMutation(server).build());
        }

        /**
         * <p>
         * The logical ID of the server in the CloudFormation template.
         * </p>
         * 
         * @param logicalId
         *        The logical ID of the server in the CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalId(String logicalId);

        /**
         * <p>
         * The ID of the VPC into which the server should be launched.
         * </p>
         * 
         * @param vpc
         *        The ID of the VPC into which the server should be launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(String vpc);

        /**
         * <p>
         * The ID of the subnet the server should be launched into.
         * </p>
         * 
         * @param subnet
         *        The ID of the subnet the server should be launched into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnet(String subnet);

        /**
         * <p>
         * The ID of the security group that applies to the launched server.
         * </p>
         * 
         * @param securityGroup
         *        The ID of the security group that applies to the launched server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroup(String securityGroup);

        /**
         * <p>
         * The name of the Amazon EC2 SSH key to be used for connecting to the launched server.
         * </p>
         * 
         * @param ec2KeyName
         *        The name of the Amazon EC2 SSH key to be used for connecting to the launched server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2KeyName(String ec2KeyName);

        /**
         * <p>
         * Location of the user-data script to be executed when launching the server.
         * </p>
         * 
         * @param userData
         *        Location of the user-data script to be executed when launching the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(UserData userData);

        /**
         * <p>
         * Location of the user-data script to be executed when launching the server.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserData.Builder} avoiding the need to
         * create one manually via {@link UserData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserData.Builder#build()} is called immediately and its result is
         * passed to {@link #userData(UserData)}.
         * 
         * @param userData
         *        a consumer that will call methods on {@link UserData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userData(UserData)
         */
        default Builder userData(Consumer<UserData.Builder> userData) {
            return userData(UserData.builder().applyMutation(userData).build());
        }

        /**
         * <p>
         * The instance type to use when launching the server.
         * </p>
         * 
         * @param instanceType
         *        The instance type to use when launching the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * Indicates whether a publicly accessible IP address is created when launching the server.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Indicates whether a publicly accessible IP address is created when launching the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * The name of the IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfileName
         *        The name of the IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileName(String iamInstanceProfileName);

        /**
         * Sets the value of the ConfigureScript property for this object.
         *
         * @param configureScript
         *        The new value for the ConfigureScript property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configureScript(S3Location configureScript);

        /**
         * Sets the value of the ConfigureScript property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #configureScript(S3Location)}.
         * 
         * @param configureScript
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configureScript(S3Location)
         */
        default Builder configureScript(Consumer<S3Location.Builder> configureScript) {
            return configureScript(S3Location.builder().applyMutation(configureScript).build());
        }

        /**
         * <p>
         * The type of configuration script.
         * </p>
         * 
         * @param configureScriptType
         *        The type of configuration script.
         * @see ScriptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScriptType
         */
        Builder configureScriptType(String configureScriptType);

        /**
         * <p>
         * The type of configuration script.
         * </p>
         * 
         * @param configureScriptType
         *        The type of configuration script.
         * @see ScriptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScriptType
         */
        Builder configureScriptType(ScriptType configureScriptType);
    }

    static final class BuilderImpl implements Builder {
        private Server server;

        private String logicalId;

        private String vpc;

        private String subnet;

        private String securityGroup;

        private String ec2KeyName;

        private UserData userData;

        private String instanceType;

        private Boolean associatePublicIpAddress;

        private String iamInstanceProfileName;

        private S3Location configureScript;

        private String configureScriptType;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerLaunchConfiguration model) {
            server(model.server);
            logicalId(model.logicalId);
            vpc(model.vpc);
            subnet(model.subnet);
            securityGroup(model.securityGroup);
            ec2KeyName(model.ec2KeyName);
            userData(model.userData);
            instanceType(model.instanceType);
            associatePublicIpAddress(model.associatePublicIpAddress);
            iamInstanceProfileName(model.iamInstanceProfileName);
            configureScript(model.configureScript);
            configureScriptType(model.configureScriptType);
        }

        public final Server.Builder getServer() {
            return server != null ? server.toBuilder() : null;
        }

        public final void setServer(Server.BuilderImpl server) {
            this.server = server != null ? server.build() : null;
        }

        @Override
        public final Builder server(Server server) {
            this.server = server;
            return this;
        }

        public final String getLogicalId() {
            return logicalId;
        }

        public final void setLogicalId(String logicalId) {
            this.logicalId = logicalId;
        }

        @Override
        public final Builder logicalId(String logicalId) {
            this.logicalId = logicalId;
            return this;
        }

        public final String getVpc() {
            return vpc;
        }

        public final void setVpc(String vpc) {
            this.vpc = vpc;
        }

        @Override
        public final Builder vpc(String vpc) {
            this.vpc = vpc;
            return this;
        }

        public final String getSubnet() {
            return subnet;
        }

        public final void setSubnet(String subnet) {
            this.subnet = subnet;
        }

        @Override
        public final Builder subnet(String subnet) {
            this.subnet = subnet;
            return this;
        }

        public final String getSecurityGroup() {
            return securityGroup;
        }

        public final void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @Override
        public final Builder securityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public final String getEc2KeyName() {
            return ec2KeyName;
        }

        public final void setEc2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
        }

        @Override
        public final Builder ec2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
            return this;
        }

        public final UserData.Builder getUserData() {
            return userData != null ? userData.toBuilder() : null;
        }

        public final void setUserData(UserData.BuilderImpl userData) {
            this.userData = userData != null ? userData.build() : null;
        }

        @Override
        public final Builder userData(UserData userData) {
            this.userData = userData;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final String getIamInstanceProfileName() {
            return iamInstanceProfileName;
        }

        public final void setIamInstanceProfileName(String iamInstanceProfileName) {
            this.iamInstanceProfileName = iamInstanceProfileName;
        }

        @Override
        public final Builder iamInstanceProfileName(String iamInstanceProfileName) {
            this.iamInstanceProfileName = iamInstanceProfileName;
            return this;
        }

        public final S3Location.Builder getConfigureScript() {
            return configureScript != null ? configureScript.toBuilder() : null;
        }

        public final void setConfigureScript(S3Location.BuilderImpl configureScript) {
            this.configureScript = configureScript != null ? configureScript.build() : null;
        }

        @Override
        public final Builder configureScript(S3Location configureScript) {
            this.configureScript = configureScript;
            return this;
        }

        public final String getConfigureScriptType() {
            return configureScriptType;
        }

        public final void setConfigureScriptType(String configureScriptType) {
            this.configureScriptType = configureScriptType;
        }

        @Override
        public final Builder configureScriptType(String configureScriptType) {
            this.configureScriptType = configureScriptType;
            return this;
        }

        @Override
        public final Builder configureScriptType(ScriptType configureScriptType) {
            this.configureScriptType(configureScriptType == null ? null : configureScriptType.toString());
            return this;
        }

        @Override
        public ServerLaunchConfiguration build() {
            return new ServerLaunchConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
