/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse;

public class ListProvisioningArtifactsForServiceActionPublisher
implements SdkPublisher<ListProvisioningArtifactsForServiceActionResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListProvisioningArtifactsForServiceActionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProvisioningArtifactsForServiceActionPublisher(ServiceCatalogAsyncClient client, ListProvisioningArtifactsForServiceActionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProvisioningArtifactsForServiceActionPublisher(ServiceCatalogAsyncClient client, ListProvisioningArtifactsForServiceActionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProvisioningArtifactsForServiceActionResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProvisioningArtifactsForServiceActionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListProvisioningArtifactsForServiceActionResponseFetcher
    implements AsyncPageFetcher<ListProvisioningArtifactsForServiceActionResponse> {
        private ListProvisioningArtifactsForServiceActionResponseFetcher() {
        }

        public boolean hasNextPage(ListProvisioningArtifactsForServiceActionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListProvisioningArtifactsForServiceActionResponse> nextPage(ListProvisioningArtifactsForServiceActionResponse previousPage) {
            if (previousPage == null) {
                return ListProvisioningArtifactsForServiceActionPublisher.this.client.listProvisioningArtifactsForServiceAction(ListProvisioningArtifactsForServiceActionPublisher.this.firstRequest);
            }
            return ListProvisioningArtifactsForServiceActionPublisher.this.client.listProvisioningArtifactsForServiceAction((ListProvisioningArtifactsForServiceActionRequest)((Object)ListProvisioningArtifactsForServiceActionPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

