/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchProvisionedProductsRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<SearchProvisionedProductsRequest.Builder, SearchProvisionedProductsRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(SearchProvisionedProductsRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<AccessLevelFilter> ACCESS_LEVEL_FILTER_FIELD = SdkField
            .<AccessLevelFilter> builder(MarshallingType.SDK_POJO).memberName("AccessLevelFilter")
            .getter(getter(SearchProvisionedProductsRequest::accessLevelFilter)).setter(setter(Builder::accessLevelFilter))
            .constructor(AccessLevelFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLevelFilter").build()).build();

    private static final SdkField<Map<String, List<String>>> FILTERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Filters")
            .getter(getter(SearchProvisionedProductsRequest::filtersAsStrings))
            .setter(setter(Builder::filtersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(SearchProvisionedProductsRequest::sortBy)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(SearchProvisionedProductsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(SearchProvisionedProductsRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageToken").getter(getter(SearchProvisionedProductsRequest::pageToken))
            .setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            ACCESS_LEVEL_FILTER_FIELD, FILTERS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, PAGE_SIZE_FIELD, PAGE_TOKEN_FIELD));

    private final String acceptLanguage;

    private final AccessLevelFilter accessLevelFilter;

    private final Map<String, List<String>> filters;

    private final String sortBy;

    private final String sortOrder;

    private final Integer pageSize;

    private final String pageToken;

    private SearchProvisionedProductsRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.accessLevelFilter = builder.accessLevelFilter;
        this.filters = builder.filters;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The access level to use to obtain results. The default is <code>User</code>.
     * </p>
     * 
     * @return The access level to use to obtain results. The default is <code>User</code>.
     */
    public final AccessLevelFilter accessLevelFilter() {
        return accessLevelFilter;
    }

    /**
     * <p>
     * The search filters.
     * </p>
     * <p>
     * When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>, <code>createdTime</code>,
     * <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>, <code>name</code>,
     * <code>physicalId</code>, <code>productId</code>, <code>provisioningArtifactId</code>, <code>type</code>,
     * <code>status</code>, <code>tags</code>, <code>userArn</code>, <code>userArnSession</code>,
     * <code>lastProvisioningRecordId</code>, <code>lastSuccessfulProvisioningRecordId</code>, <code>productName</code>,
     * and <code>provisioningArtifactName</code>.
     * </p>
     * <p>
     * Example: <code>"SearchQuery":["status:AVAILABLE"]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The search filters.</p>
     *         <p>
     *         When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>,
     *         <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>,
     *         <code>name</code>, <code>physicalId</code>, <code>productId</code>, <code>provisioningArtifactId</code>,
     *         <code>type</code>, <code>status</code>, <code>tags</code>, <code>userArn</code>,
     *         <code>userArnSession</code>, <code>lastProvisioningRecordId</code>,
     *         <code>lastSuccessfulProvisioningRecordId</code>, <code>productName</code>, and
     *         <code>provisioningArtifactName</code>.
     *         </p>
     *         <p>
     *         Example: <code>"SearchQuery":["status:AVAILABLE"]</code>
     */
    public final Map<ProvisionedProductViewFilterBy, List<String>> filters() {
        return ProvisionedProductFiltersCopier.copyStringToEnum(filters);
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The search filters.
     * </p>
     * <p>
     * When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>, <code>createdTime</code>,
     * <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>, <code>name</code>,
     * <code>physicalId</code>, <code>productId</code>, <code>provisioningArtifactId</code>, <code>type</code>,
     * <code>status</code>, <code>tags</code>, <code>userArn</code>, <code>userArnSession</code>,
     * <code>lastProvisioningRecordId</code>, <code>lastSuccessfulProvisioningRecordId</code>, <code>productName</code>,
     * and <code>provisioningArtifactName</code>.
     * </p>
     * <p>
     * Example: <code>"SearchQuery":["status:AVAILABLE"]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The search filters.</p>
     *         <p>
     *         When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>,
     *         <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>,
     *         <code>name</code>, <code>physicalId</code>, <code>productId</code>, <code>provisioningArtifactId</code>,
     *         <code>type</code>, <code>status</code>, <code>tags</code>, <code>userArn</code>,
     *         <code>userArnSession</code>, <code>lastProvisioningRecordId</code>,
     *         <code>lastSuccessfulProvisioningRecordId</code>, <code>productName</code>, and
     *         <code>provisioningArtifactName</code>.
     *         </p>
     *         <p>
     *         Example: <code>"SearchQuery":["status:AVAILABLE"]</code>
     */
    public final Map<String, List<String>> filtersAsStrings() {
        return filters;
    }

    /**
     * <p>
     * The sort field. If no value is specified, the results are not sorted. The valid values are <code>arn</code>,
     * <code>id</code>, <code>name</code>, and <code>lastRecordId</code>.
     * </p>
     * 
     * @return The sort field. If no value is specified, the results are not sorted. The valid values are
     *         <code>arn</code>, <code>id</code>, <code>name</code>, and <code>lastRecordId</code>.
     */
    public final String sortBy() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order. If no value is specified, the results are not sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order. If no value is specified, the results are not sorted.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order. If no value is specified, the results are not sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order. If no value is specified, the results are not sorted.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The maximum number of items to return with this call.
     * </p>
     * 
     * @return The maximum number of items to return with this call.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The page token for the next set of results. To retrieve the first set of results, use null.
     * </p>
     * 
     * @return The page token for the next set of results. To retrieve the first set of results, use null.
     */
    public final String pageToken() {
        return pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(accessLevelFilter());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filtersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProvisionedProductsRequest)) {
            return false;
        }
        SearchProvisionedProductsRequest other = (SearchProvisionedProductsRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage())
                && Objects.equals(accessLevelFilter(), other.accessLevelFilter()) && hasFilters() == other.hasFilters()
                && Objects.equals(filtersAsStrings(), other.filtersAsStrings()) && Objects.equals(sortBy(), other.sortBy())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(pageToken(), other.pageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchProvisionedProductsRequest").add("AcceptLanguage", acceptLanguage())
                .add("AccessLevelFilter", accessLevelFilter()).add("Filters", hasFilters() ? filtersAsStrings() : null)
                .add("SortBy", sortBy()).add("SortOrder", sortOrderAsString()).add("PageSize", pageSize())
                .add("PageToken", pageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "AccessLevelFilter":
            return Optional.ofNullable(clazz.cast(accessLevelFilter()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filtersAsStrings()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "PageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchProvisionedProductsRequest, T> g) {
        return obj -> g.apply((SearchProvisionedProductsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchProvisionedProductsRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The access level to use to obtain results. The default is <code>User</code>.
         * </p>
         * 
         * @param accessLevelFilter
         *        The access level to use to obtain results. The default is <code>User</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLevelFilter(AccessLevelFilter accessLevelFilter);

        /**
         * <p>
         * The access level to use to obtain results. The default is <code>User</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessLevelFilter.Builder} avoiding the
         * need to create one manually via {@link AccessLevelFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessLevelFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #accessLevelFilter(AccessLevelFilter)}.
         * 
         * @param accessLevelFilter
         *        a consumer that will call methods on {@link AccessLevelFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLevelFilter(AccessLevelFilter)
         */
        default Builder accessLevelFilter(Consumer<AccessLevelFilter.Builder> accessLevelFilter) {
            return accessLevelFilter(AccessLevelFilter.builder().applyMutation(accessLevelFilter).build());
        }

        /**
         * <p>
         * The search filters.
         * </p>
         * <p>
         * When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>,
         * <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>,
         * <code>name</code>, <code>physicalId</code>, <code>productId</code>, <code>provisioningArtifactId</code>,
         * <code>type</code>, <code>status</code>, <code>tags</code>, <code>userArn</code>, <code>userArnSession</code>,
         * <code>lastProvisioningRecordId</code>, <code>lastSuccessfulProvisioningRecordId</code>,
         * <code>productName</code>, and <code>provisioningArtifactName</code>.
         * </p>
         * <p>
         * Example: <code>"SearchQuery":["status:AVAILABLE"]</code>
         * </p>
         * 
         * @param filters
         *        The search filters.</p>
         *        <p>
         *        When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>,
         *        <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>,
         *        <code>name</code>, <code>physicalId</code>, <code>productId</code>,
         *        <code>provisioningArtifactId</code>, <code>type</code>, <code>status</code>, <code>tags</code>,
         *        <code>userArn</code>, <code>userArnSession</code>, <code>lastProvisioningRecordId</code>,
         *        <code>lastSuccessfulProvisioningRecordId</code>, <code>productName</code>, and
         *        <code>provisioningArtifactName</code>.
         *        </p>
         *        <p>
         *        Example: <code>"SearchQuery":["status:AVAILABLE"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filtersWithStrings(Map<String, ? extends Collection<String>> filters);

        /**
         * <p>
         * The search filters.
         * </p>
         * <p>
         * When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>,
         * <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>,
         * <code>name</code>, <code>physicalId</code>, <code>productId</code>, <code>provisioningArtifactId</code>,
         * <code>type</code>, <code>status</code>, <code>tags</code>, <code>userArn</code>, <code>userArnSession</code>,
         * <code>lastProvisioningRecordId</code>, <code>lastSuccessfulProvisioningRecordId</code>,
         * <code>productName</code>, and <code>provisioningArtifactName</code>.
         * </p>
         * <p>
         * Example: <code>"SearchQuery":["status:AVAILABLE"]</code>
         * </p>
         * 
         * @param filters
         *        The search filters.</p>
         *        <p>
         *        When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>,
         *        <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>,
         *        <code>name</code>, <code>physicalId</code>, <code>productId</code>,
         *        <code>provisioningArtifactId</code>, <code>type</code>, <code>status</code>, <code>tags</code>,
         *        <code>userArn</code>, <code>userArnSession</code>, <code>lastProvisioningRecordId</code>,
         *        <code>lastSuccessfulProvisioningRecordId</code>, <code>productName</code>, and
         *        <code>provisioningArtifactName</code>.
         *        </p>
         *        <p>
         *        Example: <code>"SearchQuery":["status:AVAILABLE"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Map<ProvisionedProductViewFilterBy, ? extends Collection<String>> filters);

        /**
         * <p>
         * The sort field. If no value is specified, the results are not sorted. The valid values are <code>arn</code>,
         * <code>id</code>, <code>name</code>, and <code>lastRecordId</code>.
         * </p>
         * 
         * @param sortBy
         *        The sort field. If no value is specified, the results are not sorted. The valid values are
         *        <code>arn</code>, <code>id</code>, <code>name</code>, and <code>lastRecordId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The sort order. If no value is specified, the results are not sorted.
         * </p>
         * 
         * @param sortOrder
         *        The sort order. If no value is specified, the results are not sorted.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order. If no value is specified, the results are not sorted.
         * </p>
         * 
         * @param sortOrder
         *        The sort order. If no value is specified, the results are not sorted.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The maximum number of items to return with this call.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of items to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * The page token for the next set of results. To retrieve the first set of results, use null.
         * </p>
         * 
         * @param pageToken
         *        The page token for the next set of results. To retrieve the first set of results, use null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private AccessLevelFilter accessLevelFilter;

        private Map<String, List<String>> filters = DefaultSdkAutoConstructMap.getInstance();

        private String sortBy;

        private String sortOrder;

        private Integer pageSize;

        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProvisionedProductsRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            accessLevelFilter(model.accessLevelFilter);
            filtersWithStrings(model.filters);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            pageSize(model.pageSize);
            pageToken(model.pageToken);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final AccessLevelFilter.Builder getAccessLevelFilter() {
            return accessLevelFilter != null ? accessLevelFilter.toBuilder() : null;
        }

        public final void setAccessLevelFilter(AccessLevelFilter.BuilderImpl accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter != null ? accessLevelFilter.build() : null;
        }

        @Override
        public final Builder accessLevelFilter(AccessLevelFilter accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getFilters() {
            if (filters instanceof SdkAutoConstructMap) {
                return null;
            }
            return filters;
        }

        public final void setFilters(Map<String, ? extends Collection<String>> filters) {
            this.filters = ProvisionedProductFiltersCopier.copy(filters);
        }

        @Override
        public final Builder filtersWithStrings(Map<String, ? extends Collection<String>> filters) {
            this.filters = ProvisionedProductFiltersCopier.copy(filters);
            return this;
        }

        @Override
        public final Builder filters(Map<ProvisionedProductViewFilterBy, ? extends Collection<String>> filters) {
            this.filters = ProvisionedProductFiltersCopier.copyEnumToString(filters);
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getPageToken() {
            return pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchProvisionedProductsRequest build() {
            return new SearchProvisionedProductsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
