/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiscovererSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DiscovererSummary.Builder, DiscovererSummary> {
    private static final SdkField<String> DISCOVERER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscovererArn").getter(getter(DiscovererSummary::discovererArn)).setter(setter(Builder::discovererArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscovererArn").build()).build();

    private static final SdkField<String> DISCOVERER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscovererId").getter(getter(DiscovererSummary::discovererId)).setter(setter(Builder::discovererId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscovererId").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(DiscovererSummary::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DiscovererSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Boolean> CROSS_ACCOUNT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrossAccount").getter(getter(DiscovererSummary::crossAccount)).setter(setter(Builder::crossAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossAccount").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DiscovererSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERER_ARN_FIELD,
            DISCOVERER_ID_FIELD, SOURCE_ARN_FIELD, STATE_FIELD, CROSS_ACCOUNT_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String discovererArn;

    private final String discovererId;

    private final String sourceArn;

    private final String state;

    private final Boolean crossAccount;

    private final Map<String, String> tags;

    private DiscovererSummary(BuilderImpl builder) {
        this.discovererArn = builder.discovererArn;
        this.discovererId = builder.discovererId;
        this.sourceArn = builder.sourceArn;
        this.state = builder.state;
        this.crossAccount = builder.crossAccount;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the discoverer.
     * </p>
     * 
     * @return The ARN of the discoverer.
     */
    public final String discovererArn() {
        return discovererArn;
    }

    /**
     * <p>
     * The ID of the discoverer.
     * </p>
     * 
     * @return The ID of the discoverer.
     */
    public final String discovererId() {
        return discovererId;
    }

    /**
     * <p>
     * The ARN of the event bus.
     * </p>
     * 
     * @return The ARN of the event bus.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The state of the discoverer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DiscovererState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the discoverer.
     * @see DiscovererState
     */
    public final DiscovererState state() {
        return DiscovererState.fromValue(state);
    }

    /**
     * <p>
     * The state of the discoverer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DiscovererState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the discoverer.
     * @see DiscovererState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The Status if the discoverer will discover schemas from events sent from another account.
     * </p>
     * 
     * @return The Status if the discoverer will discover schemas from events sent from another account.
     */
    public final Boolean crossAccount() {
        return crossAccount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags associated with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags associated with the resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(discovererArn());
        hashCode = 31 * hashCode + Objects.hashCode(discovererId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(crossAccount());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscovererSummary)) {
            return false;
        }
        DiscovererSummary other = (DiscovererSummary) obj;
        return Objects.equals(discovererArn(), other.discovererArn()) && Objects.equals(discovererId(), other.discovererId())
                && Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(crossAccount(), other.crossAccount()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiscovererSummary").add("DiscovererArn", discovererArn()).add("DiscovererId", discovererId())
                .add("SourceArn", sourceArn()).add("State", stateAsString()).add("CrossAccount", crossAccount())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DiscovererArn":
            return Optional.ofNullable(clazz.cast(discovererArn()));
        case "DiscovererId":
            return Optional.ofNullable(clazz.cast(discovererId()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CrossAccount":
            return Optional.ofNullable(clazz.cast(crossAccount()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscovererSummary, T> g) {
        return obj -> g.apply((DiscovererSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DiscovererSummary> {
        /**
         * <p>
         * The ARN of the discoverer.
         * </p>
         * 
         * @param discovererArn
         *        The ARN of the discoverer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discovererArn(String discovererArn);

        /**
         * <p>
         * The ID of the discoverer.
         * </p>
         * 
         * @param discovererId
         *        The ID of the discoverer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discovererId(String discovererId);

        /**
         * <p>
         * The ARN of the event bus.
         * </p>
         * 
         * @param sourceArn
         *        The ARN of the event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The state of the discoverer.
         * </p>
         * 
         * @param state
         *        The state of the discoverer.
         * @see DiscovererState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscovererState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the discoverer.
         * </p>
         * 
         * @param state
         *        The state of the discoverer.
         * @see DiscovererState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscovererState
         */
        Builder state(DiscovererState state);

        /**
         * <p>
         * The Status if the discoverer will discover schemas from events sent from another account.
         * </p>
         * 
         * @param crossAccount
         *        The Status if the discoverer will discover schemas from events sent from another account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccount(Boolean crossAccount);

        /**
         * <p>
         * Tags associated with the resource.
         * </p>
         * 
         * @param tags
         *        Tags associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String discovererArn;

        private String discovererId;

        private String sourceArn;

        private String state;

        private Boolean crossAccount;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DiscovererSummary model) {
            discovererArn(model.discovererArn);
            discovererId(model.discovererId);
            sourceArn(model.sourceArn);
            state(model.state);
            crossAccount(model.crossAccount);
            tags(model.tags);
        }

        public final String getDiscovererArn() {
            return discovererArn;
        }

        public final void setDiscovererArn(String discovererArn) {
            this.discovererArn = discovererArn;
        }

        @Override
        public final Builder discovererArn(String discovererArn) {
            this.discovererArn = discovererArn;
            return this;
        }

        public final String getDiscovererId() {
            return discovererId;
        }

        public final void setDiscovererId(String discovererId) {
            this.discovererId = discovererId;
        }

        @Override
        public final Builder discovererId(String discovererId) {
            this.discovererId = discovererId;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DiscovererState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Boolean getCrossAccount() {
            return crossAccount;
        }

        public final void setCrossAccount(Boolean crossAccount) {
            this.crossAccount = crossAccount;
        }

        @Override
        public final Builder crossAccount(Boolean crossAccount) {
            this.crossAccount = crossAccount;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public DiscovererSummary build() {
            return new DiscovererSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
