/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of settings that apply to spaces created in the domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultSpaceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultSpaceSettings.Builder, DefaultSpaceSettings> {
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRole").getter(getter(DefaultSpaceSettings::executionRole))
            .setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(DefaultSpaceSettings::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<JupyterServerAppSettings> JUPYTER_SERVER_APP_SETTINGS_FIELD = SdkField
            .<JupyterServerAppSettings> builder(MarshallingType.SDK_POJO).memberName("JupyterServerAppSettings")
            .getter(getter(DefaultSpaceSettings::jupyterServerAppSettings)).setter(setter(Builder::jupyterServerAppSettings))
            .constructor(JupyterServerAppSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterServerAppSettings").build())
            .build();

    private static final SdkField<KernelGatewayAppSettings> KERNEL_GATEWAY_APP_SETTINGS_FIELD = SdkField
            .<KernelGatewayAppSettings> builder(MarshallingType.SDK_POJO).memberName("KernelGatewayAppSettings")
            .getter(getter(DefaultSpaceSettings::kernelGatewayAppSettings)).setter(setter(Builder::kernelGatewayAppSettings))
            .constructor(KernelGatewayAppSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelGatewayAppSettings").build())
            .build();

    private static final SdkField<JupyterLabAppSettings> JUPYTER_LAB_APP_SETTINGS_FIELD = SdkField
            .<JupyterLabAppSettings> builder(MarshallingType.SDK_POJO).memberName("JupyterLabAppSettings")
            .getter(getter(DefaultSpaceSettings::jupyterLabAppSettings)).setter(setter(Builder::jupyterLabAppSettings))
            .constructor(JupyterLabAppSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterLabAppSettings").build())
            .build();

    private static final SdkField<DefaultSpaceStorageSettings> SPACE_STORAGE_SETTINGS_FIELD = SdkField
            .<DefaultSpaceStorageSettings> builder(MarshallingType.SDK_POJO).memberName("SpaceStorageSettings")
            .getter(getter(DefaultSpaceSettings::spaceStorageSettings)).setter(setter(Builder::spaceStorageSettings))
            .constructor(DefaultSpaceStorageSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceStorageSettings").build())
            .build();

    private static final SdkField<CustomPosixUserConfig> CUSTOM_POSIX_USER_CONFIG_FIELD = SdkField
            .<CustomPosixUserConfig> builder(MarshallingType.SDK_POJO).memberName("CustomPosixUserConfig")
            .getter(getter(DefaultSpaceSettings::customPosixUserConfig)).setter(setter(Builder::customPosixUserConfig))
            .constructor(CustomPosixUserConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPosixUserConfig").build())
            .build();

    private static final SdkField<List<CustomFileSystemConfig>> CUSTOM_FILE_SYSTEM_CONFIGS_FIELD = SdkField
            .<List<CustomFileSystemConfig>> builder(MarshallingType.LIST)
            .memberName("CustomFileSystemConfigs")
            .getter(getter(DefaultSpaceSettings::customFileSystemConfigs))
            .setter(setter(Builder::customFileSystemConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomFileSystemConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomFileSystemConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomFileSystemConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_FIELD,
            SECURITY_GROUPS_FIELD, JUPYTER_SERVER_APP_SETTINGS_FIELD, KERNEL_GATEWAY_APP_SETTINGS_FIELD,
            JUPYTER_LAB_APP_SETTINGS_FIELD, SPACE_STORAGE_SETTINGS_FIELD, CUSTOM_POSIX_USER_CONFIG_FIELD,
            CUSTOM_FILE_SYSTEM_CONFIGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String executionRole;

    private final List<String> securityGroups;

    private final JupyterServerAppSettings jupyterServerAppSettings;

    private final KernelGatewayAppSettings kernelGatewayAppSettings;

    private final JupyterLabAppSettings jupyterLabAppSettings;

    private final DefaultSpaceStorageSettings spaceStorageSettings;

    private final CustomPosixUserConfig customPosixUserConfig;

    private final List<CustomFileSystemConfig> customFileSystemConfigs;

    private DefaultSpaceSettings(BuilderImpl builder) {
        this.executionRole = builder.executionRole;
        this.securityGroups = builder.securityGroups;
        this.jupyterServerAppSettings = builder.jupyterServerAppSettings;
        this.kernelGatewayAppSettings = builder.kernelGatewayAppSettings;
        this.jupyterLabAppSettings = builder.jupyterLabAppSettings;
        this.spaceStorageSettings = builder.spaceStorageSettings;
        this.customPosixUserConfig = builder.customPosixUserConfig;
        this.customFileSystemConfigs = builder.customFileSystemConfigs;
    }

    /**
     * <p>
     * The ARN of the execution role for the space.
     * </p>
     * 
     * @return The ARN of the execution role for the space.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security group IDs for the Amazon VPC that the space uses for communication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The security group IDs for the Amazon VPC that the space uses for communication.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * Returns the value of the JupyterServerAppSettings property for this object.
     * 
     * @return The value of the JupyterServerAppSettings property for this object.
     */
    public final JupyterServerAppSettings jupyterServerAppSettings() {
        return jupyterServerAppSettings;
    }

    /**
     * Returns the value of the KernelGatewayAppSettings property for this object.
     * 
     * @return The value of the KernelGatewayAppSettings property for this object.
     */
    public final KernelGatewayAppSettings kernelGatewayAppSettings() {
        return kernelGatewayAppSettings;
    }

    /**
     * Returns the value of the JupyterLabAppSettings property for this object.
     * 
     * @return The value of the JupyterLabAppSettings property for this object.
     */
    public final JupyterLabAppSettings jupyterLabAppSettings() {
        return jupyterLabAppSettings;
    }

    /**
     * Returns the value of the SpaceStorageSettings property for this object.
     * 
     * @return The value of the SpaceStorageSettings property for this object.
     */
    public final DefaultSpaceStorageSettings spaceStorageSettings() {
        return spaceStorageSettings;
    }

    /**
     * Returns the value of the CustomPosixUserConfig property for this object.
     * 
     * @return The value of the CustomPosixUserConfig property for this object.
     */
    public final CustomPosixUserConfig customPosixUserConfig() {
        return customPosixUserConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomFileSystemConfigs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomFileSystemConfigs() {
        return customFileSystemConfigs != null && !(customFileSystemConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The settings for assigning a custom file system to a domain. Permitted users can access this file system in
     * Amazon SageMaker Studio.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomFileSystemConfigs} method.
     * </p>
     * 
     * @return The settings for assigning a custom file system to a domain. Permitted users can access this file system
     *         in Amazon SageMaker Studio.
     */
    public final List<CustomFileSystemConfig> customFileSystemConfigs() {
        return customFileSystemConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jupyterServerAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(kernelGatewayAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(jupyterLabAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(spaceStorageSettings());
        hashCode = 31 * hashCode + Objects.hashCode(customPosixUserConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomFileSystemConfigs() ? customFileSystemConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultSpaceSettings)) {
            return false;
        }
        DefaultSpaceSettings other = (DefaultSpaceSettings) obj;
        return Objects.equals(executionRole(), other.executionRole()) && hasSecurityGroups() == other.hasSecurityGroups()
                && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(jupyterServerAppSettings(), other.jupyterServerAppSettings())
                && Objects.equals(kernelGatewayAppSettings(), other.kernelGatewayAppSettings())
                && Objects.equals(jupyterLabAppSettings(), other.jupyterLabAppSettings())
                && Objects.equals(spaceStorageSettings(), other.spaceStorageSettings())
                && Objects.equals(customPosixUserConfig(), other.customPosixUserConfig())
                && hasCustomFileSystemConfigs() == other.hasCustomFileSystemConfigs()
                && Objects.equals(customFileSystemConfigs(), other.customFileSystemConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultSpaceSettings").add("ExecutionRole", executionRole())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null)
                .add("JupyterServerAppSettings", jupyterServerAppSettings())
                .add("KernelGatewayAppSettings", kernelGatewayAppSettings())
                .add("JupyterLabAppSettings", jupyterLabAppSettings()).add("SpaceStorageSettings", spaceStorageSettings())
                .add("CustomPosixUserConfig", customPosixUserConfig())
                .add("CustomFileSystemConfigs", hasCustomFileSystemConfigs() ? customFileSystemConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "JupyterServerAppSettings":
            return Optional.ofNullable(clazz.cast(jupyterServerAppSettings()));
        case "KernelGatewayAppSettings":
            return Optional.ofNullable(clazz.cast(kernelGatewayAppSettings()));
        case "JupyterLabAppSettings":
            return Optional.ofNullable(clazz.cast(jupyterLabAppSettings()));
        case "SpaceStorageSettings":
            return Optional.ofNullable(clazz.cast(spaceStorageSettings()));
        case "CustomPosixUserConfig":
            return Optional.ofNullable(clazz.cast(customPosixUserConfig()));
        case "CustomFileSystemConfigs":
            return Optional.ofNullable(clazz.cast(customFileSystemConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultSpaceSettings, T> g) {
        return obj -> g.apply((DefaultSpaceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultSpaceSettings> {
        /**
         * <p>
         * The ARN of the execution role for the space.
         * </p>
         * 
         * @param executionRole
         *        The ARN of the execution role for the space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The security group IDs for the Amazon VPC that the space uses for communication.
         * </p>
         * 
         * @param securityGroups
         *        The security group IDs for the Amazon VPC that the space uses for communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The security group IDs for the Amazon VPC that the space uses for communication.
         * </p>
         * 
         * @param securityGroups
         *        The security group IDs for the Amazon VPC that the space uses for communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * Sets the value of the JupyterServerAppSettings property for this object.
         *
         * @param jupyterServerAppSettings
         *        The new value for the JupyterServerAppSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings);

        /**
         * Sets the value of the JupyterServerAppSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link JupyterServerAppSettings.Builder}
         * avoiding the need to create one manually via {@link JupyterServerAppSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JupyterServerAppSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #jupyterServerAppSettings(JupyterServerAppSettings)}.
         * 
         * @param jupyterServerAppSettings
         *        a consumer that will call methods on {@link JupyterServerAppSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jupyterServerAppSettings(JupyterServerAppSettings)
         */
        default Builder jupyterServerAppSettings(Consumer<JupyterServerAppSettings.Builder> jupyterServerAppSettings) {
            return jupyterServerAppSettings(JupyterServerAppSettings.builder().applyMutation(jupyterServerAppSettings).build());
        }

        /**
         * Sets the value of the KernelGatewayAppSettings property for this object.
         *
         * @param kernelGatewayAppSettings
         *        The new value for the KernelGatewayAppSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings);

        /**
         * Sets the value of the KernelGatewayAppSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link KernelGatewayAppSettings.Builder}
         * avoiding the need to create one manually via {@link KernelGatewayAppSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KernelGatewayAppSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #kernelGatewayAppSettings(KernelGatewayAppSettings)}.
         * 
         * @param kernelGatewayAppSettings
         *        a consumer that will call methods on {@link KernelGatewayAppSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kernelGatewayAppSettings(KernelGatewayAppSettings)
         */
        default Builder kernelGatewayAppSettings(Consumer<KernelGatewayAppSettings.Builder> kernelGatewayAppSettings) {
            return kernelGatewayAppSettings(KernelGatewayAppSettings.builder().applyMutation(kernelGatewayAppSettings).build());
        }

        /**
         * Sets the value of the JupyterLabAppSettings property for this object.
         *
         * @param jupyterLabAppSettings
         *        The new value for the JupyterLabAppSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jupyterLabAppSettings(JupyterLabAppSettings jupyterLabAppSettings);

        /**
         * Sets the value of the JupyterLabAppSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link JupyterLabAppSettings.Builder} avoiding
         * the need to create one manually via {@link JupyterLabAppSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JupyterLabAppSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #jupyterLabAppSettings(JupyterLabAppSettings)}.
         * 
         * @param jupyterLabAppSettings
         *        a consumer that will call methods on {@link JupyterLabAppSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jupyterLabAppSettings(JupyterLabAppSettings)
         */
        default Builder jupyterLabAppSettings(Consumer<JupyterLabAppSettings.Builder> jupyterLabAppSettings) {
            return jupyterLabAppSettings(JupyterLabAppSettings.builder().applyMutation(jupyterLabAppSettings).build());
        }

        /**
         * Sets the value of the SpaceStorageSettings property for this object.
         *
         * @param spaceStorageSettings
         *        The new value for the SpaceStorageSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceStorageSettings(DefaultSpaceStorageSettings spaceStorageSettings);

        /**
         * Sets the value of the SpaceStorageSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DefaultSpaceStorageSettings.Builder}
         * avoiding the need to create one manually via {@link DefaultSpaceStorageSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultSpaceStorageSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #spaceStorageSettings(DefaultSpaceStorageSettings)}.
         * 
         * @param spaceStorageSettings
         *        a consumer that will call methods on {@link DefaultSpaceStorageSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spaceStorageSettings(DefaultSpaceStorageSettings)
         */
        default Builder spaceStorageSettings(Consumer<DefaultSpaceStorageSettings.Builder> spaceStorageSettings) {
            return spaceStorageSettings(DefaultSpaceStorageSettings.builder().applyMutation(spaceStorageSettings).build());
        }

        /**
         * Sets the value of the CustomPosixUserConfig property for this object.
         *
         * @param customPosixUserConfig
         *        The new value for the CustomPosixUserConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPosixUserConfig(CustomPosixUserConfig customPosixUserConfig);

        /**
         * Sets the value of the CustomPosixUserConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CustomPosixUserConfig.Builder} avoiding
         * the need to create one manually via {@link CustomPosixUserConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomPosixUserConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #customPosixUserConfig(CustomPosixUserConfig)}.
         * 
         * @param customPosixUserConfig
         *        a consumer that will call methods on {@link CustomPosixUserConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customPosixUserConfig(CustomPosixUserConfig)
         */
        default Builder customPosixUserConfig(Consumer<CustomPosixUserConfig.Builder> customPosixUserConfig) {
            return customPosixUserConfig(CustomPosixUserConfig.builder().applyMutation(customPosixUserConfig).build());
        }

        /**
         * <p>
         * The settings for assigning a custom file system to a domain. Permitted users can access this file system in
         * Amazon SageMaker Studio.
         * </p>
         * 
         * @param customFileSystemConfigs
         *        The settings for assigning a custom file system to a domain. Permitted users can access this file
         *        system in Amazon SageMaker Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customFileSystemConfigs(Collection<CustomFileSystemConfig> customFileSystemConfigs);

        /**
         * <p>
         * The settings for assigning a custom file system to a domain. Permitted users can access this file system in
         * Amazon SageMaker Studio.
         * </p>
         * 
         * @param customFileSystemConfigs
         *        The settings for assigning a custom file system to a domain. Permitted users can access this file
         *        system in Amazon SageMaker Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customFileSystemConfigs(CustomFileSystemConfig... customFileSystemConfigs);

        /**
         * <p>
         * The settings for assigning a custom file system to a domain. Permitted users can access this file system in
         * Amazon SageMaker Studio.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.CustomFileSystemConfig.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.CustomFileSystemConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.CustomFileSystemConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #customFileSystemConfigs(List<CustomFileSystemConfig>)}.
         * 
         * @param customFileSystemConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.CustomFileSystemConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customFileSystemConfigs(java.util.Collection<CustomFileSystemConfig>)
         */
        Builder customFileSystemConfigs(Consumer<CustomFileSystemConfig.Builder>... customFileSystemConfigs);
    }

    static final class BuilderImpl implements Builder {
        private String executionRole;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private JupyterServerAppSettings jupyterServerAppSettings;

        private KernelGatewayAppSettings kernelGatewayAppSettings;

        private JupyterLabAppSettings jupyterLabAppSettings;

        private DefaultSpaceStorageSettings spaceStorageSettings;

        private CustomPosixUserConfig customPosixUserConfig;

        private List<CustomFileSystemConfig> customFileSystemConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultSpaceSettings model) {
            executionRole(model.executionRole);
            securityGroups(model.securityGroups);
            jupyterServerAppSettings(model.jupyterServerAppSettings);
            kernelGatewayAppSettings(model.kernelGatewayAppSettings);
            jupyterLabAppSettings(model.jupyterLabAppSettings);
            spaceStorageSettings(model.spaceStorageSettings);
            customPosixUserConfig(model.customPosixUserConfig);
            customFileSystemConfigs(model.customFileSystemConfigs);
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final JupyterServerAppSettings.Builder getJupyterServerAppSettings() {
            return jupyterServerAppSettings != null ? jupyterServerAppSettings.toBuilder() : null;
        }

        public final void setJupyterServerAppSettings(JupyterServerAppSettings.BuilderImpl jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings != null ? jupyterServerAppSettings.build() : null;
        }

        @Override
        public final Builder jupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings;
            return this;
        }

        public final KernelGatewayAppSettings.Builder getKernelGatewayAppSettings() {
            return kernelGatewayAppSettings != null ? kernelGatewayAppSettings.toBuilder() : null;
        }

        public final void setKernelGatewayAppSettings(KernelGatewayAppSettings.BuilderImpl kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings != null ? kernelGatewayAppSettings.build() : null;
        }

        @Override
        public final Builder kernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings;
            return this;
        }

        public final JupyterLabAppSettings.Builder getJupyterLabAppSettings() {
            return jupyterLabAppSettings != null ? jupyterLabAppSettings.toBuilder() : null;
        }

        public final void setJupyterLabAppSettings(JupyterLabAppSettings.BuilderImpl jupyterLabAppSettings) {
            this.jupyterLabAppSettings = jupyterLabAppSettings != null ? jupyterLabAppSettings.build() : null;
        }

        @Override
        public final Builder jupyterLabAppSettings(JupyterLabAppSettings jupyterLabAppSettings) {
            this.jupyterLabAppSettings = jupyterLabAppSettings;
            return this;
        }

        public final DefaultSpaceStorageSettings.Builder getSpaceStorageSettings() {
            return spaceStorageSettings != null ? spaceStorageSettings.toBuilder() : null;
        }

        public final void setSpaceStorageSettings(DefaultSpaceStorageSettings.BuilderImpl spaceStorageSettings) {
            this.spaceStorageSettings = spaceStorageSettings != null ? spaceStorageSettings.build() : null;
        }

        @Override
        public final Builder spaceStorageSettings(DefaultSpaceStorageSettings spaceStorageSettings) {
            this.spaceStorageSettings = spaceStorageSettings;
            return this;
        }

        public final CustomPosixUserConfig.Builder getCustomPosixUserConfig() {
            return customPosixUserConfig != null ? customPosixUserConfig.toBuilder() : null;
        }

        public final void setCustomPosixUserConfig(CustomPosixUserConfig.BuilderImpl customPosixUserConfig) {
            this.customPosixUserConfig = customPosixUserConfig != null ? customPosixUserConfig.build() : null;
        }

        @Override
        public final Builder customPosixUserConfig(CustomPosixUserConfig customPosixUserConfig) {
            this.customPosixUserConfig = customPosixUserConfig;
            return this;
        }

        public final List<CustomFileSystemConfig.Builder> getCustomFileSystemConfigs() {
            List<CustomFileSystemConfig.Builder> result = CustomFileSystemConfigsCopier
                    .copyToBuilder(this.customFileSystemConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomFileSystemConfigs(Collection<CustomFileSystemConfig.BuilderImpl> customFileSystemConfigs) {
            this.customFileSystemConfigs = CustomFileSystemConfigsCopier.copyFromBuilder(customFileSystemConfigs);
        }

        @Override
        public final Builder customFileSystemConfigs(Collection<CustomFileSystemConfig> customFileSystemConfigs) {
            this.customFileSystemConfigs = CustomFileSystemConfigsCopier.copy(customFileSystemConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFileSystemConfigs(CustomFileSystemConfig... customFileSystemConfigs) {
            customFileSystemConfigs(Arrays.asList(customFileSystemConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFileSystemConfigs(Consumer<CustomFileSystemConfig.Builder>... customFileSystemConfigs) {
            customFileSystemConfigs(Stream.of(customFileSystemConfigs)
                    .map(c -> CustomFileSystemConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DefaultSpaceSettings build() {
            return new DefaultSpaceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
