/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.endpoints.authscheme;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;

@SdkProtectedApi
public final class S3ExpressEndpointAuthScheme
implements EndpointAuthScheme {
    private final String signingRegion;
    private final String signingName;
    private final Boolean disableDoubleEncoding;

    private S3ExpressEndpointAuthScheme(Builder b) {
        this.signingRegion = b.signingRegion;
        this.signingName = b.signingName;
        this.disableDoubleEncoding = b.disableDoubleEncoding;
    }

    public String name() {
        return "sigv4-s3express";
    }

    public String schemeId() {
        return "aws.auth#sigv4-s3express";
    }

    public String signingRegion() {
        return this.signingRegion;
    }

    public String signingName() {
        return this.signingName;
    }

    public boolean disableDoubleEncoding() {
        return this.disableDoubleEncoding == null ? false : this.disableDoubleEncoding;
    }

    public boolean isDisableDoubleEncodingSet() {
        return this.disableDoubleEncoding != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ExpressEndpointAuthScheme that = (S3ExpressEndpointAuthScheme)o;
        if (!Objects.equals(this.disableDoubleEncoding, that.disableDoubleEncoding)) {
            return false;
        }
        if (this.signingRegion != null ? !this.signingRegion.equals(that.signingRegion) : that.signingRegion != null) {
            return false;
        }
        return this.signingName != null ? this.signingName.equals(that.signingName) : that.signingName == null;
    }

    public int hashCode() {
        int result = this.signingRegion != null ? this.signingRegion.hashCode() : 0;
        result = 31 * result + (this.signingName != null ? this.signingName.hashCode() : 0);
        result = 31 * result + (this.disableDoubleEncoding != false ? 1 : 0);
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String signingRegion;
        private String signingName;
        private Boolean disableDoubleEncoding;

        public Builder signingRegion(String signingRegion) {
            this.signingRegion = signingRegion;
            return this;
        }

        public Builder signingName(String signingName) {
            this.signingName = signingName;
            return this;
        }

        public Builder disableDoubleEncoding(Boolean disableDoubleEncoding) {
            this.disableDoubleEncoding = disableDoubleEncoding;
            return this;
        }

        public S3ExpressEndpointAuthScheme build() {
            return new S3ExpressEndpointAuthScheme(this);
        }
    }
}

