/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Reserved-node status details, such as the source reserved-node identifier, the target reserved-node identifier, the
 * node type, the node count, and other details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedNodeExchangeStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedNodeExchangeStatus.Builder, ReservedNodeExchangeStatus> {
    private static final SdkField<String> RESERVED_NODE_EXCHANGE_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedNodeExchangeRequestId")
            .getter(getter(ReservedNodeExchangeStatus::reservedNodeExchangeRequestId))
            .setter(setter(Builder::reservedNodeExchangeRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeExchangeRequestId")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ReservedNodeExchangeStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> REQUEST_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RequestTime").getter(getter(ReservedNodeExchangeStatus::requestTime))
            .setter(setter(Builder::requestTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTime").build()).build();

    private static final SdkField<String> SOURCE_RESERVED_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceReservedNodeId").getter(getter(ReservedNodeExchangeStatus::sourceReservedNodeId))
            .setter(setter(Builder::sourceReservedNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceReservedNodeId").build())
            .build();

    private static final SdkField<String> SOURCE_RESERVED_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceReservedNodeType").getter(getter(ReservedNodeExchangeStatus::sourceReservedNodeType))
            .setter(setter(Builder::sourceReservedNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceReservedNodeType").build())
            .build();

    private static final SdkField<Integer> SOURCE_RESERVED_NODE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SourceReservedNodeCount").getter(getter(ReservedNodeExchangeStatus::sourceReservedNodeCount))
            .setter(setter(Builder::sourceReservedNodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceReservedNodeCount").build())
            .build();

    private static final SdkField<String> TARGET_RESERVED_NODE_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetReservedNodeOfferingId")
            .getter(getter(ReservedNodeExchangeStatus::targetReservedNodeOfferingId))
            .setter(setter(Builder::targetReservedNodeOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeOfferingId")
                    .build()).build();

    private static final SdkField<String> TARGET_RESERVED_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetReservedNodeType").getter(getter(ReservedNodeExchangeStatus::targetReservedNodeType))
            .setter(setter(Builder::targetReservedNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeType").build())
            .build();

    private static final SdkField<Integer> TARGET_RESERVED_NODE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetReservedNodeCount").getter(getter(ReservedNodeExchangeStatus::targetReservedNodeCount))
            .setter(setter(Builder::targetReservedNodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_NODE_EXCHANGE_REQUEST_ID_FIELD, STATUS_FIELD, REQUEST_TIME_FIELD, SOURCE_RESERVED_NODE_ID_FIELD,
            SOURCE_RESERVED_NODE_TYPE_FIELD, SOURCE_RESERVED_NODE_COUNT_FIELD, TARGET_RESERVED_NODE_OFFERING_ID_FIELD,
            TARGET_RESERVED_NODE_TYPE_FIELD, TARGET_RESERVED_NODE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reservedNodeExchangeRequestId;

    private final String status;

    private final Instant requestTime;

    private final String sourceReservedNodeId;

    private final String sourceReservedNodeType;

    private final Integer sourceReservedNodeCount;

    private final String targetReservedNodeOfferingId;

    private final String targetReservedNodeType;

    private final Integer targetReservedNodeCount;

    private ReservedNodeExchangeStatus(BuilderImpl builder) {
        this.reservedNodeExchangeRequestId = builder.reservedNodeExchangeRequestId;
        this.status = builder.status;
        this.requestTime = builder.requestTime;
        this.sourceReservedNodeId = builder.sourceReservedNodeId;
        this.sourceReservedNodeType = builder.sourceReservedNodeType;
        this.sourceReservedNodeCount = builder.sourceReservedNodeCount;
        this.targetReservedNodeOfferingId = builder.targetReservedNodeOfferingId;
        this.targetReservedNodeType = builder.targetReservedNodeType;
        this.targetReservedNodeCount = builder.targetReservedNodeCount;
    }

    /**
     * <p>
     * The identifier of the reserved-node exchange request.
     * </p>
     * 
     * @return The identifier of the reserved-node exchange request.
     */
    public final String reservedNodeExchangeRequestId() {
        return reservedNodeExchangeRequestId;
    }

    /**
     * <p>
     * The status of the reserved-node exchange request. Statuses include in-progress and requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReservedNodeExchangeStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the reserved-node exchange request. Statuses include in-progress and requested.
     * @see ReservedNodeExchangeStatusType
     */
    public final ReservedNodeExchangeStatusType status() {
        return ReservedNodeExchangeStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of the reserved-node exchange request. Statuses include in-progress and requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReservedNodeExchangeStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the reserved-node exchange request. Statuses include in-progress and requested.
     * @see ReservedNodeExchangeStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A date and time that indicate when the reserved-node exchange was requested.
     * </p>
     * 
     * @return A date and time that indicate when the reserved-node exchange was requested.
     */
    public final Instant requestTime() {
        return requestTime;
    }

    /**
     * <p>
     * The identifier of the source reserved node.
     * </p>
     * 
     * @return The identifier of the source reserved node.
     */
    public final String sourceReservedNodeId() {
        return sourceReservedNodeId;
    }

    /**
     * <p>
     * The source reserved-node type, for example ra3.4xlarge.
     * </p>
     * 
     * @return The source reserved-node type, for example ra3.4xlarge.
     */
    public final String sourceReservedNodeType() {
        return sourceReservedNodeType;
    }

    /**
     * <p>
     * The source reserved-node count in the cluster.
     * </p>
     * 
     * @return The source reserved-node count in the cluster.
     */
    public final Integer sourceReservedNodeCount() {
        return sourceReservedNodeCount;
    }

    /**
     * <p>
     * The identifier of the target reserved node offering.
     * </p>
     * 
     * @return The identifier of the target reserved node offering.
     */
    public final String targetReservedNodeOfferingId() {
        return targetReservedNodeOfferingId;
    }

    /**
     * <p>
     * The node type of the target reserved node, for example ra3.4xlarge.
     * </p>
     * 
     * @return The node type of the target reserved node, for example ra3.4xlarge.
     */
    public final String targetReservedNodeType() {
        return targetReservedNodeType;
    }

    /**
     * <p>
     * The count of target reserved nodes in the cluster.
     * </p>
     * 
     * @return The count of target reserved nodes in the cluster.
     */
    public final Integer targetReservedNodeCount() {
        return targetReservedNodeCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedNodeExchangeRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(sourceReservedNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceReservedNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(sourceReservedNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(targetReservedNodeOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(targetReservedNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(targetReservedNodeCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedNodeExchangeStatus)) {
            return false;
        }
        ReservedNodeExchangeStatus other = (ReservedNodeExchangeStatus) obj;
        return Objects.equals(reservedNodeExchangeRequestId(), other.reservedNodeExchangeRequestId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(requestTime(), other.requestTime())
                && Objects.equals(sourceReservedNodeId(), other.sourceReservedNodeId())
                && Objects.equals(sourceReservedNodeType(), other.sourceReservedNodeType())
                && Objects.equals(sourceReservedNodeCount(), other.sourceReservedNodeCount())
                && Objects.equals(targetReservedNodeOfferingId(), other.targetReservedNodeOfferingId())
                && Objects.equals(targetReservedNodeType(), other.targetReservedNodeType())
                && Objects.equals(targetReservedNodeCount(), other.targetReservedNodeCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedNodeExchangeStatus")
                .add("ReservedNodeExchangeRequestId", reservedNodeExchangeRequestId()).add("Status", statusAsString())
                .add("RequestTime", requestTime()).add("SourceReservedNodeId", sourceReservedNodeId())
                .add("SourceReservedNodeType", sourceReservedNodeType())
                .add("SourceReservedNodeCount", sourceReservedNodeCount())
                .add("TargetReservedNodeOfferingId", targetReservedNodeOfferingId())
                .add("TargetReservedNodeType", targetReservedNodeType())
                .add("TargetReservedNodeCount", targetReservedNodeCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedNodeExchangeRequestId":
            return Optional.ofNullable(clazz.cast(reservedNodeExchangeRequestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "RequestTime":
            return Optional.ofNullable(clazz.cast(requestTime()));
        case "SourceReservedNodeId":
            return Optional.ofNullable(clazz.cast(sourceReservedNodeId()));
        case "SourceReservedNodeType":
            return Optional.ofNullable(clazz.cast(sourceReservedNodeType()));
        case "SourceReservedNodeCount":
            return Optional.ofNullable(clazz.cast(sourceReservedNodeCount()));
        case "TargetReservedNodeOfferingId":
            return Optional.ofNullable(clazz.cast(targetReservedNodeOfferingId()));
        case "TargetReservedNodeType":
            return Optional.ofNullable(clazz.cast(targetReservedNodeType()));
        case "TargetReservedNodeCount":
            return Optional.ofNullable(clazz.cast(targetReservedNodeCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedNodeExchangeStatus, T> g) {
        return obj -> g.apply((ReservedNodeExchangeStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedNodeExchangeStatus> {
        /**
         * <p>
         * The identifier of the reserved-node exchange request.
         * </p>
         * 
         * @param reservedNodeExchangeRequestId
         *        The identifier of the reserved-node exchange request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodeExchangeRequestId(String reservedNodeExchangeRequestId);

        /**
         * <p>
         * The status of the reserved-node exchange request. Statuses include in-progress and requested.
         * </p>
         * 
         * @param status
         *        The status of the reserved-node exchange request. Statuses include in-progress and requested.
         * @see ReservedNodeExchangeStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedNodeExchangeStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the reserved-node exchange request. Statuses include in-progress and requested.
         * </p>
         * 
         * @param status
         *        The status of the reserved-node exchange request. Statuses include in-progress and requested.
         * @see ReservedNodeExchangeStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedNodeExchangeStatusType
         */
        Builder status(ReservedNodeExchangeStatusType status);

        /**
         * <p>
         * A date and time that indicate when the reserved-node exchange was requested.
         * </p>
         * 
         * @param requestTime
         *        A date and time that indicate when the reserved-node exchange was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTime(Instant requestTime);

        /**
         * <p>
         * The identifier of the source reserved node.
         * </p>
         * 
         * @param sourceReservedNodeId
         *        The identifier of the source reserved node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceReservedNodeId(String sourceReservedNodeId);

        /**
         * <p>
         * The source reserved-node type, for example ra3.4xlarge.
         * </p>
         * 
         * @param sourceReservedNodeType
         *        The source reserved-node type, for example ra3.4xlarge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceReservedNodeType(String sourceReservedNodeType);

        /**
         * <p>
         * The source reserved-node count in the cluster.
         * </p>
         * 
         * @param sourceReservedNodeCount
         *        The source reserved-node count in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceReservedNodeCount(Integer sourceReservedNodeCount);

        /**
         * <p>
         * The identifier of the target reserved node offering.
         * </p>
         * 
         * @param targetReservedNodeOfferingId
         *        The identifier of the target reserved node offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetReservedNodeOfferingId(String targetReservedNodeOfferingId);

        /**
         * <p>
         * The node type of the target reserved node, for example ra3.4xlarge.
         * </p>
         * 
         * @param targetReservedNodeType
         *        The node type of the target reserved node, for example ra3.4xlarge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetReservedNodeType(String targetReservedNodeType);

        /**
         * <p>
         * The count of target reserved nodes in the cluster.
         * </p>
         * 
         * @param targetReservedNodeCount
         *        The count of target reserved nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetReservedNodeCount(Integer targetReservedNodeCount);
    }

    static final class BuilderImpl implements Builder {
        private String reservedNodeExchangeRequestId;

        private String status;

        private Instant requestTime;

        private String sourceReservedNodeId;

        private String sourceReservedNodeType;

        private Integer sourceReservedNodeCount;

        private String targetReservedNodeOfferingId;

        private String targetReservedNodeType;

        private Integer targetReservedNodeCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedNodeExchangeStatus model) {
            reservedNodeExchangeRequestId(model.reservedNodeExchangeRequestId);
            status(model.status);
            requestTime(model.requestTime);
            sourceReservedNodeId(model.sourceReservedNodeId);
            sourceReservedNodeType(model.sourceReservedNodeType);
            sourceReservedNodeCount(model.sourceReservedNodeCount);
            targetReservedNodeOfferingId(model.targetReservedNodeOfferingId);
            targetReservedNodeType(model.targetReservedNodeType);
            targetReservedNodeCount(model.targetReservedNodeCount);
        }

        public final String getReservedNodeExchangeRequestId() {
            return reservedNodeExchangeRequestId;
        }

        public final void setReservedNodeExchangeRequestId(String reservedNodeExchangeRequestId) {
            this.reservedNodeExchangeRequestId = reservedNodeExchangeRequestId;
        }

        @Override
        public final Builder reservedNodeExchangeRequestId(String reservedNodeExchangeRequestId) {
            this.reservedNodeExchangeRequestId = reservedNodeExchangeRequestId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReservedNodeExchangeStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getRequestTime() {
            return requestTime;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final String getSourceReservedNodeId() {
            return sourceReservedNodeId;
        }

        public final void setSourceReservedNodeId(String sourceReservedNodeId) {
            this.sourceReservedNodeId = sourceReservedNodeId;
        }

        @Override
        public final Builder sourceReservedNodeId(String sourceReservedNodeId) {
            this.sourceReservedNodeId = sourceReservedNodeId;
            return this;
        }

        public final String getSourceReservedNodeType() {
            return sourceReservedNodeType;
        }

        public final void setSourceReservedNodeType(String sourceReservedNodeType) {
            this.sourceReservedNodeType = sourceReservedNodeType;
        }

        @Override
        public final Builder sourceReservedNodeType(String sourceReservedNodeType) {
            this.sourceReservedNodeType = sourceReservedNodeType;
            return this;
        }

        public final Integer getSourceReservedNodeCount() {
            return sourceReservedNodeCount;
        }

        public final void setSourceReservedNodeCount(Integer sourceReservedNodeCount) {
            this.sourceReservedNodeCount = sourceReservedNodeCount;
        }

        @Override
        public final Builder sourceReservedNodeCount(Integer sourceReservedNodeCount) {
            this.sourceReservedNodeCount = sourceReservedNodeCount;
            return this;
        }

        public final String getTargetReservedNodeOfferingId() {
            return targetReservedNodeOfferingId;
        }

        public final void setTargetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
        }

        @Override
        public final Builder targetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
            return this;
        }

        public final String getTargetReservedNodeType() {
            return targetReservedNodeType;
        }

        public final void setTargetReservedNodeType(String targetReservedNodeType) {
            this.targetReservedNodeType = targetReservedNodeType;
        }

        @Override
        public final Builder targetReservedNodeType(String targetReservedNodeType) {
            this.targetReservedNodeType = targetReservedNodeType;
            return this;
        }

        public final Integer getTargetReservedNodeCount() {
            return targetReservedNodeCount;
        }

        public final void setTargetReservedNodeCount(Integer targetReservedNodeCount) {
            this.targetReservedNodeCount = targetReservedNodeCount;
        }

        @Override
        public final Builder targetReservedNodeCount(Integer targetReservedNodeCount) {
            this.targetReservedNodeCount = targetReservedNodeCount;
            return this;
        }

        @Override
        public ReservedNodeExchangeStatus build() {
            return new ReservedNodeExchangeStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
