/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateDataShareConsumerRequest extends RedshiftRequest implements
        ToCopyableBuilder<AssociateDataShareConsumerRequest.Builder, AssociateDataShareConsumerRequest> {
    private static final SdkField<String> DATA_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataShareArn").getter(getter(AssociateDataShareConsumerRequest::dataShareArn))
            .setter(setter(Builder::dataShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataShareArn").build()).build();

    private static final SdkField<Boolean> ASSOCIATE_ENTIRE_ACCOUNT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AssociateEntireAccount").getter(getter(AssociateDataShareConsumerRequest::associateEntireAccount))
            .setter(setter(Builder::associateEntireAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociateEntireAccount").build())
            .build();

    private static final SdkField<String> CONSUMER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerArn").getter(getter(AssociateDataShareConsumerRequest::consumerArn))
            .setter(setter(Builder::consumerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerArn").build()).build();

    private static final SdkField<String> CONSUMER_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerRegion").getter(getter(AssociateDataShareConsumerRequest::consumerRegion))
            .setter(setter(Builder::consumerRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerRegion").build()).build();

    private static final SdkField<Boolean> ALLOW_WRITES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowWrites").getter(getter(AssociateDataShareConsumerRequest::allowWrites))
            .setter(setter(Builder::allowWrites))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowWrites").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SHARE_ARN_FIELD,
            ASSOCIATE_ENTIRE_ACCOUNT_FIELD, CONSUMER_ARN_FIELD, CONSUMER_REGION_FIELD, ALLOW_WRITES_FIELD));

    private final String dataShareArn;

    private final Boolean associateEntireAccount;

    private final String consumerArn;

    private final String consumerRegion;

    private final Boolean allowWrites;

    private AssociateDataShareConsumerRequest(BuilderImpl builder) {
        super(builder);
        this.dataShareArn = builder.dataShareArn;
        this.associateEntireAccount = builder.associateEntireAccount;
        this.consumerArn = builder.consumerArn;
        this.consumerRegion = builder.consumerRegion;
        this.allowWrites = builder.allowWrites;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the datashare that the consumer is to use.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the datashare that the consumer is to use.
     */
    public final String dataShareArn() {
        return dataShareArn;
    }

    /**
     * <p>
     * A value that specifies whether the datashare is associated with the entire account.
     * </p>
     * 
     * @return A value that specifies whether the datashare is associated with the entire account.
     */
    public final Boolean associateEntireAccount() {
        return associateEntireAccount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the consumer namespace associated with the datashare.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the consumer namespace associated with the datashare.
     */
    public final String consumerArn() {
        return consumerArn;
    }

    /**
     * <p>
     * From a datashare consumer account, associates a datashare with all existing and future namespaces in the
     * specified Amazon Web Services Region.
     * </p>
     * 
     * @return From a datashare consumer account, associates a datashare with all existing and future namespaces in the
     *         specified Amazon Web Services Region.
     */
    public final String consumerRegion() {
        return consumerRegion;
    }

    /**
     * <p>
     * If set to true, allows write operations for a datashare.
     * </p>
     * 
     * @return If set to true, allows write operations for a datashare.
     */
    public final Boolean allowWrites() {
        return allowWrites;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(associateEntireAccount());
        hashCode = 31 * hashCode + Objects.hashCode(consumerArn());
        hashCode = 31 * hashCode + Objects.hashCode(consumerRegion());
        hashCode = 31 * hashCode + Objects.hashCode(allowWrites());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateDataShareConsumerRequest)) {
            return false;
        }
        AssociateDataShareConsumerRequest other = (AssociateDataShareConsumerRequest) obj;
        return Objects.equals(dataShareArn(), other.dataShareArn())
                && Objects.equals(associateEntireAccount(), other.associateEntireAccount())
                && Objects.equals(consumerArn(), other.consumerArn()) && Objects.equals(consumerRegion(), other.consumerRegion())
                && Objects.equals(allowWrites(), other.allowWrites());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateDataShareConsumerRequest").add("DataShareArn", dataShareArn())
                .add("AssociateEntireAccount", associateEntireAccount()).add("ConsumerArn", consumerArn())
                .add("ConsumerRegion", consumerRegion()).add("AllowWrites", allowWrites()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataShareArn":
            return Optional.ofNullable(clazz.cast(dataShareArn()));
        case "AssociateEntireAccount":
            return Optional.ofNullable(clazz.cast(associateEntireAccount()));
        case "ConsumerArn":
            return Optional.ofNullable(clazz.cast(consumerArn()));
        case "ConsumerRegion":
            return Optional.ofNullable(clazz.cast(consumerRegion()));
        case "AllowWrites":
            return Optional.ofNullable(clazz.cast(allowWrites()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateDataShareConsumerRequest, T> g) {
        return obj -> g.apply((AssociateDataShareConsumerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateDataShareConsumerRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the datashare that the consumer is to use.
         * </p>
         * 
         * @param dataShareArn
         *        The Amazon Resource Name (ARN) of the datashare that the consumer is to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataShareArn(String dataShareArn);

        /**
         * <p>
         * A value that specifies whether the datashare is associated with the entire account.
         * </p>
         * 
         * @param associateEntireAccount
         *        A value that specifies whether the datashare is associated with the entire account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associateEntireAccount(Boolean associateEntireAccount);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the consumer namespace associated with the datashare.
         * </p>
         * 
         * @param consumerArn
         *        The Amazon Resource Name (ARN) of the consumer namespace associated with the datashare.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerArn(String consumerArn);

        /**
         * <p>
         * From a datashare consumer account, associates a datashare with all existing and future namespaces in the
         * specified Amazon Web Services Region.
         * </p>
         * 
         * @param consumerRegion
         *        From a datashare consumer account, associates a datashare with all existing and future namespaces in
         *        the specified Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerRegion(String consumerRegion);

        /**
         * <p>
         * If set to true, allows write operations for a datashare.
         * </p>
         * 
         * @param allowWrites
         *        If set to true, allows write operations for a datashare.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowWrites(Boolean allowWrites);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String dataShareArn;

        private Boolean associateEntireAccount;

        private String consumerArn;

        private String consumerRegion;

        private Boolean allowWrites;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateDataShareConsumerRequest model) {
            super(model);
            dataShareArn(model.dataShareArn);
            associateEntireAccount(model.associateEntireAccount);
            consumerArn(model.consumerArn);
            consumerRegion(model.consumerRegion);
            allowWrites(model.allowWrites);
        }

        public final String getDataShareArn() {
            return dataShareArn;
        }

        public final void setDataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
        }

        @Override
        public final Builder dataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
            return this;
        }

        public final Boolean getAssociateEntireAccount() {
            return associateEntireAccount;
        }

        public final void setAssociateEntireAccount(Boolean associateEntireAccount) {
            this.associateEntireAccount = associateEntireAccount;
        }

        @Override
        public final Builder associateEntireAccount(Boolean associateEntireAccount) {
            this.associateEntireAccount = associateEntireAccount;
            return this;
        }

        public final String getConsumerArn() {
            return consumerArn;
        }

        public final void setConsumerArn(String consumerArn) {
            this.consumerArn = consumerArn;
        }

        @Override
        public final Builder consumerArn(String consumerArn) {
            this.consumerArn = consumerArn;
            return this;
        }

        public final String getConsumerRegion() {
            return consumerRegion;
        }

        public final void setConsumerRegion(String consumerRegion) {
            this.consumerRegion = consumerRegion;
        }

        @Override
        public final Builder consumerRegion(String consumerRegion) {
            this.consumerRegion = consumerRegion;
            return this;
        }

        public final Boolean getAllowWrites() {
            return allowWrites;
        }

        public final void setAllowWrites(Boolean allowWrites) {
            this.allowWrites = allowWrites;
        }

        @Override
        public final Builder allowWrites(Boolean allowWrites) {
            this.allowWrites = allowWrites;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateDataShareConsumerRequest build() {
            return new AssociateDataShareConsumerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
