/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The operation that is defined by the custom action.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VisualCustomActionOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<VisualCustomActionOperation.Builder, VisualCustomActionOperation> {
    private static final SdkField<CustomActionFilterOperation> FILTER_OPERATION_FIELD = SdkField
            .<CustomActionFilterOperation> builder(MarshallingType.SDK_POJO).memberName("FilterOperation")
            .getter(getter(VisualCustomActionOperation::filterOperation)).setter(setter(Builder::filterOperation))
            .constructor(CustomActionFilterOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterOperation").build()).build();

    private static final SdkField<CustomActionNavigationOperation> NAVIGATION_OPERATION_FIELD = SdkField
            .<CustomActionNavigationOperation> builder(MarshallingType.SDK_POJO).memberName("NavigationOperation")
            .getter(getter(VisualCustomActionOperation::navigationOperation)).setter(setter(Builder::navigationOperation))
            .constructor(CustomActionNavigationOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NavigationOperation").build())
            .build();

    private static final SdkField<CustomActionURLOperation> URL_OPERATION_FIELD = SdkField
            .<CustomActionURLOperation> builder(MarshallingType.SDK_POJO).memberName("URLOperation")
            .getter(getter(VisualCustomActionOperation::urlOperation)).setter(setter(Builder::urlOperation))
            .constructor(CustomActionURLOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URLOperation").build()).build();

    private static final SdkField<CustomActionSetParametersOperation> SET_PARAMETERS_OPERATION_FIELD = SdkField
            .<CustomActionSetParametersOperation> builder(MarshallingType.SDK_POJO).memberName("SetParametersOperation")
            .getter(getter(VisualCustomActionOperation::setParametersOperation)).setter(setter(Builder::setParametersOperation))
            .constructor(CustomActionSetParametersOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetParametersOperation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_OPERATION_FIELD,
            NAVIGATION_OPERATION_FIELD, URL_OPERATION_FIELD, SET_PARAMETERS_OPERATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CustomActionFilterOperation filterOperation;

    private final CustomActionNavigationOperation navigationOperation;

    private final CustomActionURLOperation urlOperation;

    private final CustomActionSetParametersOperation setParametersOperation;

    private VisualCustomActionOperation(BuilderImpl builder) {
        this.filterOperation = builder.filterOperation;
        this.navigationOperation = builder.navigationOperation;
        this.urlOperation = builder.urlOperation;
        this.setParametersOperation = builder.setParametersOperation;
    }

    /**
     * <p>
     * The filter operation that filters data included in a visual or in an entire sheet.
     * </p>
     * 
     * @return The filter operation that filters data included in a visual or in an entire sheet.
     */
    public final CustomActionFilterOperation filterOperation() {
        return filterOperation;
    }

    /**
     * <p>
     * The navigation operation that navigates between different sheets in the same analysis.
     * </p>
     * 
     * @return The navigation operation that navigates between different sheets in the same analysis.
     */
    public final CustomActionNavigationOperation navigationOperation() {
        return navigationOperation;
    }

    /**
     * <p>
     * The URL operation that opens a link to another webpage.
     * </p>
     * 
     * @return The URL operation that opens a link to another webpage.
     */
    public final CustomActionURLOperation urlOperation() {
        return urlOperation;
    }

    /**
     * <p>
     * The set parameter operation that sets parameters in custom action.
     * </p>
     * 
     * @return The set parameter operation that sets parameters in custom action.
     */
    public final CustomActionSetParametersOperation setParametersOperation() {
        return setParametersOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterOperation());
        hashCode = 31 * hashCode + Objects.hashCode(navigationOperation());
        hashCode = 31 * hashCode + Objects.hashCode(urlOperation());
        hashCode = 31 * hashCode + Objects.hashCode(setParametersOperation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualCustomActionOperation)) {
            return false;
        }
        VisualCustomActionOperation other = (VisualCustomActionOperation) obj;
        return Objects.equals(filterOperation(), other.filterOperation())
                && Objects.equals(navigationOperation(), other.navigationOperation())
                && Objects.equals(urlOperation(), other.urlOperation())
                && Objects.equals(setParametersOperation(), other.setParametersOperation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VisualCustomActionOperation").add("FilterOperation", filterOperation())
                .add("NavigationOperation", navigationOperation()).add("URLOperation", urlOperation())
                .add("SetParametersOperation", setParametersOperation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterOperation":
            return Optional.ofNullable(clazz.cast(filterOperation()));
        case "NavigationOperation":
            return Optional.ofNullable(clazz.cast(navigationOperation()));
        case "URLOperation":
            return Optional.ofNullable(clazz.cast(urlOperation()));
        case "SetParametersOperation":
            return Optional.ofNullable(clazz.cast(setParametersOperation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VisualCustomActionOperation, T> g) {
        return obj -> g.apply((VisualCustomActionOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VisualCustomActionOperation> {
        /**
         * <p>
         * The filter operation that filters data included in a visual or in an entire sheet.
         * </p>
         * 
         * @param filterOperation
         *        The filter operation that filters data included in a visual or in an entire sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOperation(CustomActionFilterOperation filterOperation);

        /**
         * <p>
         * The filter operation that filters data included in a visual or in an entire sheet.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomActionFilterOperation.Builder}
         * avoiding the need to create one manually via {@link CustomActionFilterOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomActionFilterOperation.Builder#build()} is called
         * immediately and its result is passed to {@link #filterOperation(CustomActionFilterOperation)}.
         * 
         * @param filterOperation
         *        a consumer that will call methods on {@link CustomActionFilterOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterOperation(CustomActionFilterOperation)
         */
        default Builder filterOperation(Consumer<CustomActionFilterOperation.Builder> filterOperation) {
            return filterOperation(CustomActionFilterOperation.builder().applyMutation(filterOperation).build());
        }

        /**
         * <p>
         * The navigation operation that navigates between different sheets in the same analysis.
         * </p>
         * 
         * @param navigationOperation
         *        The navigation operation that navigates between different sheets in the same analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder navigationOperation(CustomActionNavigationOperation navigationOperation);

        /**
         * <p>
         * The navigation operation that navigates between different sheets in the same analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomActionNavigationOperation.Builder}
         * avoiding the need to create one manually via {@link CustomActionNavigationOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomActionNavigationOperation.Builder#build()} is called
         * immediately and its result is passed to {@link #navigationOperation(CustomActionNavigationOperation)}.
         * 
         * @param navigationOperation
         *        a consumer that will call methods on {@link CustomActionNavigationOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #navigationOperation(CustomActionNavigationOperation)
         */
        default Builder navigationOperation(Consumer<CustomActionNavigationOperation.Builder> navigationOperation) {
            return navigationOperation(CustomActionNavigationOperation.builder().applyMutation(navigationOperation).build());
        }

        /**
         * <p>
         * The URL operation that opens a link to another webpage.
         * </p>
         * 
         * @param urlOperation
         *        The URL operation that opens a link to another webpage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlOperation(CustomActionURLOperation urlOperation);

        /**
         * <p>
         * The URL operation that opens a link to another webpage.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomActionURLOperation.Builder}
         * avoiding the need to create one manually via {@link CustomActionURLOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomActionURLOperation.Builder#build()} is called immediately
         * and its result is passed to {@link #urlOperation(CustomActionURLOperation)}.
         * 
         * @param urlOperation
         *        a consumer that will call methods on {@link CustomActionURLOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #urlOperation(CustomActionURLOperation)
         */
        default Builder urlOperation(Consumer<CustomActionURLOperation.Builder> urlOperation) {
            return urlOperation(CustomActionURLOperation.builder().applyMutation(urlOperation).build());
        }

        /**
         * <p>
         * The set parameter operation that sets parameters in custom action.
         * </p>
         * 
         * @param setParametersOperation
         *        The set parameter operation that sets parameters in custom action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setParametersOperation(CustomActionSetParametersOperation setParametersOperation);

        /**
         * <p>
         * The set parameter operation that sets parameters in custom action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CustomActionSetParametersOperation.Builder} avoiding the need to create one manually via
         * {@link CustomActionSetParametersOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomActionSetParametersOperation.Builder#build()} is called
         * immediately and its result is passed to {@link #setParametersOperation(CustomActionSetParametersOperation)}.
         * 
         * @param setParametersOperation
         *        a consumer that will call methods on {@link CustomActionSetParametersOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #setParametersOperation(CustomActionSetParametersOperation)
         */
        default Builder setParametersOperation(Consumer<CustomActionSetParametersOperation.Builder> setParametersOperation) {
            return setParametersOperation(CustomActionSetParametersOperation.builder().applyMutation(setParametersOperation)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomActionFilterOperation filterOperation;

        private CustomActionNavigationOperation navigationOperation;

        private CustomActionURLOperation urlOperation;

        private CustomActionSetParametersOperation setParametersOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(VisualCustomActionOperation model) {
            filterOperation(model.filterOperation);
            navigationOperation(model.navigationOperation);
            urlOperation(model.urlOperation);
            setParametersOperation(model.setParametersOperation);
        }

        public final CustomActionFilterOperation.Builder getFilterOperation() {
            return filterOperation != null ? filterOperation.toBuilder() : null;
        }

        public final void setFilterOperation(CustomActionFilterOperation.BuilderImpl filterOperation) {
            this.filterOperation = filterOperation != null ? filterOperation.build() : null;
        }

        @Override
        public final Builder filterOperation(CustomActionFilterOperation filterOperation) {
            this.filterOperation = filterOperation;
            return this;
        }

        public final CustomActionNavigationOperation.Builder getNavigationOperation() {
            return navigationOperation != null ? navigationOperation.toBuilder() : null;
        }

        public final void setNavigationOperation(CustomActionNavigationOperation.BuilderImpl navigationOperation) {
            this.navigationOperation = navigationOperation != null ? navigationOperation.build() : null;
        }

        @Override
        public final Builder navigationOperation(CustomActionNavigationOperation navigationOperation) {
            this.navigationOperation = navigationOperation;
            return this;
        }

        public final CustomActionURLOperation.Builder getUrlOperation() {
            return urlOperation != null ? urlOperation.toBuilder() : null;
        }

        public final void setUrlOperation(CustomActionURLOperation.BuilderImpl urlOperation) {
            this.urlOperation = urlOperation != null ? urlOperation.build() : null;
        }

        @Override
        public final Builder urlOperation(CustomActionURLOperation urlOperation) {
            this.urlOperation = urlOperation;
            return this;
        }

        public final CustomActionSetParametersOperation.Builder getSetParametersOperation() {
            return setParametersOperation != null ? setParametersOperation.toBuilder() : null;
        }

        public final void setSetParametersOperation(CustomActionSetParametersOperation.BuilderImpl setParametersOperation) {
            this.setParametersOperation = setParametersOperation != null ? setParametersOperation.build() : null;
        }

        @Override
        @Transient
        public final Builder setParametersOperation(CustomActionSetParametersOperation setParametersOperation) {
            this.setParametersOperation = setParametersOperation;
            return this;
        }

        @Override
        public VisualCustomActionOperation build() {
            return new VisualCustomActionOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
