/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter that filters topics based on the value of a numeric field. The filter includes only topics whose numeric
 * field value falls within the specified range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicNumericRangeFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicNumericRangeFilter.Builder, TopicNumericRangeFilter> {
    private static final SdkField<Boolean> INCLUSIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Inclusive").getter(getter(TopicNumericRangeFilter::inclusive)).setter(setter(Builder::inclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inclusive").build()).build();

    private static final SdkField<TopicRangeFilterConstant> CONSTANT_FIELD = SdkField
            .<TopicRangeFilterConstant> builder(MarshallingType.SDK_POJO).memberName("Constant")
            .getter(getter(TopicNumericRangeFilter::constant)).setter(setter(Builder::constant))
            .constructor(TopicRangeFilterConstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constant").build()).build();

    private static final SdkField<String> AGGREGATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Aggregation").getter(getter(TopicNumericRangeFilter::aggregationAsString))
            .setter(setter(Builder::aggregation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUSIVE_FIELD,
            CONSTANT_FIELD, AGGREGATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean inclusive;

    private final TopicRangeFilterConstant constant;

    private final String aggregation;

    private TopicNumericRangeFilter(BuilderImpl builder) {
        this.inclusive = builder.inclusive;
        this.constant = builder.constant;
        this.aggregation = builder.aggregation;
    }

    /**
     * <p>
     * A Boolean value that indicates whether the endpoints of the numeric range are included in the filter. If set to
     * true, topics whose numeric field value is equal to the endpoint values will be included in the filter. If set to
     * false, topics whose numeric field value is equal to the endpoint values will be excluded from the filter.
     * </p>
     * 
     * @return A Boolean value that indicates whether the endpoints of the numeric range are included in the filter. If
     *         set to true, topics whose numeric field value is equal to the endpoint values will be included in the
     *         filter. If set to false, topics whose numeric field value is equal to the endpoint values will be
     *         excluded from the filter.
     */
    public final Boolean inclusive() {
        return inclusive;
    }

    /**
     * <p>
     * The constant used in a numeric range filter.
     * </p>
     * 
     * @return The constant used in a numeric range filter.
     */
    public final TopicRangeFilterConstant constant() {
        return constant;
    }

    /**
     * <p>
     * An aggregation function that specifies how to calculate the value of a numeric field for a topic, Valid values
     * for this structure are <code>NO_AGGREGATION</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>COUNT</code>,
     * <code>DISTINCT_COUNT</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>MIN</code>, <code>STDEV</code>,
     * <code>STDEVP</code>, <code>VAR</code>, and <code>VARP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link NamedFilterAggType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggregationAsString}.
     * </p>
     * 
     * @return An aggregation function that specifies how to calculate the value of a numeric field for a topic, Valid
     *         values for this structure are <code>NO_AGGREGATION</code>, <code>SUM</code>, <code>AVERAGE</code>,
     *         <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>MIN</code>,
     *         <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, and <code>VARP</code>.
     * @see NamedFilterAggType
     */
    public final NamedFilterAggType aggregation() {
        return NamedFilterAggType.fromValue(aggregation);
    }

    /**
     * <p>
     * An aggregation function that specifies how to calculate the value of a numeric field for a topic, Valid values
     * for this structure are <code>NO_AGGREGATION</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>COUNT</code>,
     * <code>DISTINCT_COUNT</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>MIN</code>, <code>STDEV</code>,
     * <code>STDEVP</code>, <code>VAR</code>, and <code>VARP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link NamedFilterAggType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggregationAsString}.
     * </p>
     * 
     * @return An aggregation function that specifies how to calculate the value of a numeric field for a topic, Valid
     *         values for this structure are <code>NO_AGGREGATION</code>, <code>SUM</code>, <code>AVERAGE</code>,
     *         <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>MIN</code>,
     *         <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, and <code>VARP</code>.
     * @see NamedFilterAggType
     */
    public final String aggregationAsString() {
        return aggregation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inclusive());
        hashCode = 31 * hashCode + Objects.hashCode(constant());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicNumericRangeFilter)) {
            return false;
        }
        TopicNumericRangeFilter other = (TopicNumericRangeFilter) obj;
        return Objects.equals(inclusive(), other.inclusive()) && Objects.equals(constant(), other.constant())
                && Objects.equals(aggregationAsString(), other.aggregationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicNumericRangeFilter").add("Inclusive", inclusive())
                .add("Constant", constant() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Aggregation", aggregationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Inclusive":
            return Optional.ofNullable(clazz.cast(inclusive()));
        case "Constant":
            return Optional.ofNullable(clazz.cast(constant()));
        case "Aggregation":
            return Optional.ofNullable(clazz.cast(aggregationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicNumericRangeFilter, T> g) {
        return obj -> g.apply((TopicNumericRangeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicNumericRangeFilter> {
        /**
         * <p>
         * A Boolean value that indicates whether the endpoints of the numeric range are included in the filter. If set
         * to true, topics whose numeric field value is equal to the endpoint values will be included in the filter. If
         * set to false, topics whose numeric field value is equal to the endpoint values will be excluded from the
         * filter.
         * </p>
         * 
         * @param inclusive
         *        A Boolean value that indicates whether the endpoints of the numeric range are included in the filter.
         *        If set to true, topics whose numeric field value is equal to the endpoint values will be included in
         *        the filter. If set to false, topics whose numeric field value is equal to the endpoint values will be
         *        excluded from the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusive(Boolean inclusive);

        /**
         * <p>
         * The constant used in a numeric range filter.
         * </p>
         * 
         * @param constant
         *        The constant used in a numeric range filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constant(TopicRangeFilterConstant constant);

        /**
         * <p>
         * The constant used in a numeric range filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicRangeFilterConstant.Builder}
         * avoiding the need to create one manually via {@link TopicRangeFilterConstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicRangeFilterConstant.Builder#build()} is called immediately
         * and its result is passed to {@link #constant(TopicRangeFilterConstant)}.
         * 
         * @param constant
         *        a consumer that will call methods on {@link TopicRangeFilterConstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constant(TopicRangeFilterConstant)
         */
        default Builder constant(Consumer<TopicRangeFilterConstant.Builder> constant) {
            return constant(TopicRangeFilterConstant.builder().applyMutation(constant).build());
        }

        /**
         * <p>
         * An aggregation function that specifies how to calculate the value of a numeric field for a topic, Valid
         * values for this structure are <code>NO_AGGREGATION</code>, <code>SUM</code>, <code>AVERAGE</code>,
         * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>MIN</code>,
         * <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, and <code>VARP</code>.
         * </p>
         * 
         * @param aggregation
         *        An aggregation function that specifies how to calculate the value of a numeric field for a topic,
         *        Valid values for this structure are <code>NO_AGGREGATION</code>, <code>SUM</code>,
         *        <code>AVERAGE</code>, <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>MIN</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, and
         *        <code>VARP</code>.
         * @see NamedFilterAggType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamedFilterAggType
         */
        Builder aggregation(String aggregation);

        /**
         * <p>
         * An aggregation function that specifies how to calculate the value of a numeric field for a topic, Valid
         * values for this structure are <code>NO_AGGREGATION</code>, <code>SUM</code>, <code>AVERAGE</code>,
         * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>MIN</code>,
         * <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, and <code>VARP</code>.
         * </p>
         * 
         * @param aggregation
         *        An aggregation function that specifies how to calculate the value of a numeric field for a topic,
         *        Valid values for this structure are <code>NO_AGGREGATION</code>, <code>SUM</code>,
         *        <code>AVERAGE</code>, <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>MIN</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, and
         *        <code>VARP</code>.
         * @see NamedFilterAggType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamedFilterAggType
         */
        Builder aggregation(NamedFilterAggType aggregation);
    }

    static final class BuilderImpl implements Builder {
        private Boolean inclusive;

        private TopicRangeFilterConstant constant;

        private String aggregation;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicNumericRangeFilter model) {
            inclusive(model.inclusive);
            constant(model.constant);
            aggregation(model.aggregation);
        }

        public final Boolean getInclusive() {
            return inclusive;
        }

        public final void setInclusive(Boolean inclusive) {
            this.inclusive = inclusive;
        }

        @Override
        public final Builder inclusive(Boolean inclusive) {
            this.inclusive = inclusive;
            return this;
        }

        public final TopicRangeFilterConstant.Builder getConstant() {
            return constant != null ? constant.toBuilder() : null;
        }

        public final void setConstant(TopicRangeFilterConstant.BuilderImpl constant) {
            this.constant = constant != null ? constant.build() : null;
        }

        @Override
        public final Builder constant(TopicRangeFilterConstant constant) {
            this.constant = constant;
            return this;
        }

        public final String getAggregation() {
            return aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(NamedFilterAggType aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        @Override
        public TopicNumericRangeFilter build() {
            return new TopicNumericRangeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
