/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The inline visualization of a specific type to display within a chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableInlineVisualization implements SdkPojo, Serializable,
        ToCopyableBuilder<TableInlineVisualization.Builder, TableInlineVisualization> {
    private static final SdkField<DataBarsOptions> DATA_BARS_FIELD = SdkField.<DataBarsOptions> builder(MarshallingType.SDK_POJO)
            .memberName("DataBars").getter(getter(TableInlineVisualization::dataBars)).setter(setter(Builder::dataBars))
            .constructor(DataBarsOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataBars").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_BARS_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataBarsOptions dataBars;

    private TableInlineVisualization(BuilderImpl builder) {
        this.dataBars = builder.dataBars;
    }

    /**
     * <p>
     * The configuration of the inline visualization of the data bars within a chart.
     * </p>
     * 
     * @return The configuration of the inline visualization of the data bars within a chart.
     */
    public final DataBarsOptions dataBars() {
        return dataBars;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataBars());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableInlineVisualization)) {
            return false;
        }
        TableInlineVisualization other = (TableInlineVisualization) obj;
        return Objects.equals(dataBars(), other.dataBars());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableInlineVisualization").add("DataBars", dataBars()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataBars":
            return Optional.ofNullable(clazz.cast(dataBars()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableInlineVisualization, T> g) {
        return obj -> g.apply((TableInlineVisualization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableInlineVisualization> {
        /**
         * <p>
         * The configuration of the inline visualization of the data bars within a chart.
         * </p>
         * 
         * @param dataBars
         *        The configuration of the inline visualization of the data bars within a chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataBars(DataBarsOptions dataBars);

        /**
         * <p>
         * The configuration of the inline visualization of the data bars within a chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataBarsOptions.Builder} avoiding the
         * need to create one manually via {@link DataBarsOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataBarsOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dataBars(DataBarsOptions)}.
         * 
         * @param dataBars
         *        a consumer that will call methods on {@link DataBarsOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataBars(DataBarsOptions)
         */
        default Builder dataBars(Consumer<DataBarsOptions.Builder> dataBars) {
            return dataBars(DataBarsOptions.builder().applyMutation(dataBars).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataBarsOptions dataBars;

        private BuilderImpl() {
        }

        private BuilderImpl(TableInlineVisualization model) {
            dataBars(model.dataBars);
        }

        public final DataBarsOptions.Builder getDataBars() {
            return dataBars != null ? dataBars.toBuilder() : null;
        }

        public final void setDataBars(DataBarsOptions.BuilderImpl dataBars) {
            this.dataBars = dataBars != null ? dataBars.build() : null;
        }

        @Override
        public final Builder dataBars(DataBarsOptions dataBars) {
            this.dataBars = dataBars;
            return this;
        }

        @Override
        public TableInlineVisualization build() {
            return new TableInlineVisualization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
