/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Formatting configuration for string fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StringFormatConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StringFormatConfiguration.Builder, StringFormatConfiguration> {
    private static final SdkField<NullValueFormatConfiguration> NULL_VALUE_FORMAT_CONFIGURATION_FIELD = SdkField
            .<NullValueFormatConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("NullValueFormatConfiguration")
            .getter(getter(StringFormatConfiguration::nullValueFormatConfiguration))
            .setter(setter(Builder::nullValueFormatConfiguration))
            .constructor(NullValueFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullValueFormatConfiguration")
                    .build()).build();

    private static final SdkField<NumericFormatConfiguration> NUMERIC_FORMAT_CONFIGURATION_FIELD = SdkField
            .<NumericFormatConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("NumericFormatConfiguration")
            .getter(getter(StringFormatConfiguration::numericFormatConfiguration))
            .setter(setter(Builder::numericFormatConfiguration))
            .constructor(NumericFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericFormatConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NULL_VALUE_FORMAT_CONFIGURATION_FIELD, NUMERIC_FORMAT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final NullValueFormatConfiguration nullValueFormatConfiguration;

    private final NumericFormatConfiguration numericFormatConfiguration;

    private StringFormatConfiguration(BuilderImpl builder) {
        this.nullValueFormatConfiguration = builder.nullValueFormatConfiguration;
        this.numericFormatConfiguration = builder.numericFormatConfiguration;
    }

    /**
     * <p>
     * The options that determine the null value format configuration.
     * </p>
     * 
     * @return The options that determine the null value format configuration.
     */
    public final NullValueFormatConfiguration nullValueFormatConfiguration() {
        return nullValueFormatConfiguration;
    }

    /**
     * <p>
     * The formatting configuration for numeric strings.
     * </p>
     * 
     * @return The formatting configuration for numeric strings.
     */
    public final NumericFormatConfiguration numericFormatConfiguration() {
        return numericFormatConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nullValueFormatConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(numericFormatConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringFormatConfiguration)) {
            return false;
        }
        StringFormatConfiguration other = (StringFormatConfiguration) obj;
        return Objects.equals(nullValueFormatConfiguration(), other.nullValueFormatConfiguration())
                && Objects.equals(numericFormatConfiguration(), other.numericFormatConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StringFormatConfiguration").add("NullValueFormatConfiguration", nullValueFormatConfiguration())
                .add("NumericFormatConfiguration", numericFormatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NullValueFormatConfiguration":
            return Optional.ofNullable(clazz.cast(nullValueFormatConfiguration()));
        case "NumericFormatConfiguration":
            return Optional.ofNullable(clazz.cast(numericFormatConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StringFormatConfiguration, T> g) {
        return obj -> g.apply((StringFormatConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StringFormatConfiguration> {
        /**
         * <p>
         * The options that determine the null value format configuration.
         * </p>
         * 
         * @param nullValueFormatConfiguration
         *        The options that determine the null value format configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nullValueFormatConfiguration(NullValueFormatConfiguration nullValueFormatConfiguration);

        /**
         * <p>
         * The options that determine the null value format configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link NullValueFormatConfiguration.Builder}
         * avoiding the need to create one manually via {@link NullValueFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NullValueFormatConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #nullValueFormatConfiguration(NullValueFormatConfiguration)}.
         * 
         * @param nullValueFormatConfiguration
         *        a consumer that will call methods on {@link NullValueFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nullValueFormatConfiguration(NullValueFormatConfiguration)
         */
        default Builder nullValueFormatConfiguration(Consumer<NullValueFormatConfiguration.Builder> nullValueFormatConfiguration) {
            return nullValueFormatConfiguration(NullValueFormatConfiguration.builder()
                    .applyMutation(nullValueFormatConfiguration).build());
        }

        /**
         * <p>
         * The formatting configuration for numeric strings.
         * </p>
         * 
         * @param numericFormatConfiguration
         *        The formatting configuration for numeric strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numericFormatConfiguration(NumericFormatConfiguration numericFormatConfiguration);

        /**
         * <p>
         * The formatting configuration for numeric strings.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericFormatConfiguration.Builder}
         * avoiding the need to create one manually via {@link NumericFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericFormatConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #numericFormatConfiguration(NumericFormatConfiguration)}.
         * 
         * @param numericFormatConfiguration
         *        a consumer that will call methods on {@link NumericFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numericFormatConfiguration(NumericFormatConfiguration)
         */
        default Builder numericFormatConfiguration(Consumer<NumericFormatConfiguration.Builder> numericFormatConfiguration) {
            return numericFormatConfiguration(NumericFormatConfiguration.builder().applyMutation(numericFormatConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NullValueFormatConfiguration nullValueFormatConfiguration;

        private NumericFormatConfiguration numericFormatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StringFormatConfiguration model) {
            nullValueFormatConfiguration(model.nullValueFormatConfiguration);
            numericFormatConfiguration(model.numericFormatConfiguration);
        }

        public final NullValueFormatConfiguration.Builder getNullValueFormatConfiguration() {
            return nullValueFormatConfiguration != null ? nullValueFormatConfiguration.toBuilder() : null;
        }

        public final void setNullValueFormatConfiguration(NullValueFormatConfiguration.BuilderImpl nullValueFormatConfiguration) {
            this.nullValueFormatConfiguration = nullValueFormatConfiguration != null ? nullValueFormatConfiguration.build()
                    : null;
        }

        @Override
        public final Builder nullValueFormatConfiguration(NullValueFormatConfiguration nullValueFormatConfiguration) {
            this.nullValueFormatConfiguration = nullValueFormatConfiguration;
            return this;
        }

        public final NumericFormatConfiguration.Builder getNumericFormatConfiguration() {
            return numericFormatConfiguration != null ? numericFormatConfiguration.toBuilder() : null;
        }

        public final void setNumericFormatConfiguration(NumericFormatConfiguration.BuilderImpl numericFormatConfiguration) {
            this.numericFormatConfiguration = numericFormatConfiguration != null ? numericFormatConfiguration.build() : null;
        }

        @Override
        public final Builder numericFormatConfiguration(NumericFormatConfiguration numericFormatConfiguration) {
            this.numericFormatConfiguration = numericFormatConfiguration;
            return this;
        }

        @Override
        public StringFormatConfiguration build() {
            return new StringFormatConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
