/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for the canvas of a section-based layout.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SectionBasedLayoutCanvasSizeOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<SectionBasedLayoutCanvasSizeOptions.Builder, SectionBasedLayoutCanvasSizeOptions> {
    private static final SdkField<SectionBasedLayoutPaperCanvasSizeOptions> PAPER_CANVAS_SIZE_OPTIONS_FIELD = SdkField
            .<SectionBasedLayoutPaperCanvasSizeOptions> builder(MarshallingType.SDK_POJO).memberName("PaperCanvasSizeOptions")
            .getter(getter(SectionBasedLayoutCanvasSizeOptions::paperCanvasSizeOptions))
            .setter(setter(Builder::paperCanvasSizeOptions)).constructor(SectionBasedLayoutPaperCanvasSizeOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaperCanvasSizeOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PAPER_CANVAS_SIZE_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SectionBasedLayoutPaperCanvasSizeOptions paperCanvasSizeOptions;

    private SectionBasedLayoutCanvasSizeOptions(BuilderImpl builder) {
        this.paperCanvasSizeOptions = builder.paperCanvasSizeOptions;
    }

    /**
     * <p>
     * The options for a paper canvas of a section-based layout.
     * </p>
     * 
     * @return The options for a paper canvas of a section-based layout.
     */
    public final SectionBasedLayoutPaperCanvasSizeOptions paperCanvasSizeOptions() {
        return paperCanvasSizeOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(paperCanvasSizeOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SectionBasedLayoutCanvasSizeOptions)) {
            return false;
        }
        SectionBasedLayoutCanvasSizeOptions other = (SectionBasedLayoutCanvasSizeOptions) obj;
        return Objects.equals(paperCanvasSizeOptions(), other.paperCanvasSizeOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SectionBasedLayoutCanvasSizeOptions").add("PaperCanvasSizeOptions", paperCanvasSizeOptions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PaperCanvasSizeOptions":
            return Optional.ofNullable(clazz.cast(paperCanvasSizeOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SectionBasedLayoutCanvasSizeOptions, T> g) {
        return obj -> g.apply((SectionBasedLayoutCanvasSizeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SectionBasedLayoutCanvasSizeOptions> {
        /**
         * <p>
         * The options for a paper canvas of a section-based layout.
         * </p>
         * 
         * @param paperCanvasSizeOptions
         *        The options for a paper canvas of a section-based layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptions paperCanvasSizeOptions);

        /**
         * <p>
         * The options for a paper canvas of a section-based layout.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SectionBasedLayoutPaperCanvasSizeOptions.Builder} avoiding the need to create one manually via
         * {@link SectionBasedLayoutPaperCanvasSizeOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SectionBasedLayoutPaperCanvasSizeOptions.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptions)}.
         * 
         * @param paperCanvasSizeOptions
         *        a consumer that will call methods on {@link SectionBasedLayoutPaperCanvasSizeOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptions)
         */
        default Builder paperCanvasSizeOptions(Consumer<SectionBasedLayoutPaperCanvasSizeOptions.Builder> paperCanvasSizeOptions) {
            return paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptions.builder()
                    .applyMutation(paperCanvasSizeOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SectionBasedLayoutPaperCanvasSizeOptions paperCanvasSizeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SectionBasedLayoutCanvasSizeOptions model) {
            paperCanvasSizeOptions(model.paperCanvasSizeOptions);
        }

        public final SectionBasedLayoutPaperCanvasSizeOptions.Builder getPaperCanvasSizeOptions() {
            return paperCanvasSizeOptions != null ? paperCanvasSizeOptions.toBuilder() : null;
        }

        public final void setPaperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptions.BuilderImpl paperCanvasSizeOptions) {
            this.paperCanvasSizeOptions = paperCanvasSizeOptions != null ? paperCanvasSizeOptions.build() : null;
        }

        @Override
        public final Builder paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptions paperCanvasSizeOptions) {
            this.paperCanvasSizeOptions = paperCanvasSizeOptions;
            return this;
        }

        @Override
        public SectionBasedLayoutCanvasSizeOptions build() {
            return new SectionBasedLayoutCanvasSizeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
