/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The aggregated field well configuration of a <code>RadarChartVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RadarChartAggregatedFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<RadarChartAggregatedFieldWells.Builder, RadarChartAggregatedFieldWells> {
    private static final SdkField<List<DimensionField>> CATEGORY_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Category")
            .getter(getter(RadarChartAggregatedFieldWells::category))
            .setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionField>> COLOR_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Color")
            .getter(getter(RadarChartAggregatedFieldWells::color))
            .setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> VALUES_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(RadarChartAggregatedFieldWells::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, COLOR_FIELD,
            VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DimensionField> category;

    private final List<DimensionField> color;

    private final List<MeasureField> values;

    private RadarChartAggregatedFieldWells(BuilderImpl builder) {
        this.category = builder.category;
        this.color = builder.color;
        this.values = builder.values;
    }

    /**
     * For responses, this returns true if the service returned a value for the Category property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategory() {
        return category != null && !(category instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The aggregated field well categories of a radar chart.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategory} method.
     * </p>
     * 
     * @return The aggregated field well categories of a radar chart.
     */
    public final List<DimensionField> category() {
        return category;
    }

    /**
     * For responses, this returns true if the service returned a value for the Color property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasColor() {
        return color != null && !(color instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The color that are assigned to the aggregated field wells of a radar chart.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColor} method.
     * </p>
     * 
     * @return The color that are assigned to the aggregated field wells of a radar chart.
     */
    public final List<DimensionField> color() {
        return color;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values that are assigned to the aggregated field wells of a radar chart.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The values that are assigned to the aggregated field wells of a radar chart.
     */
    public final List<MeasureField> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCategory() ? category() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasColor() ? color() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RadarChartAggregatedFieldWells)) {
            return false;
        }
        RadarChartAggregatedFieldWells other = (RadarChartAggregatedFieldWells) obj;
        return hasCategory() == other.hasCategory() && Objects.equals(category(), other.category())
                && hasColor() == other.hasColor() && Objects.equals(color(), other.color()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RadarChartAggregatedFieldWells").add("Category", hasCategory() ? category() : null)
                .add("Color", hasColor() ? color() : null).add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RadarChartAggregatedFieldWells, T> g) {
        return obj -> g.apply((RadarChartAggregatedFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RadarChartAggregatedFieldWells> {
        /**
         * <p>
         * The aggregated field well categories of a radar chart.
         * </p>
         * 
         * @param category
         *        The aggregated field well categories of a radar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(Collection<DimensionField> category);

        /**
         * <p>
         * The aggregated field well categories of a radar chart.
         * </p>
         * 
         * @param category
         *        The aggregated field well categories of a radar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(DimensionField... category);

        /**
         * <p>
         * The aggregated field well categories of a radar chart.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #category(List<DimensionField>)}.
         * 
         * @param category
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #category(java.util.Collection<DimensionField>)
         */
        Builder category(Consumer<DimensionField.Builder>... category);

        /**
         * <p>
         * The color that are assigned to the aggregated field wells of a radar chart.
         * </p>
         * 
         * @param color
         *        The color that are assigned to the aggregated field wells of a radar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(Collection<DimensionField> color);

        /**
         * <p>
         * The color that are assigned to the aggregated field wells of a radar chart.
         * </p>
         * 
         * @param color
         *        The color that are assigned to the aggregated field wells of a radar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(DimensionField... color);

        /**
         * <p>
         * The color that are assigned to the aggregated field wells of a radar chart.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #color(List<DimensionField>)}.
         * 
         * @param color
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #color(java.util.Collection<DimensionField>)
         */
        Builder color(Consumer<DimensionField.Builder>... color);

        /**
         * <p>
         * The values that are assigned to the aggregated field wells of a radar chart.
         * </p>
         * 
         * @param values
         *        The values that are assigned to the aggregated field wells of a radar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<MeasureField> values);

        /**
         * <p>
         * The values that are assigned to the aggregated field wells of a radar chart.
         * </p>
         * 
         * @param values
         *        The values that are assigned to the aggregated field wells of a radar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(MeasureField... values);

        /**
         * <p>
         * The values that are assigned to the aggregated field wells of a radar chart.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #values(List<MeasureField>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<MeasureField>)
         */
        Builder values(Consumer<MeasureField.Builder>... values);
    }

    static final class BuilderImpl implements Builder {
        private List<DimensionField> category = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionField> color = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RadarChartAggregatedFieldWells model) {
            category(model.category);
            color(model.color);
            values(model.values);
        }

        public final List<DimensionField.Builder> getCategory() {
            List<DimensionField.Builder> result = RadarChartCategoryFieldListCopier.copyToBuilder(this.category);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategory(Collection<DimensionField.BuilderImpl> category) {
            this.category = RadarChartCategoryFieldListCopier.copyFromBuilder(category);
        }

        @Override
        public final Builder category(Collection<DimensionField> category) {
            this.category = RadarChartCategoryFieldListCopier.copy(category);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder category(DimensionField... category) {
            category(Arrays.asList(category));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder category(Consumer<DimensionField.Builder>... category) {
            category(Stream.of(category).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionField.Builder> getColor() {
            List<DimensionField.Builder> result = RadarChartColorFieldListCopier.copyToBuilder(this.color);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColor(Collection<DimensionField.BuilderImpl> color) {
            this.color = RadarChartColorFieldListCopier.copyFromBuilder(color);
        }

        @Override
        public final Builder color(Collection<DimensionField> color) {
            this.color = RadarChartColorFieldListCopier.copy(color);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder color(DimensionField... color) {
            color(Arrays.asList(color));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder color(Consumer<DimensionField.Builder>... color) {
            color(Stream.of(color).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getValues() {
            List<MeasureField.Builder> result = RadarChartValuesFieldListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<MeasureField.BuilderImpl> values) {
            this.values = RadarChartValuesFieldListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<MeasureField> values) {
            this.values = RadarChartValuesFieldListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(MeasureField... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<MeasureField.Builder>... values) {
            values(Stream.of(values).map(c -> MeasureField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RadarChartAggregatedFieldWells build() {
            return new RadarChartAggregatedFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
