/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Aggregation for numerical values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumericalAggregationFunction implements SdkPojo, Serializable,
        ToCopyableBuilder<NumericalAggregationFunction.Builder, NumericalAggregationFunction> {
    private static final SdkField<String> SIMPLE_NUMERICAL_AGGREGATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SimpleNumericalAggregation")
            .getter(getter(NumericalAggregationFunction::simpleNumericalAggregationAsString))
            .setter(setter(Builder::simpleNumericalAggregation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimpleNumericalAggregation").build())
            .build();

    private static final SdkField<PercentileAggregation> PERCENTILE_AGGREGATION_FIELD = SdkField
            .<PercentileAggregation> builder(MarshallingType.SDK_POJO).memberName("PercentileAggregation")
            .getter(getter(NumericalAggregationFunction::percentileAggregation)).setter(setter(Builder::percentileAggregation))
            .constructor(PercentileAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentileAggregation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SIMPLE_NUMERICAL_AGGREGATION_FIELD, PERCENTILE_AGGREGATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String simpleNumericalAggregation;

    private final PercentileAggregation percentileAggregation;

    private NumericalAggregationFunction(BuilderImpl builder) {
        this.simpleNumericalAggregation = builder.simpleNumericalAggregation;
        this.percentileAggregation = builder.percentileAggregation;
    }

    /**
     * <p>
     * Built-in aggregation functions for numerical values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUM</code>: The sum of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AVERAGE</code>: The average of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MIN</code>: The minimum value of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MAX</code>: The maximum value of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COUNT</code>: The count of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISTINCT_COUNT</code>: The count of distinct values in a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VAR</code>: The variance of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VARP</code>: The partitioned variance of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STDEV</code>: The standard deviation of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STDEVP</code>: The partitioned standard deviation of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MEDIAN</code>: The median value of a dimension or measure.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #simpleNumericalAggregation} will return {@link SimpleNumericalAggregationFunction#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #simpleNumericalAggregationAsString}.
     * </p>
     * 
     * @return Built-in aggregation functions for numerical values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUM</code>: The sum of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AVERAGE</code>: The average of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MIN</code>: The minimum value of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MAX</code>: The maximum value of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COUNT</code>: The count of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISTINCT_COUNT</code>: The count of distinct values in a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VAR</code>: The variance of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VARP</code>: The partitioned variance of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STDEV</code>: The standard deviation of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STDEVP</code>: The partitioned standard deviation of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MEDIAN</code>: The median value of a dimension or measure.
     *         </p>
     *         </li>
     * @see SimpleNumericalAggregationFunction
     */
    public final SimpleNumericalAggregationFunction simpleNumericalAggregation() {
        return SimpleNumericalAggregationFunction.fromValue(simpleNumericalAggregation);
    }

    /**
     * <p>
     * Built-in aggregation functions for numerical values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUM</code>: The sum of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AVERAGE</code>: The average of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MIN</code>: The minimum value of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MAX</code>: The maximum value of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COUNT</code>: The count of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISTINCT_COUNT</code>: The count of distinct values in a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VAR</code>: The variance of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VARP</code>: The partitioned variance of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STDEV</code>: The standard deviation of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STDEVP</code>: The partitioned standard deviation of a dimension or measure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MEDIAN</code>: The median value of a dimension or measure.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #simpleNumericalAggregation} will return {@link SimpleNumericalAggregationFunction#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #simpleNumericalAggregationAsString}.
     * </p>
     * 
     * @return Built-in aggregation functions for numerical values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUM</code>: The sum of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AVERAGE</code>: The average of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MIN</code>: The minimum value of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MAX</code>: The maximum value of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COUNT</code>: The count of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISTINCT_COUNT</code>: The count of distinct values in a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VAR</code>: The variance of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VARP</code>: The partitioned variance of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STDEV</code>: The standard deviation of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STDEVP</code>: The partitioned standard deviation of a dimension or measure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MEDIAN</code>: The median value of a dimension or measure.
     *         </p>
     *         </li>
     * @see SimpleNumericalAggregationFunction
     */
    public final String simpleNumericalAggregationAsString() {
        return simpleNumericalAggregation;
    }

    /**
     * <p>
     * An aggregation based on the percentile of values in a dimension or measure.
     * </p>
     * 
     * @return An aggregation based on the percentile of values in a dimension or measure.
     */
    public final PercentileAggregation percentileAggregation() {
        return percentileAggregation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(simpleNumericalAggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(percentileAggregation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericalAggregationFunction)) {
            return false;
        }
        NumericalAggregationFunction other = (NumericalAggregationFunction) obj;
        return Objects.equals(simpleNumericalAggregationAsString(), other.simpleNumericalAggregationAsString())
                && Objects.equals(percentileAggregation(), other.percentileAggregation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NumericalAggregationFunction")
                .add("SimpleNumericalAggregation", simpleNumericalAggregationAsString())
                .add("PercentileAggregation", percentileAggregation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SimpleNumericalAggregation":
            return Optional.ofNullable(clazz.cast(simpleNumericalAggregationAsString()));
        case "PercentileAggregation":
            return Optional.ofNullable(clazz.cast(percentileAggregation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NumericalAggregationFunction, T> g) {
        return obj -> g.apply((NumericalAggregationFunction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumericalAggregationFunction> {
        /**
         * <p>
         * Built-in aggregation functions for numerical values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUM</code>: The sum of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AVERAGE</code>: The average of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MIN</code>: The minimum value of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MAX</code>: The maximum value of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COUNT</code>: The count of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISTINCT_COUNT</code>: The count of distinct values in a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VAR</code>: The variance of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VARP</code>: The partitioned variance of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STDEV</code>: The standard deviation of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STDEVP</code>: The partitioned standard deviation of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEDIAN</code>: The median value of a dimension or measure.
         * </p>
         * </li>
         * </ul>
         * 
         * @param simpleNumericalAggregation
         *        Built-in aggregation functions for numerical values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUM</code>: The sum of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AVERAGE</code>: The average of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MIN</code>: The minimum value of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MAX</code>: The maximum value of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COUNT</code>: The count of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISTINCT_COUNT</code>: The count of distinct values in a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VAR</code>: The variance of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VARP</code>: The partitioned variance of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STDEV</code>: The standard deviation of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STDEVP</code>: The partitioned standard deviation of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MEDIAN</code>: The median value of a dimension or measure.
         *        </p>
         *        </li>
         * @see SimpleNumericalAggregationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimpleNumericalAggregationFunction
         */
        Builder simpleNumericalAggregation(String simpleNumericalAggregation);

        /**
         * <p>
         * Built-in aggregation functions for numerical values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUM</code>: The sum of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AVERAGE</code>: The average of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MIN</code>: The minimum value of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MAX</code>: The maximum value of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COUNT</code>: The count of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISTINCT_COUNT</code>: The count of distinct values in a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VAR</code>: The variance of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VARP</code>: The partitioned variance of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STDEV</code>: The standard deviation of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STDEVP</code>: The partitioned standard deviation of a dimension or measure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEDIAN</code>: The median value of a dimension or measure.
         * </p>
         * </li>
         * </ul>
         * 
         * @param simpleNumericalAggregation
         *        Built-in aggregation functions for numerical values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUM</code>: The sum of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AVERAGE</code>: The average of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MIN</code>: The minimum value of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MAX</code>: The maximum value of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COUNT</code>: The count of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISTINCT_COUNT</code>: The count of distinct values in a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VAR</code>: The variance of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VARP</code>: The partitioned variance of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STDEV</code>: The standard deviation of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STDEVP</code>: The partitioned standard deviation of a dimension or measure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MEDIAN</code>: The median value of a dimension or measure.
         *        </p>
         *        </li>
         * @see SimpleNumericalAggregationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimpleNumericalAggregationFunction
         */
        Builder simpleNumericalAggregation(SimpleNumericalAggregationFunction simpleNumericalAggregation);

        /**
         * <p>
         * An aggregation based on the percentile of values in a dimension or measure.
         * </p>
         * 
         * @param percentileAggregation
         *        An aggregation based on the percentile of values in a dimension or measure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentileAggregation(PercentileAggregation percentileAggregation);

        /**
         * <p>
         * An aggregation based on the percentile of values in a dimension or measure.
         * </p>
         * This is a convenience method that creates an instance of the {@link PercentileAggregation.Builder} avoiding
         * the need to create one manually via {@link PercentileAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PercentileAggregation.Builder#build()} is called immediately and
         * its result is passed to {@link #percentileAggregation(PercentileAggregation)}.
         * 
         * @param percentileAggregation
         *        a consumer that will call methods on {@link PercentileAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #percentileAggregation(PercentileAggregation)
         */
        default Builder percentileAggregation(Consumer<PercentileAggregation.Builder> percentileAggregation) {
            return percentileAggregation(PercentileAggregation.builder().applyMutation(percentileAggregation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String simpleNumericalAggregation;

        private PercentileAggregation percentileAggregation;

        private BuilderImpl() {
        }

        private BuilderImpl(NumericalAggregationFunction model) {
            simpleNumericalAggregation(model.simpleNumericalAggregation);
            percentileAggregation(model.percentileAggregation);
        }

        public final String getSimpleNumericalAggregation() {
            return simpleNumericalAggregation;
        }

        public final void setSimpleNumericalAggregation(String simpleNumericalAggregation) {
            this.simpleNumericalAggregation = simpleNumericalAggregation;
        }

        @Override
        public final Builder simpleNumericalAggregation(String simpleNumericalAggregation) {
            this.simpleNumericalAggregation = simpleNumericalAggregation;
            return this;
        }

        @Override
        public final Builder simpleNumericalAggregation(SimpleNumericalAggregationFunction simpleNumericalAggregation) {
            this.simpleNumericalAggregation(simpleNumericalAggregation == null ? null : simpleNumericalAggregation.toString());
            return this;
        }

        public final PercentileAggregation.Builder getPercentileAggregation() {
            return percentileAggregation != null ? percentileAggregation.toBuilder() : null;
        }

        public final void setPercentileAggregation(PercentileAggregation.BuilderImpl percentileAggregation) {
            this.percentileAggregation = percentileAggregation != null ? percentileAggregation.build() : null;
        }

        @Override
        public final Builder percentileAggregation(PercentileAggregation percentileAggregation) {
            this.percentileAggregation = percentileAggregation;
            return this;
        }

        @Override
        public NumericalAggregationFunction build() {
            return new NumericalAggregationFunction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
