/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The forecast scenario of a forecast in the line chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ForecastScenario implements SdkPojo, Serializable,
        ToCopyableBuilder<ForecastScenario.Builder, ForecastScenario> {
    private static final SdkField<WhatIfPointScenario> WHAT_IF_POINT_SCENARIO_FIELD = SdkField
            .<WhatIfPointScenario> builder(MarshallingType.SDK_POJO).memberName("WhatIfPointScenario")
            .getter(getter(ForecastScenario::whatIfPointScenario)).setter(setter(Builder::whatIfPointScenario))
            .constructor(WhatIfPointScenario::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfPointScenario").build())
            .build();

    private static final SdkField<WhatIfRangeScenario> WHAT_IF_RANGE_SCENARIO_FIELD = SdkField
            .<WhatIfRangeScenario> builder(MarshallingType.SDK_POJO).memberName("WhatIfRangeScenario")
            .getter(getter(ForecastScenario::whatIfRangeScenario)).setter(setter(Builder::whatIfRangeScenario))
            .constructor(WhatIfRangeScenario::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfRangeScenario").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WHAT_IF_POINT_SCENARIO_FIELD,
            WHAT_IF_RANGE_SCENARIO_FIELD));

    private static final long serialVersionUID = 1L;

    private final WhatIfPointScenario whatIfPointScenario;

    private final WhatIfRangeScenario whatIfRangeScenario;

    private ForecastScenario(BuilderImpl builder) {
        this.whatIfPointScenario = builder.whatIfPointScenario;
        this.whatIfRangeScenario = builder.whatIfRangeScenario;
    }

    /**
     * <p>
     * The what-if analysis forecast setup with the target date.
     * </p>
     * 
     * @return The what-if analysis forecast setup with the target date.
     */
    public final WhatIfPointScenario whatIfPointScenario() {
        return whatIfPointScenario;
    }

    /**
     * <p>
     * The what-if analysis forecast setup with the date range.
     * </p>
     * 
     * @return The what-if analysis forecast setup with the date range.
     */
    public final WhatIfRangeScenario whatIfRangeScenario() {
        return whatIfRangeScenario;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(whatIfPointScenario());
        hashCode = 31 * hashCode + Objects.hashCode(whatIfRangeScenario());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastScenario)) {
            return false;
        }
        ForecastScenario other = (ForecastScenario) obj;
        return Objects.equals(whatIfPointScenario(), other.whatIfPointScenario())
                && Objects.equals(whatIfRangeScenario(), other.whatIfRangeScenario());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ForecastScenario").add("WhatIfPointScenario", whatIfPointScenario())
                .add("WhatIfRangeScenario", whatIfRangeScenario()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WhatIfPointScenario":
            return Optional.ofNullable(clazz.cast(whatIfPointScenario()));
        case "WhatIfRangeScenario":
            return Optional.ofNullable(clazz.cast(whatIfRangeScenario()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForecastScenario, T> g) {
        return obj -> g.apply((ForecastScenario) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ForecastScenario> {
        /**
         * <p>
         * The what-if analysis forecast setup with the target date.
         * </p>
         * 
         * @param whatIfPointScenario
         *        The what-if analysis forecast setup with the target date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfPointScenario(WhatIfPointScenario whatIfPointScenario);

        /**
         * <p>
         * The what-if analysis forecast setup with the target date.
         * </p>
         * This is a convenience method that creates an instance of the {@link WhatIfPointScenario.Builder} avoiding the
         * need to create one manually via {@link WhatIfPointScenario#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WhatIfPointScenario.Builder#build()} is called immediately and
         * its result is passed to {@link #whatIfPointScenario(WhatIfPointScenario)}.
         * 
         * @param whatIfPointScenario
         *        a consumer that will call methods on {@link WhatIfPointScenario.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #whatIfPointScenario(WhatIfPointScenario)
         */
        default Builder whatIfPointScenario(Consumer<WhatIfPointScenario.Builder> whatIfPointScenario) {
            return whatIfPointScenario(WhatIfPointScenario.builder().applyMutation(whatIfPointScenario).build());
        }

        /**
         * <p>
         * The what-if analysis forecast setup with the date range.
         * </p>
         * 
         * @param whatIfRangeScenario
         *        The what-if analysis forecast setup with the date range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfRangeScenario(WhatIfRangeScenario whatIfRangeScenario);

        /**
         * <p>
         * The what-if analysis forecast setup with the date range.
         * </p>
         * This is a convenience method that creates an instance of the {@link WhatIfRangeScenario.Builder} avoiding the
         * need to create one manually via {@link WhatIfRangeScenario#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WhatIfRangeScenario.Builder#build()} is called immediately and
         * its result is passed to {@link #whatIfRangeScenario(WhatIfRangeScenario)}.
         * 
         * @param whatIfRangeScenario
         *        a consumer that will call methods on {@link WhatIfRangeScenario.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #whatIfRangeScenario(WhatIfRangeScenario)
         */
        default Builder whatIfRangeScenario(Consumer<WhatIfRangeScenario.Builder> whatIfRangeScenario) {
            return whatIfRangeScenario(WhatIfRangeScenario.builder().applyMutation(whatIfRangeScenario).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WhatIfPointScenario whatIfPointScenario;

        private WhatIfRangeScenario whatIfRangeScenario;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastScenario model) {
            whatIfPointScenario(model.whatIfPointScenario);
            whatIfRangeScenario(model.whatIfRangeScenario);
        }

        public final WhatIfPointScenario.Builder getWhatIfPointScenario() {
            return whatIfPointScenario != null ? whatIfPointScenario.toBuilder() : null;
        }

        public final void setWhatIfPointScenario(WhatIfPointScenario.BuilderImpl whatIfPointScenario) {
            this.whatIfPointScenario = whatIfPointScenario != null ? whatIfPointScenario.build() : null;
        }

        @Override
        public final Builder whatIfPointScenario(WhatIfPointScenario whatIfPointScenario) {
            this.whatIfPointScenario = whatIfPointScenario;
            return this;
        }

        public final WhatIfRangeScenario.Builder getWhatIfRangeScenario() {
            return whatIfRangeScenario != null ? whatIfRangeScenario.toBuilder() : null;
        }

        public final void setWhatIfRangeScenario(WhatIfRangeScenario.BuilderImpl whatIfRangeScenario) {
            this.whatIfRangeScenario = whatIfRangeScenario != null ? whatIfRangeScenario.build() : null;
        }

        @Override
        public final Builder whatIfRangeScenario(WhatIfRangeScenario whatIfRangeScenario) {
            this.whatIfRangeScenario = whatIfRangeScenario;
            return this;
        }

        @Override
        public ForecastScenario build() {
            return new ForecastScenario(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
