/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDashboardSnapshotJobResultResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeDashboardSnapshotJobResultResponse.Builder, DescribeDashboardSnapshotJobResultResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeDashboardSnapshotJobResultResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(DescribeDashboardSnapshotJobResultResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DescribeDashboardSnapshotJobResultResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(DescribeDashboardSnapshotJobResultResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<SnapshotJobResult> RESULT_FIELD = SdkField
            .<SnapshotJobResult> builder(MarshallingType.SDK_POJO).memberName("Result")
            .getter(getter(DescribeDashboardSnapshotJobResultResponse::result)).setter(setter(Builder::result))
            .constructor(SnapshotJobResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()).build();

    private static final SdkField<SnapshotJobErrorInfo> ERROR_INFO_FIELD = SdkField
            .<SnapshotJobErrorInfo> builder(MarshallingType.SDK_POJO).memberName("ErrorInfo")
            .getter(getter(DescribeDashboardSnapshotJobResultResponse::errorInfo)).setter(setter(Builder::errorInfo))
            .constructor(SnapshotJobErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorInfo").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeDashboardSnapshotJobResultResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeDashboardSnapshotJobResultResponse::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, JOB_STATUS_FIELD,
            CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, RESULT_FIELD, ERROR_INFO_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private final String arn;

    private final String jobStatus;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final SnapshotJobResult result;

    private final SnapshotJobErrorInfo errorInfo;

    private final String requestId;

    private final Integer status;

    private DescribeDashboardSnapshotJobResultResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.jobStatus = builder.jobStatus;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.result = builder.result;
        this.errorInfo = builder.errorInfo;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the snapshot job. The job ARN is generated when you start a new job with a
     * <code>StartDashboardSnapshotJob</code> API call.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the snapshot job. The job ARN is generated when you start a new job
     *         with a <code>StartDashboardSnapshotJob</code> API call.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Indicates the status of a job after it has reached a terminal state. A finished snapshot job will retuen a
     * <code>COMPLETED</code> or <code>FAILED</code> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link SnapshotJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of a job after it has reached a terminal state. A finished snapshot job will retuen
     *         a <code>COMPLETED</code> or <code>FAILED</code> status.
     * @see SnapshotJobStatus
     */
    public final SnapshotJobStatus jobStatus() {
        return SnapshotJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * Indicates the status of a job after it has reached a terminal state. A finished snapshot job will retuen a
     * <code>COMPLETED</code> or <code>FAILED</code> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link SnapshotJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of a job after it has reached a terminal state. A finished snapshot job will retuen
     *         a <code>COMPLETED</code> or <code>FAILED</code> status.
     * @see SnapshotJobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The time that a snapshot job was created.
     * </p>
     * 
     * @return The time that a snapshot job was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The time that a snapshot job status was last updated.
     * </p>
     * 
     * @return The time that a snapshot job status was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The result of the snapshot job. Jobs that have successfully completed will return the S3Uri where they are
     * located. Jobs that have failedwill return information on the error that caused the job to fail.
     * </p>
     * 
     * @return The result of the snapshot job. Jobs that have successfully completed will return the S3Uri where they
     *         are located. Jobs that have failedwill return information on the error that caused the job to fail.
     */
    public final SnapshotJobResult result() {
        return result;
    }

    /**
     * <p>
     * Displays information for the error that caused a job to fail.
     * </p>
     * 
     * @return Displays information for the error that caused a job to fail.
     */
    public final SnapshotJobErrorInfo errorInfo() {
        return errorInfo;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request
     * </p>
     * 
     * @return The HTTP status of the request
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDashboardSnapshotJobResultResponse)) {
            return false;
        }
        DescribeDashboardSnapshotJobResultResponse other = (DescribeDashboardSnapshotJobResultResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(result(), other.result())
                && Objects.equals(errorInfo(), other.errorInfo()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDashboardSnapshotJobResultResponse").add("Arn", arn())
                .add("JobStatus", jobStatusAsString()).add("CreatedTime", createdTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("Result", result()).add("ErrorInfo", errorInfo())
                .add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        case "ErrorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDashboardSnapshotJobResultResponse, T> g) {
        return obj -> g.apply((DescribeDashboardSnapshotJobResultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDashboardSnapshotJobResultResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the snapshot job. The job ARN is generated when you start a new job with a
         * <code>StartDashboardSnapshotJob</code> API call.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the snapshot job. The job ARN is generated when you start a new job
         *        with a <code>StartDashboardSnapshotJob</code> API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Indicates the status of a job after it has reached a terminal state. A finished snapshot job will retuen a
         * <code>COMPLETED</code> or <code>FAILED</code> status.
         * </p>
         * 
         * @param jobStatus
         *        Indicates the status of a job after it has reached a terminal state. A finished snapshot job will
         *        retuen a <code>COMPLETED</code> or <code>FAILED</code> status.
         * @see SnapshotJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * Indicates the status of a job after it has reached a terminal state. A finished snapshot job will retuen a
         * <code>COMPLETED</code> or <code>FAILED</code> status.
         * </p>
         * 
         * @param jobStatus
         *        Indicates the status of a job after it has reached a terminal state. A finished snapshot job will
         *        retuen a <code>COMPLETED</code> or <code>FAILED</code> status.
         * @see SnapshotJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotJobStatus
         */
        Builder jobStatus(SnapshotJobStatus jobStatus);

        /**
         * <p>
         * The time that a snapshot job was created.
         * </p>
         * 
         * @param createdTime
         *        The time that a snapshot job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The time that a snapshot job status was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time that a snapshot job status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The result of the snapshot job. Jobs that have successfully completed will return the S3Uri where they are
         * located. Jobs that have failedwill return information on the error that caused the job to fail.
         * </p>
         * 
         * @param result
         *        The result of the snapshot job. Jobs that have successfully completed will return the S3Uri where they
         *        are located. Jobs that have failedwill return information on the error that caused the job to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(SnapshotJobResult result);

        /**
         * <p>
         * The result of the snapshot job. Jobs that have successfully completed will return the S3Uri where they are
         * located. Jobs that have failedwill return information on the error that caused the job to fail.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnapshotJobResult.Builder} avoiding the
         * need to create one manually via {@link SnapshotJobResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotJobResult.Builder#build()} is called immediately and its
         * result is passed to {@link #result(SnapshotJobResult)}.
         * 
         * @param result
         *        a consumer that will call methods on {@link SnapshotJobResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #result(SnapshotJobResult)
         */
        default Builder result(Consumer<SnapshotJobResult.Builder> result) {
            return result(SnapshotJobResult.builder().applyMutation(result).build());
        }

        /**
         * <p>
         * Displays information for the error that caused a job to fail.
         * </p>
         * 
         * @param errorInfo
         *        Displays information for the error that caused a job to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(SnapshotJobErrorInfo errorInfo);

        /**
         * <p>
         * Displays information for the error that caused a job to fail.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnapshotJobErrorInfo.Builder} avoiding
         * the need to create one manually via {@link SnapshotJobErrorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotJobErrorInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #errorInfo(SnapshotJobErrorInfo)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on {@link SnapshotJobErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(SnapshotJobErrorInfo)
         */
        default Builder errorInfo(Consumer<SnapshotJobErrorInfo.Builder> errorInfo) {
            return errorInfo(SnapshotJobErrorInfo.builder().applyMutation(errorInfo).build());
        }

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request
         * </p>
         * 
         * @param status
         *        The HTTP status of the request
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String arn;

        private String jobStatus;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private SnapshotJobResult result;

        private SnapshotJobErrorInfo errorInfo;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDashboardSnapshotJobResultResponse model) {
            super(model);
            arn(model.arn);
            jobStatus(model.jobStatus);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            result(model.result);
            errorInfo(model.errorInfo);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(SnapshotJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final SnapshotJobResult.Builder getResult() {
            return result != null ? result.toBuilder() : null;
        }

        public final void setResult(SnapshotJobResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public final Builder result(SnapshotJobResult result) {
            this.result = result;
            return this;
        }

        public final SnapshotJobErrorInfo.Builder getErrorInfo() {
            return errorInfo != null ? errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(SnapshotJobErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(SnapshotJobErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeDashboardSnapshotJobResultResponse build() {
            return new DescribeDashboardSnapshotJobResultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
