/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteIdentityPropagationConfigRequest extends QuickSightRequest implements
        ToCopyableBuilder<DeleteIdentityPropagationConfigRequest.Builder, DeleteIdentityPropagationConfigRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(DeleteIdentityPropagationConfigRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Service")
            .getter(getter(DeleteIdentityPropagationConfigRequest::serviceAsString)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Service").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            SERVICE_FIELD));

    private final String awsAccountId;

    private final String service;

    private DeleteIdentityPropagationConfigRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.service = builder.service;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that you want to delete an identity propagation configuration from.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that you want to delete an identity propagation configuration
     *         from.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The name of the Amazon Web Services service that you want to delete the associated access scopes and authorized
     * targets from.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #service} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceAsString}.
     * </p>
     * 
     * @return The name of the Amazon Web Services service that you want to delete the associated access scopes and
     *         authorized targets from.
     * @see ServiceType
     */
    public final ServiceType service() {
        return ServiceType.fromValue(service);
    }

    /**
     * <p>
     * The name of the Amazon Web Services service that you want to delete the associated access scopes and authorized
     * targets from.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #service} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceAsString}.
     * </p>
     * 
     * @return The name of the Amazon Web Services service that you want to delete the associated access scopes and
     *         authorized targets from.
     * @see ServiceType
     */
    public final String serviceAsString() {
        return service;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentityPropagationConfigRequest)) {
            return false;
        }
        DeleteIdentityPropagationConfigRequest other = (DeleteIdentityPropagationConfigRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(serviceAsString(), other.serviceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteIdentityPropagationConfigRequest").add("AwsAccountId", awsAccountId())
                .add("Service", serviceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Service":
            return Optional.ofNullable(clazz.cast(serviceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteIdentityPropagationConfigRequest, T> g) {
        return obj -> g.apply((DeleteIdentityPropagationConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteIdentityPropagationConfigRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that you want to delete an identity propagation configuration from.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that you want to delete an identity propagation
         *        configuration from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The name of the Amazon Web Services service that you want to delete the associated access scopes and
         * authorized targets from.
         * </p>
         * 
         * @param service
         *        The name of the Amazon Web Services service that you want to delete the associated access scopes and
         *        authorized targets from.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder service(String service);

        /**
         * <p>
         * The name of the Amazon Web Services service that you want to delete the associated access scopes and
         * authorized targets from.
         * </p>
         * 
         * @param service
         *        The name of the Amazon Web Services service that you want to delete the associated access scopes and
         *        authorized targets from.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder service(ServiceType service);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String service;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentityPropagationConfigRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            service(model.service);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        @Override
        public final Builder service(ServiceType service) {
            this.service(service == null ? null : service.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteIdentityPropagationConfigRequest build() {
            return new DeleteIdentityPropagationConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
