/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default options that correspond to the <code>RelativeDateTime</code> filter control type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultRelativeDateTimeControlOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultRelativeDateTimeControlOptions.Builder, DefaultRelativeDateTimeControlOptions> {
    private static final SdkField<RelativeDateTimeControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField
            .<RelativeDateTimeControlDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayOptions")
            .getter(getter(DefaultRelativeDateTimeControlOptions::displayOptions)).setter(setter(Builder::displayOptions))
            .constructor(RelativeDateTimeControlDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final RelativeDateTimeControlDisplayOptions displayOptions;

    private DefaultRelativeDateTimeControlOptions(BuilderImpl builder) {
        this.displayOptions = builder.displayOptions;
    }

    /**
     * <p>
     * The display options of a control.
     * </p>
     * 
     * @return The display options of a control.
     */
    public final RelativeDateTimeControlDisplayOptions displayOptions() {
        return displayOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultRelativeDateTimeControlOptions)) {
            return false;
        }
        DefaultRelativeDateTimeControlOptions other = (DefaultRelativeDateTimeControlOptions) obj;
        return Objects.equals(displayOptions(), other.displayOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultRelativeDateTimeControlOptions").add("DisplayOptions", displayOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisplayOptions":
            return Optional.ofNullable(clazz.cast(displayOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultRelativeDateTimeControlOptions, T> g) {
        return obj -> g.apply((DefaultRelativeDateTimeControlOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultRelativeDateTimeControlOptions> {
        /**
         * <p>
         * The display options of a control.
         * </p>
         * 
         * @param displayOptions
         *        The display options of a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOptions(RelativeDateTimeControlDisplayOptions displayOptions);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RelativeDateTimeControlDisplayOptions.Builder} avoiding the need to create one manually via
         * {@link RelativeDateTimeControlDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelativeDateTimeControlDisplayOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #displayOptions(RelativeDateTimeControlDisplayOptions)}.
         * 
         * @param displayOptions
         *        a consumer that will call methods on {@link RelativeDateTimeControlDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayOptions(RelativeDateTimeControlDisplayOptions)
         */
        default Builder displayOptions(Consumer<RelativeDateTimeControlDisplayOptions.Builder> displayOptions) {
            return displayOptions(RelativeDateTimeControlDisplayOptions.builder().applyMutation(displayOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RelativeDateTimeControlDisplayOptions displayOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultRelativeDateTimeControlOptions model) {
            displayOptions(model.displayOptions);
        }

        public final RelativeDateTimeControlDisplayOptions.Builder getDisplayOptions() {
            return displayOptions != null ? displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(RelativeDateTimeControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(RelativeDateTimeControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        @Override
        public DefaultRelativeDateTimeControlOptions build() {
            return new DefaultRelativeDateTimeControlOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
