/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The option that determines the hierarchy of any <code>DateTime</code> fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateTimeHierarchy implements SdkPojo, Serializable,
        ToCopyableBuilder<DateTimeHierarchy.Builder, DateTimeHierarchy> {
    private static final SdkField<String> HIERARCHY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HierarchyId").getter(getter(DateTimeHierarchy::hierarchyId)).setter(setter(Builder::hierarchyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyId").build()).build();

    private static final SdkField<List<DrillDownFilter>> DRILL_DOWN_FILTERS_FIELD = SdkField
            .<List<DrillDownFilter>> builder(MarshallingType.LIST)
            .memberName("DrillDownFilters")
            .getter(getter(DateTimeHierarchy::drillDownFilters))
            .setter(setter(Builder::drillDownFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DrillDownFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DrillDownFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DrillDownFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIERARCHY_ID_FIELD,
            DRILL_DOWN_FILTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hierarchyId;

    private final List<DrillDownFilter> drillDownFilters;

    private DateTimeHierarchy(BuilderImpl builder) {
        this.hierarchyId = builder.hierarchyId;
        this.drillDownFilters = builder.drillDownFilters;
    }

    /**
     * <p>
     * The hierarchy ID of the <code>DateTime</code> hierarchy.
     * </p>
     * 
     * @return The hierarchy ID of the <code>DateTime</code> hierarchy.
     */
    public final String hierarchyId() {
        return hierarchyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the DrillDownFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDrillDownFilters() {
        return drillDownFilters != null && !(drillDownFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The option that determines the drill down filters for the <code>DateTime</code> hierarchy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDrillDownFilters} method.
     * </p>
     * 
     * @return The option that determines the drill down filters for the <code>DateTime</code> hierarchy.
     */
    public final List<DrillDownFilter> drillDownFilters() {
        return drillDownFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDrillDownFilters() ? drillDownFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeHierarchy)) {
            return false;
        }
        DateTimeHierarchy other = (DateTimeHierarchy) obj;
        return Objects.equals(hierarchyId(), other.hierarchyId()) && hasDrillDownFilters() == other.hasDrillDownFilters()
                && Objects.equals(drillDownFilters(), other.drillDownFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateTimeHierarchy").add("HierarchyId", hierarchyId())
                .add("DrillDownFilters", hasDrillDownFilters() ? drillDownFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HierarchyId":
            return Optional.ofNullable(clazz.cast(hierarchyId()));
        case "DrillDownFilters":
            return Optional.ofNullable(clazz.cast(drillDownFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateTimeHierarchy, T> g) {
        return obj -> g.apply((DateTimeHierarchy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateTimeHierarchy> {
        /**
         * <p>
         * The hierarchy ID of the <code>DateTime</code> hierarchy.
         * </p>
         * 
         * @param hierarchyId
         *        The hierarchy ID of the <code>DateTime</code> hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyId(String hierarchyId);

        /**
         * <p>
         * The option that determines the drill down filters for the <code>DateTime</code> hierarchy.
         * </p>
         * 
         * @param drillDownFilters
         *        The option that determines the drill down filters for the <code>DateTime</code> hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder drillDownFilters(Collection<DrillDownFilter> drillDownFilters);

        /**
         * <p>
         * The option that determines the drill down filters for the <code>DateTime</code> hierarchy.
         * </p>
         * 
         * @param drillDownFilters
         *        The option that determines the drill down filters for the <code>DateTime</code> hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder drillDownFilters(DrillDownFilter... drillDownFilters);

        /**
         * <p>
         * The option that determines the drill down filters for the <code>DateTime</code> hierarchy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DrillDownFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DrillDownFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DrillDownFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #drillDownFilters(List<DrillDownFilter>)}.
         * 
         * @param drillDownFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DrillDownFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #drillDownFilters(java.util.Collection<DrillDownFilter>)
         */
        Builder drillDownFilters(Consumer<DrillDownFilter.Builder>... drillDownFilters);
    }

    static final class BuilderImpl implements Builder {
        private String hierarchyId;

        private List<DrillDownFilter> drillDownFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimeHierarchy model) {
            hierarchyId(model.hierarchyId);
            drillDownFilters(model.drillDownFilters);
        }

        public final String getHierarchyId() {
            return hierarchyId;
        }

        public final void setHierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
        }

        @Override
        public final Builder hierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
            return this;
        }

        public final List<DrillDownFilter.Builder> getDrillDownFilters() {
            List<DrillDownFilter.Builder> result = DrillDownFilterListCopier.copyToBuilder(this.drillDownFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDrillDownFilters(Collection<DrillDownFilter.BuilderImpl> drillDownFilters) {
            this.drillDownFilters = DrillDownFilterListCopier.copyFromBuilder(drillDownFilters);
        }

        @Override
        public final Builder drillDownFilters(Collection<DrillDownFilter> drillDownFilters) {
            this.drillDownFilters = DrillDownFilterListCopier.copy(drillDownFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder drillDownFilters(DrillDownFilter... drillDownFilters) {
            drillDownFilters(Arrays.asList(drillDownFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder drillDownFilters(Consumer<DrillDownFilter.Builder>... drillDownFilters) {
            drillDownFilters(Stream.of(drillDownFilters).map(c -> DrillDownFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DateTimeHierarchy build() {
            return new DateTimeHierarchy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
