/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines the custom condition for an icon set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionalFormattingCustomIconCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionalFormattingCustomIconCondition.Builder, ConditionalFormattingCustomIconCondition> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(ConditionalFormattingCustomIconCondition::expression))
            .setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<ConditionalFormattingCustomIconOptions> ICON_OPTIONS_FIELD = SdkField
            .<ConditionalFormattingCustomIconOptions> builder(MarshallingType.SDK_POJO).memberName("IconOptions")
            .getter(getter(ConditionalFormattingCustomIconCondition::iconOptions)).setter(setter(Builder::iconOptions))
            .constructor(ConditionalFormattingCustomIconOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconOptions").build()).build();

    private static final SdkField<String> COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Color")
            .getter(getter(ConditionalFormattingCustomIconCondition::color)).setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()).build();

    private static final SdkField<ConditionalFormattingIconDisplayConfiguration> DISPLAY_CONFIGURATION_FIELD = SdkField
            .<ConditionalFormattingIconDisplayConfiguration> builder(MarshallingType.SDK_POJO).memberName("DisplayConfiguration")
            .getter(getter(ConditionalFormattingCustomIconCondition::displayConfiguration))
            .setter(setter(Builder::displayConfiguration)).constructor(ConditionalFormattingIconDisplayConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD,
            ICON_OPTIONS_FIELD, COLOR_FIELD, DISPLAY_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String expression;

    private final ConditionalFormattingCustomIconOptions iconOptions;

    private final String color;

    private final ConditionalFormattingIconDisplayConfiguration displayConfiguration;

    private ConditionalFormattingCustomIconCondition(BuilderImpl builder) {
        this.expression = builder.expression;
        this.iconOptions = builder.iconOptions;
        this.color = builder.color;
        this.displayConfiguration = builder.displayConfiguration;
    }

    /**
     * <p>
     * The expression that determines the condition of the icon set.
     * </p>
     * 
     * @return The expression that determines the condition of the icon set.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * Custom icon options for an icon set.
     * </p>
     * 
     * @return Custom icon options for an icon set.
     */
    public final ConditionalFormattingCustomIconOptions iconOptions() {
        return iconOptions;
    }

    /**
     * <p>
     * Determines the color of the icon.
     * </p>
     * 
     * @return Determines the color of the icon.
     */
    public final String color() {
        return color;
    }

    /**
     * <p>
     * Determines the icon display configuration.
     * </p>
     * 
     * @return Determines the icon display configuration.
     */
    public final ConditionalFormattingIconDisplayConfiguration displayConfiguration() {
        return displayConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(iconOptions());
        hashCode = 31 * hashCode + Objects.hashCode(color());
        hashCode = 31 * hashCode + Objects.hashCode(displayConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalFormattingCustomIconCondition)) {
            return false;
        }
        ConditionalFormattingCustomIconCondition other = (ConditionalFormattingCustomIconCondition) obj;
        return Objects.equals(expression(), other.expression()) && Objects.equals(iconOptions(), other.iconOptions())
                && Objects.equals(color(), other.color()) && Objects.equals(displayConfiguration(), other.displayConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionalFormattingCustomIconCondition")
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IconOptions", iconOptions()).add("Color", color()).add("DisplayConfiguration", displayConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "IconOptions":
            return Optional.ofNullable(clazz.cast(iconOptions()));
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        case "DisplayConfiguration":
            return Optional.ofNullable(clazz.cast(displayConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConditionalFormattingCustomIconCondition, T> g) {
        return obj -> g.apply((ConditionalFormattingCustomIconCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionalFormattingCustomIconCondition> {
        /**
         * <p>
         * The expression that determines the condition of the icon set.
         * </p>
         * 
         * @param expression
         *        The expression that determines the condition of the icon set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * Custom icon options for an icon set.
         * </p>
         * 
         * @param iconOptions
         *        Custom icon options for an icon set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iconOptions(ConditionalFormattingCustomIconOptions iconOptions);

        /**
         * <p>
         * Custom icon options for an icon set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConditionalFormattingCustomIconOptions.Builder} avoiding the need to create one manually via
         * {@link ConditionalFormattingCustomIconOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalFormattingCustomIconOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #iconOptions(ConditionalFormattingCustomIconOptions)}.
         * 
         * @param iconOptions
         *        a consumer that will call methods on {@link ConditionalFormattingCustomIconOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iconOptions(ConditionalFormattingCustomIconOptions)
         */
        default Builder iconOptions(Consumer<ConditionalFormattingCustomIconOptions.Builder> iconOptions) {
            return iconOptions(ConditionalFormattingCustomIconOptions.builder().applyMutation(iconOptions).build());
        }

        /**
         * <p>
         * Determines the color of the icon.
         * </p>
         * 
         * @param color
         *        Determines the color of the icon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(String color);

        /**
         * <p>
         * Determines the icon display configuration.
         * </p>
         * 
         * @param displayConfiguration
         *        Determines the icon display configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayConfiguration(ConditionalFormattingIconDisplayConfiguration displayConfiguration);

        /**
         * <p>
         * Determines the icon display configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConditionalFormattingIconDisplayConfiguration.Builder} avoiding the need to create one manually via
         * {@link ConditionalFormattingIconDisplayConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalFormattingIconDisplayConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #displayConfiguration(ConditionalFormattingIconDisplayConfiguration)}.
         * 
         * @param displayConfiguration
         *        a consumer that will call methods on {@link ConditionalFormattingIconDisplayConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayConfiguration(ConditionalFormattingIconDisplayConfiguration)
         */
        default Builder displayConfiguration(Consumer<ConditionalFormattingIconDisplayConfiguration.Builder> displayConfiguration) {
            return displayConfiguration(ConditionalFormattingIconDisplayConfiguration.builder()
                    .applyMutation(displayConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String expression;

        private ConditionalFormattingCustomIconOptions iconOptions;

        private String color;

        private ConditionalFormattingIconDisplayConfiguration displayConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalFormattingCustomIconCondition model) {
            expression(model.expression);
            iconOptions(model.iconOptions);
            color(model.color);
            displayConfiguration(model.displayConfiguration);
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final ConditionalFormattingCustomIconOptions.Builder getIconOptions() {
            return iconOptions != null ? iconOptions.toBuilder() : null;
        }

        public final void setIconOptions(ConditionalFormattingCustomIconOptions.BuilderImpl iconOptions) {
            this.iconOptions = iconOptions != null ? iconOptions.build() : null;
        }

        @Override
        public final Builder iconOptions(ConditionalFormattingCustomIconOptions iconOptions) {
            this.iconOptions = iconOptions;
            return this;
        }

        public final String getColor() {
            return color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final ConditionalFormattingIconDisplayConfiguration.Builder getDisplayConfiguration() {
            return displayConfiguration != null ? displayConfiguration.toBuilder() : null;
        }

        public final void setDisplayConfiguration(ConditionalFormattingIconDisplayConfiguration.BuilderImpl displayConfiguration) {
            this.displayConfiguration = displayConfiguration != null ? displayConfiguration.build() : null;
        }

        @Override
        public final Builder displayConfiguration(ConditionalFormattingIconDisplayConfiguration displayConfiguration) {
            this.displayConfiguration = displayConfiguration;
            return this;
        }

        @Override
        public ConditionalFormattingCustomIconCondition build() {
            return new ConditionalFormattingCustomIconCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
