/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The cluster marker that is a part of the cluster marker configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterMarker implements SdkPojo, Serializable, ToCopyableBuilder<ClusterMarker.Builder, ClusterMarker> {
    private static final SdkField<SimpleClusterMarker> SIMPLE_CLUSTER_MARKER_FIELD = SdkField
            .<SimpleClusterMarker> builder(MarshallingType.SDK_POJO).memberName("SimpleClusterMarker")
            .getter(getter(ClusterMarker::simpleClusterMarker)).setter(setter(Builder::simpleClusterMarker))
            .constructor(SimpleClusterMarker::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimpleClusterMarker").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIMPLE_CLUSTER_MARKER_FIELD));

    private static final long serialVersionUID = 1L;

    private final SimpleClusterMarker simpleClusterMarker;

    private ClusterMarker(BuilderImpl builder) {
        this.simpleClusterMarker = builder.simpleClusterMarker;
    }

    /**
     * <p>
     * The simple cluster marker of the cluster marker.
     * </p>
     * 
     * @return The simple cluster marker of the cluster marker.
     */
    public final SimpleClusterMarker simpleClusterMarker() {
        return simpleClusterMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(simpleClusterMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterMarker)) {
            return false;
        }
        ClusterMarker other = (ClusterMarker) obj;
        return Objects.equals(simpleClusterMarker(), other.simpleClusterMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterMarker").add("SimpleClusterMarker", simpleClusterMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SimpleClusterMarker":
            return Optional.ofNullable(clazz.cast(simpleClusterMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterMarker, T> g) {
        return obj -> g.apply((ClusterMarker) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterMarker> {
        /**
         * <p>
         * The simple cluster marker of the cluster marker.
         * </p>
         * 
         * @param simpleClusterMarker
         *        The simple cluster marker of the cluster marker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simpleClusterMarker(SimpleClusterMarker simpleClusterMarker);

        /**
         * <p>
         * The simple cluster marker of the cluster marker.
         * </p>
         * This is a convenience method that creates an instance of the {@link SimpleClusterMarker.Builder} avoiding the
         * need to create one manually via {@link SimpleClusterMarker#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SimpleClusterMarker.Builder#build()} is called immediately and
         * its result is passed to {@link #simpleClusterMarker(SimpleClusterMarker)}.
         * 
         * @param simpleClusterMarker
         *        a consumer that will call methods on {@link SimpleClusterMarker.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simpleClusterMarker(SimpleClusterMarker)
         */
        default Builder simpleClusterMarker(Consumer<SimpleClusterMarker.Builder> simpleClusterMarker) {
            return simpleClusterMarker(SimpleClusterMarker.builder().applyMutation(simpleClusterMarker).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SimpleClusterMarker simpleClusterMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterMarker model) {
            simpleClusterMarker(model.simpleClusterMarker);
        }

        public final SimpleClusterMarker.Builder getSimpleClusterMarker() {
            return simpleClusterMarker != null ? simpleClusterMarker.toBuilder() : null;
        }

        public final void setSimpleClusterMarker(SimpleClusterMarker.BuilderImpl simpleClusterMarker) {
            this.simpleClusterMarker = simpleClusterMarker != null ? simpleClusterMarker.build() : null;
        }

        @Override
        public final Builder simpleClusterMarker(SimpleClusterMarker simpleClusterMarker) {
            this.simpleClusterMarker = simpleClusterMarker;
            return this;
        }

        @Override
        public ClusterMarker build() {
            return new ClusterMarker(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
