/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The page break configuration to apply for each repeating instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BodySectionRepeatPageBreakConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BodySectionRepeatPageBreakConfiguration.Builder, BodySectionRepeatPageBreakConfiguration> {
    private static final SdkField<SectionAfterPageBreak> AFTER_FIELD = SdkField
            .<SectionAfterPageBreak> builder(MarshallingType.SDK_POJO).memberName("After")
            .getter(getter(BodySectionRepeatPageBreakConfiguration::after)).setter(setter(Builder::after))
            .constructor(SectionAfterPageBreak::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("After").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final SectionAfterPageBreak after;

    private BodySectionRepeatPageBreakConfiguration(BuilderImpl builder) {
        this.after = builder.after;
    }

    /**
     * Returns the value of the After property for this object.
     * 
     * @return The value of the After property for this object.
     */
    public final SectionAfterPageBreak after() {
        return after;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(after());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BodySectionRepeatPageBreakConfiguration)) {
            return false;
        }
        BodySectionRepeatPageBreakConfiguration other = (BodySectionRepeatPageBreakConfiguration) obj;
        return Objects.equals(after(), other.after());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BodySectionRepeatPageBreakConfiguration").add("After", after()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "After":
            return Optional.ofNullable(clazz.cast(after()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BodySectionRepeatPageBreakConfiguration, T> g) {
        return obj -> g.apply((BodySectionRepeatPageBreakConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BodySectionRepeatPageBreakConfiguration> {
        /**
         * Sets the value of the After property for this object.
         *
         * @param after
         *        The new value for the After property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder after(SectionAfterPageBreak after);

        /**
         * Sets the value of the After property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SectionAfterPageBreak.Builder} avoiding
         * the need to create one manually via {@link SectionAfterPageBreak#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SectionAfterPageBreak.Builder#build()} is called immediately and
         * its result is passed to {@link #after(SectionAfterPageBreak)}.
         * 
         * @param after
         *        a consumer that will call methods on {@link SectionAfterPageBreak.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #after(SectionAfterPageBreak)
         */
        default Builder after(Consumer<SectionAfterPageBreak.Builder> after) {
            return after(SectionAfterPageBreak.builder().applyMutation(after).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SectionAfterPageBreak after;

        private BuilderImpl() {
        }

        private BuilderImpl(BodySectionRepeatPageBreakConfiguration model) {
            after(model.after);
        }

        public final SectionAfterPageBreak.Builder getAfter() {
            return after != null ? after.toBuilder() : null;
        }

        public final void setAfter(SectionAfterPageBreak.BuilderImpl after) {
            this.after = after != null ? after.build() : null;
        }

        @Override
        public final Builder after(SectionAfterPageBreak after) {
            this.after = after;
            return this;
        }

        @Override
        public BodySectionRepeatPageBreakConfiguration build() {
            return new BodySectionRepeatPageBreakConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
