/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The liner axis scale setup.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AxisLinearScale implements SdkPojo, Serializable, ToCopyableBuilder<AxisLinearScale.Builder, AxisLinearScale> {
    private static final SdkField<Integer> STEP_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StepCount").getter(getter(AxisLinearScale::stepCount)).setter(setter(Builder::stepCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepCount").build()).build();

    private static final SdkField<Double> STEP_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("StepSize").getter(getter(AxisLinearScale::stepSize)).setter(setter(Builder::stepSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_COUNT_FIELD,
            STEP_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer stepCount;

    private final Double stepSize;

    private AxisLinearScale(BuilderImpl builder) {
        this.stepCount = builder.stepCount;
        this.stepSize = builder.stepSize;
    }

    /**
     * <p>
     * The step count setup of a linear axis.
     * </p>
     * 
     * @return The step count setup of a linear axis.
     */
    public final Integer stepCount() {
        return stepCount;
    }

    /**
     * <p>
     * The step size setup of a linear axis.
     * </p>
     * 
     * @return The step size setup of a linear axis.
     */
    public final Double stepSize() {
        return stepSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepCount());
        hashCode = 31 * hashCode + Objects.hashCode(stepSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AxisLinearScale)) {
            return false;
        }
        AxisLinearScale other = (AxisLinearScale) obj;
        return Objects.equals(stepCount(), other.stepCount()) && Objects.equals(stepSize(), other.stepSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AxisLinearScale").add("StepCount", stepCount()).add("StepSize", stepSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StepCount":
            return Optional.ofNullable(clazz.cast(stepCount()));
        case "StepSize":
            return Optional.ofNullable(clazz.cast(stepSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AxisLinearScale, T> g) {
        return obj -> g.apply((AxisLinearScale) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AxisLinearScale> {
        /**
         * <p>
         * The step count setup of a linear axis.
         * </p>
         * 
         * @param stepCount
         *        The step count setup of a linear axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepCount(Integer stepCount);

        /**
         * <p>
         * The step size setup of a linear axis.
         * </p>
         * 
         * @param stepSize
         *        The step size setup of a linear axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepSize(Double stepSize);
    }

    static final class BuilderImpl implements Builder {
        private Integer stepCount;

        private Double stepSize;

        private BuilderImpl() {
        }

        private BuilderImpl(AxisLinearScale model) {
            stepCount(model.stepCount);
            stepSize(model.stepSize);
        }

        public final Integer getStepCount() {
            return stepCount;
        }

        public final void setStepCount(Integer stepCount) {
            this.stepCount = stepCount;
        }

        @Override
        public final Builder stepCount(Integer stepCount) {
            this.stepCount = stepCount;
            return this;
        }

        public final Double getStepSize() {
            return stepSize;
        }

        public final void setStepSize(Double stepSize) {
            this.stepSize = stepSize;
        }

        @Override
        public final Builder stepSize(Double stepSize) {
            this.stepSize = stepSize;
            return this;
        }

        @Override
        public AxisLinearScale build() {
            return new AxisLinearScale(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
