/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the contents of an email message, composed of a subject, a text part, and an HTML part.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimpleEmail implements SdkPojo, Serializable, ToCopyableBuilder<SimpleEmail.Builder, SimpleEmail> {
    private static final SdkField<SimpleEmailPart> HTML_PART_FIELD = SdkField.<SimpleEmailPart> builder(MarshallingType.SDK_POJO)
            .memberName("HtmlPart").getter(getter(SimpleEmail::htmlPart)).setter(setter(Builder::htmlPart))
            .constructor(SimpleEmailPart::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HtmlPart").build()).build();

    private static final SdkField<SimpleEmailPart> SUBJECT_FIELD = SdkField.<SimpleEmailPart> builder(MarshallingType.SDK_POJO)
            .memberName("Subject").getter(getter(SimpleEmail::subject)).setter(setter(Builder::subject))
            .constructor(SimpleEmailPart::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<SimpleEmailPart> TEXT_PART_FIELD = SdkField.<SimpleEmailPart> builder(MarshallingType.SDK_POJO)
            .memberName("TextPart").getter(getter(SimpleEmail::textPart)).setter(setter(Builder::textPart))
            .constructor(SimpleEmailPart::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextPart").build()).build();

    private static final SdkField<List<MessageHeader>> HEADERS_FIELD = SdkField
            .<List<MessageHeader>> builder(MarshallingType.LIST)
            .memberName("Headers")
            .getter(getter(SimpleEmail::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTML_PART_FIELD,
            SUBJECT_FIELD, TEXT_PART_FIELD, HEADERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SimpleEmailPart htmlPart;

    private final SimpleEmailPart subject;

    private final SimpleEmailPart textPart;

    private final List<MessageHeader> headers;

    private SimpleEmail(BuilderImpl builder) {
        this.htmlPart = builder.htmlPart;
        this.subject = builder.subject;
        this.textPart = builder.textPart;
        this.headers = builder.headers;
    }

    /**
     * <p>
     * The body of the email message, in HTML format. We recommend using HTML format for email clients that render HTML
     * content. You can include links, formatted text, and more in an HTML message.
     * </p>
     * 
     * @return The body of the email message, in HTML format. We recommend using HTML format for email clients that
     *         render HTML content. You can include links, formatted text, and more in an HTML message.
     */
    public final SimpleEmailPart htmlPart() {
        return htmlPart;
    }

    /**
     * <p>
     * The subject line, or title, of the email.
     * </p>
     * 
     * @return The subject line, or title, of the email.
     */
    public final SimpleEmailPart subject() {
        return subject;
    }

    /**
     * <p>
     * The body of the email message, in plain text format. We recommend using plain text format for email clients that
     * don't render HTML content and clients that are connected to high-latency networks, such as mobile devices.
     * </p>
     * 
     * @return The body of the email message, in plain text format. We recommend using plain text format for email
     *         clients that don't render HTML content and clients that are connected to high-latency networks, such as
     *         mobile devices.
     */
    public final SimpleEmailPart textPart() {
        return textPart;
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of MessageHeaders for the email. You can have up to 15 Headers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return The list of MessageHeaders for the email. You can have up to 15 Headers.
     */
    public final List<MessageHeader> headers() {
        return headers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(htmlPart());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(textPart());
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleEmail)) {
            return false;
        }
        SimpleEmail other = (SimpleEmail) obj;
        return Objects.equals(htmlPart(), other.htmlPart()) && Objects.equals(subject(), other.subject())
                && Objects.equals(textPart(), other.textPart()) && hasHeaders() == other.hasHeaders()
                && Objects.equals(headers(), other.headers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SimpleEmail").add("HtmlPart", htmlPart()).add("Subject", subject()).add("TextPart", textPart())
                .add("Headers", hasHeaders() ? headers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HtmlPart":
            return Optional.ofNullable(clazz.cast(htmlPart()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "TextPart":
            return Optional.ofNullable(clazz.cast(textPart()));
        case "Headers":
            return Optional.ofNullable(clazz.cast(headers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimpleEmail, T> g) {
        return obj -> g.apply((SimpleEmail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimpleEmail> {
        /**
         * <p>
         * The body of the email message, in HTML format. We recommend using HTML format for email clients that render
         * HTML content. You can include links, formatted text, and more in an HTML message.
         * </p>
         * 
         * @param htmlPart
         *        The body of the email message, in HTML format. We recommend using HTML format for email clients that
         *        render HTML content. You can include links, formatted text, and more in an HTML message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder htmlPart(SimpleEmailPart htmlPart);

        /**
         * <p>
         * The body of the email message, in HTML format. We recommend using HTML format for email clients that render
         * HTML content. You can include links, formatted text, and more in an HTML message.
         * </p>
         * This is a convenience method that creates an instance of the {@link SimpleEmailPart.Builder} avoiding the
         * need to create one manually via {@link SimpleEmailPart#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SimpleEmailPart.Builder#build()} is called immediately and its
         * result is passed to {@link #htmlPart(SimpleEmailPart)}.
         * 
         * @param htmlPart
         *        a consumer that will call methods on {@link SimpleEmailPart.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #htmlPart(SimpleEmailPart)
         */
        default Builder htmlPart(Consumer<SimpleEmailPart.Builder> htmlPart) {
            return htmlPart(SimpleEmailPart.builder().applyMutation(htmlPart).build());
        }

        /**
         * <p>
         * The subject line, or title, of the email.
         * </p>
         * 
         * @param subject
         *        The subject line, or title, of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(SimpleEmailPart subject);

        /**
         * <p>
         * The subject line, or title, of the email.
         * </p>
         * This is a convenience method that creates an instance of the {@link SimpleEmailPart.Builder} avoiding the
         * need to create one manually via {@link SimpleEmailPart#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SimpleEmailPart.Builder#build()} is called immediately and its
         * result is passed to {@link #subject(SimpleEmailPart)}.
         * 
         * @param subject
         *        a consumer that will call methods on {@link SimpleEmailPart.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subject(SimpleEmailPart)
         */
        default Builder subject(Consumer<SimpleEmailPart.Builder> subject) {
            return subject(SimpleEmailPart.builder().applyMutation(subject).build());
        }

        /**
         * <p>
         * The body of the email message, in plain text format. We recommend using plain text format for email clients
         * that don't render HTML content and clients that are connected to high-latency networks, such as mobile
         * devices.
         * </p>
         * 
         * @param textPart
         *        The body of the email message, in plain text format. We recommend using plain text format for email
         *        clients that don't render HTML content and clients that are connected to high-latency networks, such
         *        as mobile devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textPart(SimpleEmailPart textPart);

        /**
         * <p>
         * The body of the email message, in plain text format. We recommend using plain text format for email clients
         * that don't render HTML content and clients that are connected to high-latency networks, such as mobile
         * devices.
         * </p>
         * This is a convenience method that creates an instance of the {@link SimpleEmailPart.Builder} avoiding the
         * need to create one manually via {@link SimpleEmailPart#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SimpleEmailPart.Builder#build()} is called immediately and its
         * result is passed to {@link #textPart(SimpleEmailPart)}.
         * 
         * @param textPart
         *        a consumer that will call methods on {@link SimpleEmailPart.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textPart(SimpleEmailPart)
         */
        default Builder textPart(Consumer<SimpleEmailPart.Builder> textPart) {
            return textPart(SimpleEmailPart.builder().applyMutation(textPart).build());
        }

        /**
         * <p>
         * The list of MessageHeaders for the email. You can have up to 15 Headers.
         * </p>
         * 
         * @param headers
         *        The list of MessageHeaders for the email. You can have up to 15 Headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Collection<MessageHeader> headers);

        /**
         * <p>
         * The list of MessageHeaders for the email. You can have up to 15 Headers.
         * </p>
         * 
         * @param headers
         *        The list of MessageHeaders for the email. You can have up to 15 Headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(MessageHeader... headers);

        /**
         * <p>
         * The list of MessageHeaders for the email. You can have up to 15 Headers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader.Builder#build()} is called immediately
         * and its result is passed to {@link #headers(List<MessageHeader>)}.
         * 
         * @param headers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(java.util.Collection<MessageHeader>)
         */
        Builder headers(Consumer<MessageHeader.Builder>... headers);
    }

    static final class BuilderImpl implements Builder {
        private SimpleEmailPart htmlPart;

        private SimpleEmailPart subject;

        private SimpleEmailPart textPart;

        private List<MessageHeader> headers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SimpleEmail model) {
            htmlPart(model.htmlPart);
            subject(model.subject);
            textPart(model.textPart);
            headers(model.headers);
        }

        public final SimpleEmailPart.Builder getHtmlPart() {
            return htmlPart != null ? htmlPart.toBuilder() : null;
        }

        public final void setHtmlPart(SimpleEmailPart.BuilderImpl htmlPart) {
            this.htmlPart = htmlPart != null ? htmlPart.build() : null;
        }

        @Override
        public final Builder htmlPart(SimpleEmailPart htmlPart) {
            this.htmlPart = htmlPart;
            return this;
        }

        public final SimpleEmailPart.Builder getSubject() {
            return subject != null ? subject.toBuilder() : null;
        }

        public final void setSubject(SimpleEmailPart.BuilderImpl subject) {
            this.subject = subject != null ? subject.build() : null;
        }

        @Override
        public final Builder subject(SimpleEmailPart subject) {
            this.subject = subject;
            return this;
        }

        public final SimpleEmailPart.Builder getTextPart() {
            return textPart != null ? textPart.toBuilder() : null;
        }

        public final void setTextPart(SimpleEmailPart.BuilderImpl textPart) {
            this.textPart = textPart != null ? textPart.build() : null;
        }

        @Override
        public final Builder textPart(SimpleEmailPart textPart) {
            this.textPart = textPart;
            return this;
        }

        public final List<MessageHeader.Builder> getHeaders() {
            List<MessageHeader.Builder> result = ListOfMessageHeaderCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<MessageHeader.BuilderImpl> headers) {
            this.headers = ListOfMessageHeaderCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<MessageHeader> headers) {
            this.headers = ListOfMessageHeaderCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(MessageHeader... headers) {
            headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<MessageHeader.Builder>... headers) {
            headers(Stream.of(headers).map(c -> MessageHeader.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SimpleEmail build() {
            return new SimpleEmail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
