/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings and content for the default message and any default messages that you tailored for specific
 * channels.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DirectMessageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DirectMessageConfiguration.Builder, DirectMessageConfiguration> {
    private static final SdkField<ADMMessage> ADM_MESSAGE_FIELD = SdkField.<ADMMessage> builder(MarshallingType.SDK_POJO)
            .memberName("ADMMessage").getter(getter(DirectMessageConfiguration::admMessage)).setter(setter(Builder::admMessage))
            .constructor(ADMMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ADMMessage").build()).build();

    private static final SdkField<APNSMessage> APNS_MESSAGE_FIELD = SdkField.<APNSMessage> builder(MarshallingType.SDK_POJO)
            .memberName("APNSMessage").getter(getter(DirectMessageConfiguration::apnsMessage))
            .setter(setter(Builder::apnsMessage)).constructor(APNSMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNSMessage").build()).build();

    private static final SdkField<BaiduMessage> BAIDU_MESSAGE_FIELD = SdkField.<BaiduMessage> builder(MarshallingType.SDK_POJO)
            .memberName("BaiduMessage").getter(getter(DirectMessageConfiguration::baiduMessage))
            .setter(setter(Builder::baiduMessage)).constructor(BaiduMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaiduMessage").build()).build();

    private static final SdkField<DefaultMessage> DEFAULT_MESSAGE_FIELD = SdkField
            .<DefaultMessage> builder(MarshallingType.SDK_POJO).memberName("DefaultMessage")
            .getter(getter(DirectMessageConfiguration::defaultMessage)).setter(setter(Builder::defaultMessage))
            .constructor(DefaultMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultMessage").build()).build();

    private static final SdkField<DefaultPushNotificationMessage> DEFAULT_PUSH_NOTIFICATION_MESSAGE_FIELD = SdkField
            .<DefaultPushNotificationMessage> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultPushNotificationMessage")
            .getter(getter(DirectMessageConfiguration::defaultPushNotificationMessage))
            .setter(setter(Builder::defaultPushNotificationMessage))
            .constructor(DefaultPushNotificationMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultPushNotificationMessage")
                    .build()).build();

    private static final SdkField<EmailMessage> EMAIL_MESSAGE_FIELD = SdkField.<EmailMessage> builder(MarshallingType.SDK_POJO)
            .memberName("EmailMessage").getter(getter(DirectMessageConfiguration::emailMessage))
            .setter(setter(Builder::emailMessage)).constructor(EmailMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()).build();

    private static final SdkField<GCMMessage> GCM_MESSAGE_FIELD = SdkField.<GCMMessage> builder(MarshallingType.SDK_POJO)
            .memberName("GCMMessage").getter(getter(DirectMessageConfiguration::gcmMessage)).setter(setter(Builder::gcmMessage))
            .constructor(GCMMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GCMMessage").build()).build();

    private static final SdkField<SMSMessage> SMS_MESSAGE_FIELD = SdkField.<SMSMessage> builder(MarshallingType.SDK_POJO)
            .memberName("SMSMessage").getter(getter(DirectMessageConfiguration::smsMessage)).setter(setter(Builder::smsMessage))
            .constructor(SMSMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSMessage").build()).build();

    private static final SdkField<VoiceMessage> VOICE_MESSAGE_FIELD = SdkField.<VoiceMessage> builder(MarshallingType.SDK_POJO)
            .memberName("VoiceMessage").getter(getter(DirectMessageConfiguration::voiceMessage))
            .setter(setter(Builder::voiceMessage)).constructor(VoiceMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADM_MESSAGE_FIELD,
            APNS_MESSAGE_FIELD, BAIDU_MESSAGE_FIELD, DEFAULT_MESSAGE_FIELD, DEFAULT_PUSH_NOTIFICATION_MESSAGE_FIELD,
            EMAIL_MESSAGE_FIELD, GCM_MESSAGE_FIELD, SMS_MESSAGE_FIELD, VOICE_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ADMMessage admMessage;

    private final APNSMessage apnsMessage;

    private final BaiduMessage baiduMessage;

    private final DefaultMessage defaultMessage;

    private final DefaultPushNotificationMessage defaultPushNotificationMessage;

    private final EmailMessage emailMessage;

    private final GCMMessage gcmMessage;

    private final SMSMessage smsMessage;

    private final VoiceMessage voiceMessage;

    private DirectMessageConfiguration(BuilderImpl builder) {
        this.admMessage = builder.admMessage;
        this.apnsMessage = builder.apnsMessage;
        this.baiduMessage = builder.baiduMessage;
        this.defaultMessage = builder.defaultMessage;
        this.defaultPushNotificationMessage = builder.defaultPushNotificationMessage;
        this.emailMessage = builder.emailMessage;
        this.gcmMessage = builder.gcmMessage;
        this.smsMessage = builder.smsMessage;
        this.voiceMessage = builder.voiceMessage;
    }

    /**
     * <p>
     * The default push notification message for the ADM (Amazon Device Messaging) channel. This message overrides the
     * default push notification message (DefaultPushNotificationMessage).
     * </p>
     * 
     * @return The default push notification message for the ADM (Amazon Device Messaging) channel. This message
     *         overrides the default push notification message (DefaultPushNotificationMessage).
     */
    public final ADMMessage admMessage() {
        return admMessage;
    }

    /**
     * <p>
     * The default push notification message for the APNs (Apple Push Notification service) channel. This message
     * overrides the default push notification message (DefaultPushNotificationMessage).
     * </p>
     * 
     * @return The default push notification message for the APNs (Apple Push Notification service) channel. This
     *         message overrides the default push notification message (DefaultPushNotificationMessage).
     */
    public final APNSMessage apnsMessage() {
        return apnsMessage;
    }

    /**
     * <p>
     * The default push notification message for the Baidu (Baidu Cloud Push) channel. This message overrides the
     * default push notification message (DefaultPushNotificationMessage).
     * </p>
     * 
     * @return The default push notification message for the Baidu (Baidu Cloud Push) channel. This message overrides
     *         the default push notification message (DefaultPushNotificationMessage).
     */
    public final BaiduMessage baiduMessage() {
        return baiduMessage;
    }

    /**
     * <p>
     * The default message for all channels.
     * </p>
     * 
     * @return The default message for all channels.
     */
    public final DefaultMessage defaultMessage() {
        return defaultMessage;
    }

    /**
     * <p>
     * The default push notification message for all push notification channels.
     * </p>
     * 
     * @return The default push notification message for all push notification channels.
     */
    public final DefaultPushNotificationMessage defaultPushNotificationMessage() {
        return defaultPushNotificationMessage;
    }

    /**
     * <p>
     * The default message for the email channel. This message overrides the default message (DefaultMessage).
     * </p>
     * 
     * @return The default message for the email channel. This message overrides the default message (DefaultMessage).
     */
    public final EmailMessage emailMessage() {
        return emailMessage;
    }

    /**
     * <p>
     * The default push notification message for the GCM channel, which is used to send notifications through the
     * Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message overrides the
     * default push notification message (DefaultPushNotificationMessage).
     * </p>
     * 
     * @return The default push notification message for the GCM channel, which is used to send notifications through
     *         the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message
     *         overrides the default push notification message (DefaultPushNotificationMessage).
     */
    public final GCMMessage gcmMessage() {
        return gcmMessage;
    }

    /**
     * <p>
     * The default message for the SMS channel. This message overrides the default message (DefaultMessage).
     * </p>
     * 
     * @return The default message for the SMS channel. This message overrides the default message (DefaultMessage).
     */
    public final SMSMessage smsMessage() {
        return smsMessage;
    }

    /**
     * <p>
     * The default message for the voice channel. This message overrides the default message (DefaultMessage).
     * </p>
     * 
     * @return The default message for the voice channel. This message overrides the default message (DefaultMessage).
     */
    public final VoiceMessage voiceMessage() {
        return voiceMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(admMessage());
        hashCode = 31 * hashCode + Objects.hashCode(apnsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(baiduMessage());
        hashCode = 31 * hashCode + Objects.hashCode(defaultMessage());
        hashCode = 31 * hashCode + Objects.hashCode(defaultPushNotificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(gcmMessage());
        hashCode = 31 * hashCode + Objects.hashCode(smsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(voiceMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectMessageConfiguration)) {
            return false;
        }
        DirectMessageConfiguration other = (DirectMessageConfiguration) obj;
        return Objects.equals(admMessage(), other.admMessage()) && Objects.equals(apnsMessage(), other.apnsMessage())
                && Objects.equals(baiduMessage(), other.baiduMessage())
                && Objects.equals(defaultMessage(), other.defaultMessage())
                && Objects.equals(defaultPushNotificationMessage(), other.defaultPushNotificationMessage())
                && Objects.equals(emailMessage(), other.emailMessage()) && Objects.equals(gcmMessage(), other.gcmMessage())
                && Objects.equals(smsMessage(), other.smsMessage()) && Objects.equals(voiceMessage(), other.voiceMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DirectMessageConfiguration").add("ADMMessage", admMessage()).add("APNSMessage", apnsMessage())
                .add("BaiduMessage", baiduMessage()).add("DefaultMessage", defaultMessage())
                .add("DefaultPushNotificationMessage", defaultPushNotificationMessage()).add("EmailMessage", emailMessage())
                .add("GCMMessage", gcmMessage()).add("SMSMessage", smsMessage()).add("VoiceMessage", voiceMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ADMMessage":
            return Optional.ofNullable(clazz.cast(admMessage()));
        case "APNSMessage":
            return Optional.ofNullable(clazz.cast(apnsMessage()));
        case "BaiduMessage":
            return Optional.ofNullable(clazz.cast(baiduMessage()));
        case "DefaultMessage":
            return Optional.ofNullable(clazz.cast(defaultMessage()));
        case "DefaultPushNotificationMessage":
            return Optional.ofNullable(clazz.cast(defaultPushNotificationMessage()));
        case "EmailMessage":
            return Optional.ofNullable(clazz.cast(emailMessage()));
        case "GCMMessage":
            return Optional.ofNullable(clazz.cast(gcmMessage()));
        case "SMSMessage":
            return Optional.ofNullable(clazz.cast(smsMessage()));
        case "VoiceMessage":
            return Optional.ofNullable(clazz.cast(voiceMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectMessageConfiguration, T> g) {
        return obj -> g.apply((DirectMessageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DirectMessageConfiguration> {
        /**
         * <p>
         * The default push notification message for the ADM (Amazon Device Messaging) channel. This message overrides
         * the default push notification message (DefaultPushNotificationMessage).
         * </p>
         * 
         * @param admMessage
         *        The default push notification message for the ADM (Amazon Device Messaging) channel. This message
         *        overrides the default push notification message (DefaultPushNotificationMessage).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder admMessage(ADMMessage admMessage);

        /**
         * <p>
         * The default push notification message for the ADM (Amazon Device Messaging) channel. This message overrides
         * the default push notification message (DefaultPushNotificationMessage).
         * </p>
         * This is a convenience method that creates an instance of the {@link ADMMessage.Builder} avoiding the need to
         * create one manually via {@link ADMMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ADMMessage.Builder#build()} is called immediately and its result
         * is passed to {@link #admMessage(ADMMessage)}.
         * 
         * @param admMessage
         *        a consumer that will call methods on {@link ADMMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #admMessage(ADMMessage)
         */
        default Builder admMessage(Consumer<ADMMessage.Builder> admMessage) {
            return admMessage(ADMMessage.builder().applyMutation(admMessage).build());
        }

        /**
         * <p>
         * The default push notification message for the APNs (Apple Push Notification service) channel. This message
         * overrides the default push notification message (DefaultPushNotificationMessage).
         * </p>
         * 
         * @param apnsMessage
         *        The default push notification message for the APNs (Apple Push Notification service) channel. This
         *        message overrides the default push notification message (DefaultPushNotificationMessage).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apnsMessage(APNSMessage apnsMessage);

        /**
         * <p>
         * The default push notification message for the APNs (Apple Push Notification service) channel. This message
         * overrides the default push notification message (DefaultPushNotificationMessage).
         * </p>
         * This is a convenience method that creates an instance of the {@link APNSMessage.Builder} avoiding the need to
         * create one manually via {@link APNSMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link APNSMessage.Builder#build()} is called immediately and its result
         * is passed to {@link #apnsMessage(APNSMessage)}.
         * 
         * @param apnsMessage
         *        a consumer that will call methods on {@link APNSMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apnsMessage(APNSMessage)
         */
        default Builder apnsMessage(Consumer<APNSMessage.Builder> apnsMessage) {
            return apnsMessage(APNSMessage.builder().applyMutation(apnsMessage).build());
        }

        /**
         * <p>
         * The default push notification message for the Baidu (Baidu Cloud Push) channel. This message overrides the
         * default push notification message (DefaultPushNotificationMessage).
         * </p>
         * 
         * @param baiduMessage
         *        The default push notification message for the Baidu (Baidu Cloud Push) channel. This message overrides
         *        the default push notification message (DefaultPushNotificationMessage).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baiduMessage(BaiduMessage baiduMessage);

        /**
         * <p>
         * The default push notification message for the Baidu (Baidu Cloud Push) channel. This message overrides the
         * default push notification message (DefaultPushNotificationMessage).
         * </p>
         * This is a convenience method that creates an instance of the {@link BaiduMessage.Builder} avoiding the need
         * to create one manually via {@link BaiduMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BaiduMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #baiduMessage(BaiduMessage)}.
         * 
         * @param baiduMessage
         *        a consumer that will call methods on {@link BaiduMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baiduMessage(BaiduMessage)
         */
        default Builder baiduMessage(Consumer<BaiduMessage.Builder> baiduMessage) {
            return baiduMessage(BaiduMessage.builder().applyMutation(baiduMessage).build());
        }

        /**
         * <p>
         * The default message for all channels.
         * </p>
         * 
         * @param defaultMessage
         *        The default message for all channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultMessage(DefaultMessage defaultMessage);

        /**
         * <p>
         * The default message for all channels.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultMessage.Builder} avoiding the need
         * to create one manually via {@link DefaultMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultMessage(DefaultMessage)}.
         * 
         * @param defaultMessage
         *        a consumer that will call methods on {@link DefaultMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultMessage(DefaultMessage)
         */
        default Builder defaultMessage(Consumer<DefaultMessage.Builder> defaultMessage) {
            return defaultMessage(DefaultMessage.builder().applyMutation(defaultMessage).build());
        }

        /**
         * <p>
         * The default push notification message for all push notification channels.
         * </p>
         * 
         * @param defaultPushNotificationMessage
         *        The default push notification message for all push notification channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultPushNotificationMessage(DefaultPushNotificationMessage defaultPushNotificationMessage);

        /**
         * <p>
         * The default push notification message for all push notification channels.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultPushNotificationMessage.Builder}
         * avoiding the need to create one manually via {@link DefaultPushNotificationMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultPushNotificationMessage.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #defaultPushNotificationMessage(DefaultPushNotificationMessage)}.
         * 
         * @param defaultPushNotificationMessage
         *        a consumer that will call methods on {@link DefaultPushNotificationMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultPushNotificationMessage(DefaultPushNotificationMessage)
         */
        default Builder defaultPushNotificationMessage(
                Consumer<DefaultPushNotificationMessage.Builder> defaultPushNotificationMessage) {
            return defaultPushNotificationMessage(DefaultPushNotificationMessage.builder()
                    .applyMutation(defaultPushNotificationMessage).build());
        }

        /**
         * <p>
         * The default message for the email channel. This message overrides the default message (DefaultMessage).
         * </p>
         * 
         * @param emailMessage
         *        The default message for the email channel. This message overrides the default message
         *        (DefaultMessage).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMessage(EmailMessage emailMessage);

        /**
         * <p>
         * The default message for the email channel. This message overrides the default message (DefaultMessage).
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailMessage.Builder} avoiding the need
         * to create one manually via {@link EmailMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #emailMessage(EmailMessage)}.
         * 
         * @param emailMessage
         *        a consumer that will call methods on {@link EmailMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailMessage(EmailMessage)
         */
        default Builder emailMessage(Consumer<EmailMessage.Builder> emailMessage) {
            return emailMessage(EmailMessage.builder().applyMutation(emailMessage).build());
        }

        /**
         * <p>
         * The default push notification message for the GCM channel, which is used to send notifications through the
         * Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message overrides the
         * default push notification message (DefaultPushNotificationMessage).
         * </p>
         * 
         * @param gcmMessage
         *        The default push notification message for the GCM channel, which is used to send notifications through
         *        the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message
         *        overrides the default push notification message (DefaultPushNotificationMessage).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gcmMessage(GCMMessage gcmMessage);

        /**
         * <p>
         * The default push notification message for the GCM channel, which is used to send notifications through the
         * Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message overrides the
         * default push notification message (DefaultPushNotificationMessage).
         * </p>
         * This is a convenience method that creates an instance of the {@link GCMMessage.Builder} avoiding the need to
         * create one manually via {@link GCMMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GCMMessage.Builder#build()} is called immediately and its result
         * is passed to {@link #gcmMessage(GCMMessage)}.
         * 
         * @param gcmMessage
         *        a consumer that will call methods on {@link GCMMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gcmMessage(GCMMessage)
         */
        default Builder gcmMessage(Consumer<GCMMessage.Builder> gcmMessage) {
            return gcmMessage(GCMMessage.builder().applyMutation(gcmMessage).build());
        }

        /**
         * <p>
         * The default message for the SMS channel. This message overrides the default message (DefaultMessage).
         * </p>
         * 
         * @param smsMessage
         *        The default message for the SMS channel. This message overrides the default message (DefaultMessage).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsMessage(SMSMessage smsMessage);

        /**
         * <p>
         * The default message for the SMS channel. This message overrides the default message (DefaultMessage).
         * </p>
         * This is a convenience method that creates an instance of the {@link SMSMessage.Builder} avoiding the need to
         * create one manually via {@link SMSMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SMSMessage.Builder#build()} is called immediately and its result
         * is passed to {@link #smsMessage(SMSMessage)}.
         * 
         * @param smsMessage
         *        a consumer that will call methods on {@link SMSMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsMessage(SMSMessage)
         */
        default Builder smsMessage(Consumer<SMSMessage.Builder> smsMessage) {
            return smsMessage(SMSMessage.builder().applyMutation(smsMessage).build());
        }

        /**
         * <p>
         * The default message for the voice channel. This message overrides the default message (DefaultMessage).
         * </p>
         * 
         * @param voiceMessage
         *        The default message for the voice channel. This message overrides the default message
         *        (DefaultMessage).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceMessage(VoiceMessage voiceMessage);

        /**
         * <p>
         * The default message for the voice channel. This message overrides the default message (DefaultMessage).
         * </p>
         * This is a convenience method that creates an instance of the {@link VoiceMessage.Builder} avoiding the need
         * to create one manually via {@link VoiceMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #voiceMessage(VoiceMessage)}.
         * 
         * @param voiceMessage
         *        a consumer that will call methods on {@link VoiceMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceMessage(VoiceMessage)
         */
        default Builder voiceMessage(Consumer<VoiceMessage.Builder> voiceMessage) {
            return voiceMessage(VoiceMessage.builder().applyMutation(voiceMessage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ADMMessage admMessage;

        private APNSMessage apnsMessage;

        private BaiduMessage baiduMessage;

        private DefaultMessage defaultMessage;

        private DefaultPushNotificationMessage defaultPushNotificationMessage;

        private EmailMessage emailMessage;

        private GCMMessage gcmMessage;

        private SMSMessage smsMessage;

        private VoiceMessage voiceMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectMessageConfiguration model) {
            admMessage(model.admMessage);
            apnsMessage(model.apnsMessage);
            baiduMessage(model.baiduMessage);
            defaultMessage(model.defaultMessage);
            defaultPushNotificationMessage(model.defaultPushNotificationMessage);
            emailMessage(model.emailMessage);
            gcmMessage(model.gcmMessage);
            smsMessage(model.smsMessage);
            voiceMessage(model.voiceMessage);
        }

        public final ADMMessage.Builder getAdmMessage() {
            return admMessage != null ? admMessage.toBuilder() : null;
        }

        public final void setAdmMessage(ADMMessage.BuilderImpl admMessage) {
            this.admMessage = admMessage != null ? admMessage.build() : null;
        }

        @Override
        public final Builder admMessage(ADMMessage admMessage) {
            this.admMessage = admMessage;
            return this;
        }

        public final APNSMessage.Builder getApnsMessage() {
            return apnsMessage != null ? apnsMessage.toBuilder() : null;
        }

        public final void setApnsMessage(APNSMessage.BuilderImpl apnsMessage) {
            this.apnsMessage = apnsMessage != null ? apnsMessage.build() : null;
        }

        @Override
        public final Builder apnsMessage(APNSMessage apnsMessage) {
            this.apnsMessage = apnsMessage;
            return this;
        }

        public final BaiduMessage.Builder getBaiduMessage() {
            return baiduMessage != null ? baiduMessage.toBuilder() : null;
        }

        public final void setBaiduMessage(BaiduMessage.BuilderImpl baiduMessage) {
            this.baiduMessage = baiduMessage != null ? baiduMessage.build() : null;
        }

        @Override
        public final Builder baiduMessage(BaiduMessage baiduMessage) {
            this.baiduMessage = baiduMessage;
            return this;
        }

        public final DefaultMessage.Builder getDefaultMessage() {
            return defaultMessage != null ? defaultMessage.toBuilder() : null;
        }

        public final void setDefaultMessage(DefaultMessage.BuilderImpl defaultMessage) {
            this.defaultMessage = defaultMessage != null ? defaultMessage.build() : null;
        }

        @Override
        public final Builder defaultMessage(DefaultMessage defaultMessage) {
            this.defaultMessage = defaultMessage;
            return this;
        }

        public final DefaultPushNotificationMessage.Builder getDefaultPushNotificationMessage() {
            return defaultPushNotificationMessage != null ? defaultPushNotificationMessage.toBuilder() : null;
        }

        public final void setDefaultPushNotificationMessage(
                DefaultPushNotificationMessage.BuilderImpl defaultPushNotificationMessage) {
            this.defaultPushNotificationMessage = defaultPushNotificationMessage != null ? defaultPushNotificationMessage.build()
                    : null;
        }

        @Override
        public final Builder defaultPushNotificationMessage(DefaultPushNotificationMessage defaultPushNotificationMessage) {
            this.defaultPushNotificationMessage = defaultPushNotificationMessage;
            return this;
        }

        public final EmailMessage.Builder getEmailMessage() {
            return emailMessage != null ? emailMessage.toBuilder() : null;
        }

        public final void setEmailMessage(EmailMessage.BuilderImpl emailMessage) {
            this.emailMessage = emailMessage != null ? emailMessage.build() : null;
        }

        @Override
        public final Builder emailMessage(EmailMessage emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final GCMMessage.Builder getGcmMessage() {
            return gcmMessage != null ? gcmMessage.toBuilder() : null;
        }

        public final void setGcmMessage(GCMMessage.BuilderImpl gcmMessage) {
            this.gcmMessage = gcmMessage != null ? gcmMessage.build() : null;
        }

        @Override
        public final Builder gcmMessage(GCMMessage gcmMessage) {
            this.gcmMessage = gcmMessage;
            return this;
        }

        public final SMSMessage.Builder getSmsMessage() {
            return smsMessage != null ? smsMessage.toBuilder() : null;
        }

        public final void setSmsMessage(SMSMessage.BuilderImpl smsMessage) {
            this.smsMessage = smsMessage != null ? smsMessage.build() : null;
        }

        @Override
        public final Builder smsMessage(SMSMessage smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final VoiceMessage.Builder getVoiceMessage() {
            return voiceMessage != null ? voiceMessage.toBuilder() : null;
        }

        public final void setVoiceMessage(VoiceMessage.BuilderImpl voiceMessage) {
            this.voiceMessage = voiceMessage != null ? voiceMessage.build() : null;
        }

        @Override
        public final Builder voiceMessage(VoiceMessage voiceMessage) {
            this.voiceMessage = voiceMessage;
            return this;
        }

        @Override
        public DirectMessageConfiguration build() {
            return new DirectMessageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
