/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.panorama.PanoramaClient;
import software.amazon.awssdk.services.panorama.internal.UserAgentUtils;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse;

public class ListApplicationInstanceDependenciesIterable
implements SdkIterable<ListApplicationInstanceDependenciesResponse> {
    private final PanoramaClient client;
    private final ListApplicationInstanceDependenciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationInstanceDependenciesIterable(PanoramaClient client, ListApplicationInstanceDependenciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationInstanceDependenciesResponseFetcher();
    }

    public Iterator<ListApplicationInstanceDependenciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListApplicationInstanceDependenciesResponseFetcher
    implements SyncPageFetcher<ListApplicationInstanceDependenciesResponse> {
        private ListApplicationInstanceDependenciesResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationInstanceDependenciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationInstanceDependenciesResponse nextPage(ListApplicationInstanceDependenciesResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationInstanceDependenciesIterable.this.client.listApplicationInstanceDependencies(ListApplicationInstanceDependenciesIterable.this.firstRequest);
            }
            return ListApplicationInstanceDependenciesIterable.this.client.listApplicationInstanceDependencies((ListApplicationInstanceDependenciesRequest)((Object)ListApplicationInstanceDependenciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

