/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHandshakesForAccountResponse extends OrganizationsResponse implements
        ToCopyableBuilder<ListHandshakesForAccountResponse.Builder, ListHandshakesForAccountResponse> {
    private static final SdkField<List<Handshake>> HANDSHAKES_FIELD = SdkField
            .<List<Handshake>> builder(MarshallingType.LIST)
            .memberName("Handshakes")
            .getter(getter(ListHandshakesForAccountResponse::handshakes))
            .setter(setter(Builder::handshakes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handshakes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Handshake> builder(MarshallingType.SDK_POJO)
                                            .constructor(Handshake::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHandshakesForAccountResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HANDSHAKES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Handshake> handshakes;

    private final String nextToken;

    private ListHandshakesForAccountResponse(BuilderImpl builder) {
        super(builder);
        this.handshakes = builder.handshakes;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Handshakes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHandshakes() {
        return handshakes != null && !(handshakes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>Handshake</a> objects with details about each of the handshakes that is associated with the
     * specified account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHandshakes} method.
     * </p>
     * 
     * @return A list of <a>Handshake</a> objects with details about each of the handshakes that is associated with the
     *         specified account.
     */
    public final List<Handshake> handshakes() {
        return handshakes;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHandshakes() ? handshakes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHandshakesForAccountResponse)) {
            return false;
        }
        ListHandshakesForAccountResponse other = (ListHandshakesForAccountResponse) obj;
        return hasHandshakes() == other.hasHandshakes() && Objects.equals(handshakes(), other.handshakes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHandshakesForAccountResponse").add("Handshakes", hasHandshakes() ? handshakes() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Handshakes":
            return Optional.ofNullable(clazz.cast(handshakes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHandshakesForAccountResponse, T> g) {
        return obj -> g.apply((ListHandshakesForAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListHandshakesForAccountResponse> {
        /**
         * <p>
         * A list of <a>Handshake</a> objects with details about each of the handshakes that is associated with the
         * specified account.
         * </p>
         * 
         * @param handshakes
         *        A list of <a>Handshake</a> objects with details about each of the handshakes that is associated with
         *        the specified account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handshakes(Collection<Handshake> handshakes);

        /**
         * <p>
         * A list of <a>Handshake</a> objects with details about each of the handshakes that is associated with the
         * specified account.
         * </p>
         * 
         * @param handshakes
         *        A list of <a>Handshake</a> objects with details about each of the handshakes that is associated with
         *        the specified account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handshakes(Handshake... handshakes);

        /**
         * <p>
         * A list of <a>Handshake</a> objects with details about each of the handshakes that is associated with the
         * specified account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.organizations.model.Handshake.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.organizations.model.Handshake#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.organizations.model.Handshake.Builder#build()} is called immediately
         * and its result is passed to {@link #handshakes(List<Handshake>)}.
         * 
         * @param handshakes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.organizations.model.Handshake.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #handshakes(java.util.Collection<Handshake>)
         */
        Builder handshakes(Consumer<Handshake.Builder>... handshakes);

        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of
         * the output. You should repeat this until the <code>NextToken</code> response element comes back as
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         *        next part of the output. You should repeat this until the <code>NextToken</code> response element
         *        comes back as <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private List<Handshake> handshakes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHandshakesForAccountResponse model) {
            super(model);
            handshakes(model.handshakes);
            nextToken(model.nextToken);
        }

        public final List<Handshake.Builder> getHandshakes() {
            List<Handshake.Builder> result = HandshakesCopier.copyToBuilder(this.handshakes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHandshakes(Collection<Handshake.BuilderImpl> handshakes) {
            this.handshakes = HandshakesCopier.copyFromBuilder(handshakes);
        }

        @Override
        public final Builder handshakes(Collection<Handshake> handshakes) {
            this.handshakes = HandshakesCopier.copy(handshakes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder handshakes(Handshake... handshakes) {
            handshakes(Arrays.asList(handshakes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder handshakes(Consumer<Handshake.Builder>... handshakes) {
            handshakes(Stream.of(handshakes).map(c -> Handshake.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListHandshakesForAccountResponse build() {
            return new ListHandshakesForAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
