/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum CreateAccountFailureReason {
    ACCOUNT_LIMIT_EXCEEDED("ACCOUNT_LIMIT_EXCEEDED"),

    EMAIL_ALREADY_EXISTS("EMAIL_ALREADY_EXISTS"),

    INVALID_ADDRESS("INVALID_ADDRESS"),

    INVALID_EMAIL("INVALID_EMAIL"),

    CONCURRENT_ACCOUNT_MODIFICATION("CONCURRENT_ACCOUNT_MODIFICATION"),

    INTERNAL_FAILURE("INTERNAL_FAILURE"),

    GOVCLOUD_ACCOUNT_ALREADY_EXISTS("GOVCLOUD_ACCOUNT_ALREADY_EXISTS"),

    MISSING_BUSINESS_VALIDATION("MISSING_BUSINESS_VALIDATION"),

    FAILED_BUSINESS_VALIDATION("FAILED_BUSINESS_VALIDATION"),

    PENDING_BUSINESS_VALIDATION("PENDING_BUSINESS_VALIDATION"),

    INVALID_IDENTITY_FOR_BUSINESS_VALIDATION("INVALID_IDENTITY_FOR_BUSINESS_VALIDATION"),

    UNKNOWN_BUSINESS_VALIDATION("UNKNOWN_BUSINESS_VALIDATION"),

    MISSING_PAYMENT_INSTRUMENT("MISSING_PAYMENT_INSTRUMENT"),

    INVALID_PAYMENT_INSTRUMENT("INVALID_PAYMENT_INSTRUMENT"),

    UPDATE_EXISTING_RESOURCE_POLICY_WITH_TAGS_NOT_SUPPORTED("UPDATE_EXISTING_RESOURCE_POLICY_WITH_TAGS_NOT_SUPPORTED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CreateAccountFailureReason> VALUE_MAP = EnumUtils.uniqueIndex(
            CreateAccountFailureReason.class, CreateAccountFailureReason::toString);

    private final String value;

    private CreateAccountFailureReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CreateAccountFailureReason corresponding to the value
     */
    public static CreateAccountFailureReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CreateAccountFailureReason}s
     */
    public static Set<CreateAccountFailureReason> knownValues() {
        Set<CreateAccountFailureReason> knownValues = EnumSet.allOf(CreateAccountFailureReason.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
