/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrantAccessRequest extends OpsWorksRequest implements
        ToCopyableBuilder<GrantAccessRequest.Builder, GrantAccessRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(GrantAccessRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<Integer> VALID_FOR_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ValidForInMinutes").getter(getter(GrantAccessRequest::validForInMinutes))
            .setter(setter(Builder::validForInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidForInMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            VALID_FOR_IN_MINUTES_FIELD));

    private final String instanceId;

    private final Integer validForInMinutes;

    private GrantAccessRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.validForInMinutes = builder.validForInMinutes;
    }

    /**
     * <p>
     * The instance's OpsWorks Stacks ID.
     * </p>
     * 
     * @return The instance's OpsWorks Stacks ID.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The length of time (in minutes) that the grant is valid. When the grant expires at the end of this period, the
     * user will no longer be able to use the credentials to log in. If the user is logged in at the time, they are
     * logged out.
     * </p>
     * 
     * @return The length of time (in minutes) that the grant is valid. When the grant expires at the end of this
     *         period, the user will no longer be able to use the credentials to log in. If the user is logged in at the
     *         time, they are logged out.
     */
    public final Integer validForInMinutes() {
        return validForInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(validForInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantAccessRequest)) {
            return false;
        }
        GrantAccessRequest other = (GrantAccessRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(validForInMinutes(), other.validForInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrantAccessRequest").add("InstanceId", instanceId())
                .add("ValidForInMinutes", validForInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ValidForInMinutes":
            return Optional.ofNullable(clazz.cast(validForInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrantAccessRequest, T> g) {
        return obj -> g.apply((GrantAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, GrantAccessRequest> {
        /**
         * <p>
         * The instance's OpsWorks Stacks ID.
         * </p>
         * 
         * @param instanceId
         *        The instance's OpsWorks Stacks ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The length of time (in minutes) that the grant is valid. When the grant expires at the end of this period,
         * the user will no longer be able to use the credentials to log in. If the user is logged in at the time, they
         * are logged out.
         * </p>
         * 
         * @param validForInMinutes
         *        The length of time (in minutes) that the grant is valid. When the grant expires at the end of this
         *        period, the user will no longer be able to use the credentials to log in. If the user is logged in at
         *        the time, they are logged out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validForInMinutes(Integer validForInMinutes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String instanceId;

        private Integer validForInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantAccessRequest model) {
            super(model);
            instanceId(model.instanceId);
            validForInMinutes(model.validForInMinutes);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Integer getValidForInMinutes() {
            return validForInMinutes;
        }

        public final void setValidForInMinutes(Integer validForInMinutes) {
            this.validForInMinutes = validForInMinutes;
        }

        @Override
        public final Builder validForInMinutes(Integer validForInMinutes) {
            this.validForInMinutes = validForInMinutes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GrantAccessRequest build() {
            return new GrantAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
