/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a load-based auto scaling upscaling or downscaling threshold configuration, which specifies when OpsWorks
 * Stacks starts or stops load-based instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingThresholds implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingThresholds.Builder, AutoScalingThresholds> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(AutoScalingThresholds::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<Integer> THRESHOLDS_WAIT_TIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThresholdsWaitTime").getter(getter(AutoScalingThresholds::thresholdsWaitTime))
            .setter(setter(Builder::thresholdsWaitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdsWaitTime").build())
            .build();

    private static final SdkField<Integer> IGNORE_METRICS_TIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IgnoreMetricsTime").getter(getter(AutoScalingThresholds::ignoreMetricsTime))
            .setter(setter(Builder::ignoreMetricsTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreMetricsTime").build()).build();

    private static final SdkField<Double> CPU_THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("CpuThreshold").getter(getter(AutoScalingThresholds::cpuThreshold)).setter(setter(Builder::cpuThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuThreshold").build()).build();

    private static final SdkField<Double> MEMORY_THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MemoryThreshold").getter(getter(AutoScalingThresholds::memoryThreshold))
            .setter(setter(Builder::memoryThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryThreshold").build()).build();

    private static final SdkField<Double> LOAD_THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LoadThreshold").getter(getter(AutoScalingThresholds::loadThreshold))
            .setter(setter(Builder::loadThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadThreshold").build()).build();

    private static final SdkField<List<String>> ALARMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Alarms")
            .getter(getter(AutoScalingThresholds::alarms))
            .setter(setter(Builder::alarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD,
            THRESHOLDS_WAIT_TIME_FIELD, IGNORE_METRICS_TIME_FIELD, CPU_THRESHOLD_FIELD, MEMORY_THRESHOLD_FIELD,
            LOAD_THRESHOLD_FIELD, ALARMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer instanceCount;

    private final Integer thresholdsWaitTime;

    private final Integer ignoreMetricsTime;

    private final Double cpuThreshold;

    private final Double memoryThreshold;

    private final Double loadThreshold;

    private final List<String> alarms;

    private AutoScalingThresholds(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.thresholdsWaitTime = builder.thresholdsWaitTime;
        this.ignoreMetricsTime = builder.ignoreMetricsTime;
        this.cpuThreshold = builder.cpuThreshold;
        this.memoryThreshold = builder.memoryThreshold;
        this.loadThreshold = builder.loadThreshold;
        this.alarms = builder.alarms;
    }

    /**
     * <p>
     * The number of instances to add or remove when the load exceeds a threshold.
     * </p>
     * 
     * @return The number of instances to add or remove when the load exceeds a threshold.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.
     * </p>
     * 
     * @return The amount of time, in minutes, that the load must exceed a threshold before more instances are added or
     *         removed.
     */
    public final Integer thresholdsWaitTime() {
        return thresholdsWaitTime;
    }

    /**
     * <p>
     * The amount of time (in minutes) after a scaling event occurs that OpsWorks Stacks should ignore metrics and
     * suppress additional scaling events. For example, OpsWorks Stacks adds new instances following an upscaling event
     * but the instances won't start reducing the load until they have been booted and configured. There is no point in
     * raising additional scaling events during that operation, which typically takes several minutes.
     * <code>IgnoreMetricsTime</code> allows you to direct OpsWorks Stacks to suppress scaling events long enough to get
     * the new instances online.
     * </p>
     * 
     * @return The amount of time (in minutes) after a scaling event occurs that OpsWorks Stacks should ignore metrics
     *         and suppress additional scaling events. For example, OpsWorks Stacks adds new instances following an
     *         upscaling event but the instances won't start reducing the load until they have been booted and
     *         configured. There is no point in raising additional scaling events during that operation, which typically
     *         takes several minutes. <code>IgnoreMetricsTime</code> allows you to direct OpsWorks Stacks to suppress
     *         scaling events long enough to get the new instances online.
     */
    public final Integer ignoreMetricsTime() {
        return ignoreMetricsTime;
    }

    /**
     * <p>
     * The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.
     * </p>
     * 
     * @return The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.
     */
    public final Double cpuThreshold() {
        return cpuThreshold;
    }

    /**
     * <p>
     * The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.
     * </p>
     * 
     * @return The memory utilization threshold, as a percent of the available memory. A value of -1 disables the
     *         threshold.
     */
    public final Double memoryThreshold() {
        return memoryThreshold;
    }

    /**
     * <p>
     * The load threshold. A value of -1 disables the threshold. For more information about how load is computed, see <a
     * href="http://en.wikipedia.org/wiki/Load_%28computing%29">Load (computing)</a>.
     * </p>
     * 
     * @return The load threshold. A value of -1 disables the threshold. For more information about how load is
     *         computed, see <a href="http://en.wikipedia.org/wiki/Load_%28computing%29">Load (computing)</a>.
     */
    public final Double loadThreshold() {
        return loadThreshold;
    }

    /**
     * For responses, this returns true if the service returned a value for the Alarms property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAlarms() {
        return alarms != null && !(alarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Custom CloudWatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm
     * names, which are case sensitive and must be in the same region as the stack.
     * </p>
     * <note>
     * <p>
     * To use custom alarms, you must update your service role to allow <code>cloudwatch:DescribeAlarms</code>. You can
     * either have OpsWorks Stacks update the role for you when you first use this feature or you can edit the role
     * manually. For more information, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html">Allowing OpsWorks
     * Stacks to Act on Your Behalf</a>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlarms} method.
     * </p>
     * 
     * @return Custom CloudWatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to
     *         five alarm names, which are case sensitive and must be in the same region as the stack.</p> <note>
     *         <p>
     *         To use custom alarms, you must update your service role to allow <code>cloudwatch:DescribeAlarms</code>.
     *         You can either have OpsWorks Stacks update the role for you when you first use this feature or you can
     *         edit the role manually. For more information, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html">Allowing
     *         OpsWorks Stacks to Act on Your Behalf</a>.
     *         </p>
     */
    public final List<String> alarms() {
        return alarms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdsWaitTime());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreMetricsTime());
        hashCode = 31 * hashCode + Objects.hashCode(cpuThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(memoryThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(loadThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarms() ? alarms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingThresholds)) {
            return false;
        }
        AutoScalingThresholds other = (AutoScalingThresholds) obj;
        return Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(thresholdsWaitTime(), other.thresholdsWaitTime())
                && Objects.equals(ignoreMetricsTime(), other.ignoreMetricsTime())
                && Objects.equals(cpuThreshold(), other.cpuThreshold())
                && Objects.equals(memoryThreshold(), other.memoryThreshold())
                && Objects.equals(loadThreshold(), other.loadThreshold()) && hasAlarms() == other.hasAlarms()
                && Objects.equals(alarms(), other.alarms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingThresholds").add("InstanceCount", instanceCount())
                .add("ThresholdsWaitTime", thresholdsWaitTime()).add("IgnoreMetricsTime", ignoreMetricsTime())
                .add("CpuThreshold", cpuThreshold()).add("MemoryThreshold", memoryThreshold())
                .add("LoadThreshold", loadThreshold()).add("Alarms", hasAlarms() ? alarms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "ThresholdsWaitTime":
            return Optional.ofNullable(clazz.cast(thresholdsWaitTime()));
        case "IgnoreMetricsTime":
            return Optional.ofNullable(clazz.cast(ignoreMetricsTime()));
        case "CpuThreshold":
            return Optional.ofNullable(clazz.cast(cpuThreshold()));
        case "MemoryThreshold":
            return Optional.ofNullable(clazz.cast(memoryThreshold()));
        case "LoadThreshold":
            return Optional.ofNullable(clazz.cast(loadThreshold()));
        case "Alarms":
            return Optional.ofNullable(clazz.cast(alarms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingThresholds, T> g) {
        return obj -> g.apply((AutoScalingThresholds) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingThresholds> {
        /**
         * <p>
         * The number of instances to add or remove when the load exceeds a threshold.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances to add or remove when the load exceeds a threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The amount of time, in minutes, that the load must exceed a threshold before more instances are added or
         * removed.
         * </p>
         * 
         * @param thresholdsWaitTime
         *        The amount of time, in minutes, that the load must exceed a threshold before more instances are added
         *        or removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdsWaitTime(Integer thresholdsWaitTime);

        /**
         * <p>
         * The amount of time (in minutes) after a scaling event occurs that OpsWorks Stacks should ignore metrics and
         * suppress additional scaling events. For example, OpsWorks Stacks adds new instances following an upscaling
         * event but the instances won't start reducing the load until they have been booted and configured. There is no
         * point in raising additional scaling events during that operation, which typically takes several minutes.
         * <code>IgnoreMetricsTime</code> allows you to direct OpsWorks Stacks to suppress scaling events long enough to
         * get the new instances online.
         * </p>
         * 
         * @param ignoreMetricsTime
         *        The amount of time (in minutes) after a scaling event occurs that OpsWorks Stacks should ignore
         *        metrics and suppress additional scaling events. For example, OpsWorks Stacks adds new instances
         *        following an upscaling event but the instances won't start reducing the load until they have been
         *        booted and configured. There is no point in raising additional scaling events during that operation,
         *        which typically takes several minutes. <code>IgnoreMetricsTime</code> allows you to direct OpsWorks
         *        Stacks to suppress scaling events long enough to get the new instances online.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreMetricsTime(Integer ignoreMetricsTime);

        /**
         * <p>
         * The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.
         * </p>
         * 
         * @param cpuThreshold
         *        The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the
         *        threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuThreshold(Double cpuThreshold);

        /**
         * <p>
         * The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.
         * </p>
         * 
         * @param memoryThreshold
         *        The memory utilization threshold, as a percent of the available memory. A value of -1 disables the
         *        threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryThreshold(Double memoryThreshold);

        /**
         * <p>
         * The load threshold. A value of -1 disables the threshold. For more information about how load is computed,
         * see <a href="http://en.wikipedia.org/wiki/Load_%28computing%29">Load (computing)</a>.
         * </p>
         * 
         * @param loadThreshold
         *        The load threshold. A value of -1 disables the threshold. For more information about how load is
         *        computed, see <a href="http://en.wikipedia.org/wiki/Load_%28computing%29">Load (computing)</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadThreshold(Double loadThreshold);

        /**
         * <p>
         * Custom CloudWatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five
         * alarm names, which are case sensitive and must be in the same region as the stack.
         * </p>
         * <note>
         * <p>
         * To use custom alarms, you must update your service role to allow <code>cloudwatch:DescribeAlarms</code>. You
         * can either have OpsWorks Stacks update the role for you when you first use this feature or you can edit the
         * role manually. For more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html">Allowing
         * OpsWorks Stacks to Act on Your Behalf</a>.
         * </p>
         * </note>
         * 
         * @param alarms
         *        Custom CloudWatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to
         *        five alarm names, which are case sensitive and must be in the same region as the stack.</p> <note>
         *        <p>
         *        To use custom alarms, you must update your service role to allow
         *        <code>cloudwatch:DescribeAlarms</code>. You can either have OpsWorks Stacks update the role for you
         *        when you first use this feature or you can edit the role manually. For more information, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html"
         *        >Allowing OpsWorks Stacks to Act on Your Behalf</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Collection<String> alarms);

        /**
         * <p>
         * Custom CloudWatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five
         * alarm names, which are case sensitive and must be in the same region as the stack.
         * </p>
         * <note>
         * <p>
         * To use custom alarms, you must update your service role to allow <code>cloudwatch:DescribeAlarms</code>. You
         * can either have OpsWorks Stacks update the role for you when you first use this feature or you can edit the
         * role manually. For more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html">Allowing
         * OpsWorks Stacks to Act on Your Behalf</a>.
         * </p>
         * </note>
         * 
         * @param alarms
         *        Custom CloudWatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to
         *        five alarm names, which are case sensitive and must be in the same region as the stack.</p> <note>
         *        <p>
         *        To use custom alarms, you must update your service role to allow
         *        <code>cloudwatch:DescribeAlarms</code>. You can either have OpsWorks Stacks update the role for you
         *        when you first use this feature or you can edit the role manually. For more information, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html"
         *        >Allowing OpsWorks Stacks to Act on Your Behalf</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(String... alarms);
    }

    static final class BuilderImpl implements Builder {
        private Integer instanceCount;

        private Integer thresholdsWaitTime;

        private Integer ignoreMetricsTime;

        private Double cpuThreshold;

        private Double memoryThreshold;

        private Double loadThreshold;

        private List<String> alarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingThresholds model) {
            instanceCount(model.instanceCount);
            thresholdsWaitTime(model.thresholdsWaitTime);
            ignoreMetricsTime(model.ignoreMetricsTime);
            cpuThreshold(model.cpuThreshold);
            memoryThreshold(model.memoryThreshold);
            loadThreshold(model.loadThreshold);
            alarms(model.alarms);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Integer getThresholdsWaitTime() {
            return thresholdsWaitTime;
        }

        public final void setThresholdsWaitTime(Integer thresholdsWaitTime) {
            this.thresholdsWaitTime = thresholdsWaitTime;
        }

        @Override
        public final Builder thresholdsWaitTime(Integer thresholdsWaitTime) {
            this.thresholdsWaitTime = thresholdsWaitTime;
            return this;
        }

        public final Integer getIgnoreMetricsTime() {
            return ignoreMetricsTime;
        }

        public final void setIgnoreMetricsTime(Integer ignoreMetricsTime) {
            this.ignoreMetricsTime = ignoreMetricsTime;
        }

        @Override
        public final Builder ignoreMetricsTime(Integer ignoreMetricsTime) {
            this.ignoreMetricsTime = ignoreMetricsTime;
            return this;
        }

        public final Double getCpuThreshold() {
            return cpuThreshold;
        }

        public final void setCpuThreshold(Double cpuThreshold) {
            this.cpuThreshold = cpuThreshold;
        }

        @Override
        public final Builder cpuThreshold(Double cpuThreshold) {
            this.cpuThreshold = cpuThreshold;
            return this;
        }

        public final Double getMemoryThreshold() {
            return memoryThreshold;
        }

        public final void setMemoryThreshold(Double memoryThreshold) {
            this.memoryThreshold = memoryThreshold;
        }

        @Override
        public final Builder memoryThreshold(Double memoryThreshold) {
            this.memoryThreshold = memoryThreshold;
            return this;
        }

        public final Double getLoadThreshold() {
            return loadThreshold;
        }

        public final void setLoadThreshold(Double loadThreshold) {
            this.loadThreshold = loadThreshold;
        }

        @Override
        public final Builder loadThreshold(Double loadThreshold) {
            this.loadThreshold = loadThreshold;
            return this;
        }

        public final Collection<String> getAlarms() {
            if (alarms instanceof SdkAutoConstructList) {
                return null;
            }
            return alarms;
        }

        public final void setAlarms(Collection<String> alarms) {
            this.alarms = StringsCopier.copy(alarms);
        }

        @Override
        public final Builder alarms(Collection<String> alarms) {
            this.alarms = StringsCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(String... alarms) {
            alarms(Arrays.asList(alarms));
            return this;
        }

        @Override
        public AutoScalingThresholds build() {
            return new AutoScalingThresholds(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
