/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStudioRequest extends NimbleRequest implements
        ToCopyableBuilder<UpdateStudioRequest.Builder, UpdateStudioRequest> {
    private static final SdkField<String> ADMIN_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adminRoleArn").getter(getter(UpdateStudioRequest::adminRoleArn)).setter(setter(Builder::adminRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminRoleArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateStudioRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateStudioRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioId").getter(getter(UpdateStudioRequest::studioId)).setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()).build();

    private static final SdkField<String> USER_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userRoleArn").getter(getter(UpdateStudioRequest::userRoleArn)).setter(setter(Builder::userRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ROLE_ARN_FIELD,
            CLIENT_TOKEN_FIELD, DISPLAY_NAME_FIELD, STUDIO_ID_FIELD, USER_ROLE_ARN_FIELD));

    private final String adminRoleArn;

    private final String clientToken;

    private final String displayName;

    private final String studioId;

    private final String userRoleArn;

    private UpdateStudioRequest(BuilderImpl builder) {
        super(builder);
        this.adminRoleArn = builder.adminRoleArn;
        this.clientToken = builder.clientToken;
        this.displayName = builder.displayName;
        this.studioId = builder.studioId;
        this.userRoleArn = builder.userRoleArn;
    }

    /**
     * <p>
     * The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.
     * </p>
     * 
     * @return The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.
     */
    public final String adminRoleArn() {
        return adminRoleArn;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify
     * a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to
     * ensure idempotency.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
     *         specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it
     *         for the request to ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A friendly name for the studio.
     * </p>
     * 
     * @return A friendly name for the studio.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The studio ID.
     * </p>
     * 
     * @return The studio ID.
     */
    public final String studioId() {
        return studioId;
    }

    /**
     * <p>
     * The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.
     * </p>
     * 
     * @return The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.
     */
    public final String userRoleArn() {
        return userRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adminRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        hashCode = 31 * hashCode + Objects.hashCode(userRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStudioRequest)) {
            return false;
        }
        UpdateStudioRequest other = (UpdateStudioRequest) obj;
        return Objects.equals(adminRoleArn(), other.adminRoleArn()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(studioId(), other.studioId())
                && Objects.equals(userRoleArn(), other.userRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStudioRequest").add("AdminRoleArn", adminRoleArn()).add("ClientToken", clientToken())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***").add("StudioId", studioId())
                .add("UserRoleArn", userRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "adminRoleArn":
            return Optional.ofNullable(clazz.cast(adminRoleArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "studioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        case "userRoleArn":
            return Optional.ofNullable(clazz.cast(userRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStudioRequest, T> g) {
        return obj -> g.apply((UpdateStudioRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStudioRequest> {
        /**
         * <p>
         * The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.
         * </p>
         * 
         * @param adminRoleArn
         *        The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminRoleArn(String adminRoleArn);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
         * specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for
         * the request to ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and
         *        uses it for the request to ensure idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A friendly name for the studio.
         * </p>
         * 
         * @param displayName
         *        A friendly name for the studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The studio ID.
         * </p>
         * 
         * @param studioId
         *        The studio ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        /**
         * <p>
         * The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.
         * </p>
         * 
         * @param userRoleArn
         *        The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRoleArn(String userRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NimbleRequest.BuilderImpl implements Builder {
        private String adminRoleArn;

        private String clientToken;

        private String displayName;

        private String studioId;

        private String userRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStudioRequest model) {
            super(model);
            adminRoleArn(model.adminRoleArn);
            clientToken(model.clientToken);
            displayName(model.displayName);
            studioId(model.studioId);
            userRoleArn(model.userRoleArn);
        }

        public final String getAdminRoleArn() {
            return adminRoleArn;
        }

        public final void setAdminRoleArn(String adminRoleArn) {
            this.adminRoleArn = adminRoleArn;
        }

        @Override
        public final Builder adminRoleArn(String adminRoleArn) {
            this.adminRoleArn = adminRoleArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStudioId() {
            return studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final String getUserRoleArn() {
            return userRoleArn;
        }

        public final void setUserRoleArn(String userRoleArn) {
            this.userRoleArn = userRoleArn;
        }

        @Override
        public final Builder userRoleArn(String userRoleArn) {
            this.userRoleArn = userRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStudioRequest build() {
            return new UpdateStudioRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
