/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A streaming session is a virtual workstation created using a particular launch profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingSession implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingSession.Builder, StreamingSession> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(StreamingSession::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> AUTOMATIC_TERMINATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("automaticTerminationMode").getter(getter(StreamingSession::automaticTerminationModeAsString))
            .setter(setter(Builder::automaticTerminationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automaticTerminationMode").build())
            .build();

    private static final SdkField<String> BACKUP_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("backupMode").getter(getter(StreamingSession::backupModeAsString)).setter(setter(Builder::backupMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupMode").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(StreamingSession::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(StreamingSession::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> EC2_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2InstanceType").getter(getter(StreamingSession::ec2InstanceType))
            .setter(setter(Builder::ec2InstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceType").build()).build();

    private static final SdkField<String> LAUNCH_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchProfileId").getter(getter(StreamingSession::launchProfileId))
            .setter(setter(Builder::launchProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileId").build()).build();

    private static final SdkField<Integer> MAX_BACKUPS_TO_RETAIN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxBackupsToRetain").getter(getter(StreamingSession::maxBackupsToRetain))
            .setter(setter(Builder::maxBackupsToRetain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBackupsToRetain").build())
            .build();

    private static final SdkField<String> OWNED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownedBy").getter(getter(StreamingSession::ownedBy)).setter(setter(Builder::ownedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownedBy").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(StreamingSession::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> SESSION_PERSISTENCE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionPersistenceMode").getter(getter(StreamingSession::sessionPersistenceModeAsString))
            .setter(setter(Builder::sessionPersistenceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionPersistenceMode").build())
            .build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(StreamingSession::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STARTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startedBy").getter(getter(StreamingSession::startedBy)).setter(setter(Builder::startedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()).build();

    private static final SdkField<String> STARTED_FROM_BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startedFromBackupId").getter(getter(StreamingSession::startedFromBackupId))
            .setter(setter(Builder::startedFromBackupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedFromBackupId").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(StreamingSession::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(StreamingSession::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(StreamingSession::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Instant> STOP_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("stopAt")
            .getter(getter(StreamingSession::stopAt))
            .setter(setter(Builder::stopAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> STOPPED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("stoppedAt")
            .getter(getter(StreamingSession::stoppedAt))
            .setter(setter(Builder::stoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STOPPED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stoppedBy").getter(getter(StreamingSession::stoppedBy)).setter(setter(Builder::stoppedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedBy").build()).build();

    private static final SdkField<String> STREAMING_IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamingImageId").getter(getter(StreamingSession::streamingImageId))
            .setter(setter(Builder::streamingImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingImageId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StreamingSession::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> TERMINATE_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("terminateAt")
            .getter(getter(StreamingSession::terminateAt))
            .setter(setter(Builder::terminateAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminateAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(StreamingSession::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(StreamingSession::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<VolumeConfiguration> VOLUME_CONFIGURATION_FIELD = SdkField
            .<VolumeConfiguration> builder(MarshallingType.SDK_POJO).memberName("volumeConfiguration")
            .getter(getter(StreamingSession::volumeConfiguration)).setter(setter(Builder::volumeConfiguration))
            .constructor(VolumeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeConfiguration").build())
            .build();

    private static final SdkField<String> VOLUME_RETENTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeRetentionMode").getter(getter(StreamingSession::volumeRetentionModeAsString))
            .setter(setter(Builder::volumeRetentionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeRetentionMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            AUTOMATIC_TERMINATION_MODE_FIELD, BACKUP_MODE_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, EC2_INSTANCE_TYPE_FIELD,
            LAUNCH_PROFILE_ID_FIELD, MAX_BACKUPS_TO_RETAIN_FIELD, OWNED_BY_FIELD, SESSION_ID_FIELD,
            SESSION_PERSISTENCE_MODE_FIELD, STARTED_AT_FIELD, STARTED_BY_FIELD, STARTED_FROM_BACKUP_ID_FIELD, STATE_FIELD,
            STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, STOP_AT_FIELD, STOPPED_AT_FIELD, STOPPED_BY_FIELD, STREAMING_IMAGE_ID_FIELD,
            TAGS_FIELD, TERMINATE_AT_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, VOLUME_CONFIGURATION_FIELD,
            VOLUME_RETENTION_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String automaticTerminationMode;

    private final String backupMode;

    private final Instant createdAt;

    private final String createdBy;

    private final String ec2InstanceType;

    private final String launchProfileId;

    private final Integer maxBackupsToRetain;

    private final String ownedBy;

    private final String sessionId;

    private final String sessionPersistenceMode;

    private final Instant startedAt;

    private final String startedBy;

    private final String startedFromBackupId;

    private final String state;

    private final String statusCodeValue;

    private final String statusMessage;

    private final Instant stopAt;

    private final Instant stoppedAt;

    private final String stoppedBy;

    private final String streamingImageId;

    private final Map<String, String> tags;

    private final Instant terminateAt;

    private final Instant updatedAt;

    private final String updatedBy;

    private final VolumeConfiguration volumeConfiguration;

    private final String volumeRetentionMode;

    private StreamingSession(BuilderImpl builder) {
        this.arn = builder.arn;
        this.automaticTerminationMode = builder.automaticTerminationMode;
        this.backupMode = builder.backupMode;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.ec2InstanceType = builder.ec2InstanceType;
        this.launchProfileId = builder.launchProfileId;
        this.maxBackupsToRetain = builder.maxBackupsToRetain;
        this.ownedBy = builder.ownedBy;
        this.sessionId = builder.sessionId;
        this.sessionPersistenceMode = builder.sessionPersistenceMode;
        this.startedAt = builder.startedAt;
        this.startedBy = builder.startedBy;
        this.startedFromBackupId = builder.startedFromBackupId;
        this.state = builder.state;
        this.statusCodeValue = builder.statusCodeValue;
        this.statusMessage = builder.statusMessage;
        this.stopAt = builder.stopAt;
        this.stoppedAt = builder.stoppedAt;
        this.stoppedBy = builder.stoppedBy;
        this.streamingImageId = builder.streamingImageId;
        this.tags = builder.tags;
        this.terminateAt = builder.terminateAt;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.volumeConfiguration = builder.volumeConfiguration;
        this.volumeRetentionMode = builder.volumeRetentionMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely identifies it. ARNs are unique
     * across all Regions.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely identifies it. ARNs are
     *         unique across all Regions.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Indicates if a streaming session created from this launch profile should be terminated automatically or retained
     * without termination after being in a <code>STOPPED</code> state.
     * </p>
     * <ul>
     * <li>
     * <p>
     * When <code>ACTIVATED</code>, the streaming session is scheduled for termination after being in the
     * <code>STOPPED</code> state for the time specified in <code>maxStoppedSessionLengthInMinutes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * When <code>DEACTIVATED</code>, the streaming session can remain in the <code>STOPPED</code> state indefinitely.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>. When allowed,
     * the default value for this parameter is <code>DEACTIVATED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automaticTerminationMode} will return {@link AutomaticTerminationMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #automaticTerminationModeAsString}.
     * </p>
     * 
     * @return Indicates if a streaming session created from this launch profile should be terminated automatically or
     *         retained without termination after being in a <code>STOPPED</code> state.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         When <code>ACTIVATED</code>, the streaming session is scheduled for termination after being in the
     *         <code>STOPPED</code> state for the time specified in <code>maxStoppedSessionLengthInMinutes</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When <code>DEACTIVATED</code>, the streaming session can remain in the <code>STOPPED</code> state
     *         indefinitely.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>. When
     *         allowed, the default value for this parameter is <code>DEACTIVATED</code>.
     * @see AutomaticTerminationMode
     */
    public final AutomaticTerminationMode automaticTerminationMode() {
        return AutomaticTerminationMode.fromValue(automaticTerminationMode);
    }

    /**
     * <p>
     * Indicates if a streaming session created from this launch profile should be terminated automatically or retained
     * without termination after being in a <code>STOPPED</code> state.
     * </p>
     * <ul>
     * <li>
     * <p>
     * When <code>ACTIVATED</code>, the streaming session is scheduled for termination after being in the
     * <code>STOPPED</code> state for the time specified in <code>maxStoppedSessionLengthInMinutes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * When <code>DEACTIVATED</code>, the streaming session can remain in the <code>STOPPED</code> state indefinitely.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>. When allowed,
     * the default value for this parameter is <code>DEACTIVATED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automaticTerminationMode} will return {@link AutomaticTerminationMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #automaticTerminationModeAsString}.
     * </p>
     * 
     * @return Indicates if a streaming session created from this launch profile should be terminated automatically or
     *         retained without termination after being in a <code>STOPPED</code> state.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         When <code>ACTIVATED</code>, the streaming session is scheduled for termination after being in the
     *         <code>STOPPED</code> state for the time specified in <code>maxStoppedSessionLengthInMinutes</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When <code>DEACTIVATED</code>, the streaming session can remain in the <code>STOPPED</code> state
     *         indefinitely.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>. When
     *         allowed, the default value for this parameter is <code>DEACTIVATED</code>.
     * @see AutomaticTerminationMode
     */
    public final String automaticTerminationModeAsString() {
        return automaticTerminationMode;
    }

    /**
     * <p>
     * Shows the current backup setting of the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupMode} will
     * return {@link SessionBackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupModeAsString}.
     * </p>
     * 
     * @return Shows the current backup setting of the session.
     * @see SessionBackupMode
     */
    public final SessionBackupMode backupMode() {
        return SessionBackupMode.fromValue(backupMode);
    }

    /**
     * <p>
     * Shows the current backup setting of the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupMode} will
     * return {@link SessionBackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupModeAsString}.
     * </p>
     * 
     * @return Shows the current backup setting of the session.
     * @see SessionBackupMode
     */
    public final String backupModeAsString() {
        return backupMode;
    }

    /**
     * <p>
     * The ISO timestamp in seconds for when the resource was created.
     * </p>
     * 
     * @return The ISO timestamp in seconds for when the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user ID of the user that created the streaming session.
     * </p>
     * 
     * @return The user ID of the user that created the streaming session.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The EC2 Instance type used for the streaming session.
     * </p>
     * 
     * @return The EC2 Instance type used for the streaming session.
     */
    public final String ec2InstanceType() {
        return ec2InstanceType;
    }

    /**
     * <p>
     * The ID of the launch profile used to control access from the streaming session.
     * </p>
     * 
     * @return The ID of the launch profile used to control access from the streaming session.
     */
    public final String launchProfileId() {
        return launchProfileId;
    }

    /**
     * <p>
     * The maximum number of backups of a streaming session that you can have. When the maximum number of backups is
     * reached, the oldest backup is deleted.
     * </p>
     * 
     * @return The maximum number of backups of a streaming session that you can have. When the maximum number of
     *         backups is reached, the oldest backup is deleted.
     */
    public final Integer maxBackupsToRetain() {
        return maxBackupsToRetain;
    }

    /**
     * <p>
     * The user ID of the user that owns the streaming session. The user that owns the session will be logging into the
     * session and interacting with the virtual workstation.
     * </p>
     * 
     * @return The user ID of the user that owns the streaming session. The user that owns the session will be logging
     *         into the session and interacting with the virtual workstation.
     */
    public final String ownedBy() {
        return ownedBy;
    }

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @return The session ID.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Determine if a streaming session created from this launch profile can configure persistent storage. This means
     * that <code>volumeConfiguration</code> and <code>automaticTerminationMode</code> are configured.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sessionPersistenceMode} will return {@link SessionPersistenceMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #sessionPersistenceModeAsString}.
     * </p>
     * 
     * @return Determine if a streaming session created from this launch profile can configure persistent storage. This
     *         means that <code>volumeConfiguration</code> and <code>automaticTerminationMode</code> are configured.
     * @see SessionPersistenceMode
     */
    public final SessionPersistenceMode sessionPersistenceMode() {
        return SessionPersistenceMode.fromValue(sessionPersistenceMode);
    }

    /**
     * <p>
     * Determine if a streaming session created from this launch profile can configure persistent storage. This means
     * that <code>volumeConfiguration</code> and <code>automaticTerminationMode</code> are configured.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sessionPersistenceMode} will return {@link SessionPersistenceMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #sessionPersistenceModeAsString}.
     * </p>
     * 
     * @return Determine if a streaming session created from this launch profile can configure persistent storage. This
     *         means that <code>volumeConfiguration</code> and <code>automaticTerminationMode</code> are configured.
     * @see SessionPersistenceMode
     */
    public final String sessionPersistenceModeAsString() {
        return sessionPersistenceMode;
    }

    /**
     * <p>
     * The time the session entered <code>START_IN_PROGRESS</code> state.
     * </p>
     * 
     * @return The time the session entered <code>START_IN_PROGRESS</code> state.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The user ID of the user that started the streaming session.
     * </p>
     * 
     * @return The user ID of the user that started the streaming session.
     */
    public final String startedBy() {
        return startedBy;
    }

    /**
     * <p>
     * The backup ID used to restore a streaming session.
     * </p>
     * 
     * @return The backup ID used to restore a streaming session.
     */
    public final String startedFromBackupId() {
        return startedFromBackupId;
    }

    /**
     * <p>
     * The current state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StreamingSessionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state.
     * @see StreamingSessionState
     */
    public final StreamingSessionState state() {
        return StreamingSessionState.fromValue(state);
    }

    /**
     * <p>
     * The current state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StreamingSessionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state.
     * @see StreamingSessionState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The status code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link StreamingSessionStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code.
     * @see StreamingSessionStatusCode
     */
    public final StreamingSessionStatusCode statusCode() {
        return StreamingSessionStatusCode.fromValue(statusCodeValue);
    }

    /**
     * <p>
     * The status code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link StreamingSessionStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code.
     * @see StreamingSessionStatusCode
     */
    public final String statusCodeAsString() {
        return statusCodeValue;
    }

    /**
     * <p>
     * The status message for the streaming session.
     * </p>
     * 
     * @return The status message for the streaming session.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The time the streaming session will automatically be stopped if the user doesn’t stop the session themselves.
     * </p>
     * 
     * @return The time the streaming session will automatically be stopped if the user doesn’t stop the session
     *         themselves.
     */
    public final Instant stopAt() {
        return stopAt;
    }

    /**
     * <p>
     * The time the session entered <code>STOP_IN_PROGRESS</code> state.
     * </p>
     * 
     * @return The time the session entered <code>STOP_IN_PROGRESS</code> state.
     */
    public final Instant stoppedAt() {
        return stoppedAt;
    }

    /**
     * <p>
     * The user ID of the user that stopped the streaming session.
     * </p>
     * 
     * @return The user ID of the user that stopped the streaming session.
     */
    public final String stoppedBy() {
        return stoppedBy;
    }

    /**
     * <p>
     * The ID of the streaming image.
     * </p>
     * 
     * @return The ID of the streaming image.
     */
    public final String streamingImageId() {
        return streamingImageId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of labels, in the form of key-value pairs, that apply to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of labels, in the form of key-value pairs, that apply to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The time the streaming session will automatically terminate if not terminated by the user.
     * </p>
     * 
     * @return The time the streaming session will automatically terminate if not terminated by the user.
     */
    public final Instant terminateAt() {
        return terminateAt;
    }

    /**
     * <p>
     * The ISO timestamp in seconds for when the resource was updated.
     * </p>
     * 
     * @return The ISO timestamp in seconds for when the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user ID of the user that most recently updated the resource.
     * </p>
     * 
     * @return The user ID of the user that most recently updated the resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * Custom volume configuration for the root volumes that are attached to streaming sessions.
     * </p>
     * <p>
     * This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>.
     * </p>
     * 
     * @return Custom volume configuration for the root volumes that are attached to streaming sessions.</p>
     *         <p>
     *         This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>.
     */
    public final VolumeConfiguration volumeConfiguration() {
        return volumeConfiguration;
    }

    /**
     * <p>
     * Determine if an EBS volume created from this streaming session will be backed up.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #volumeRetentionMode} will return {@link VolumeRetentionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #volumeRetentionModeAsString}.
     * </p>
     * 
     * @return Determine if an EBS volume created from this streaming session will be backed up.
     * @see VolumeRetentionMode
     */
    public final VolumeRetentionMode volumeRetentionMode() {
        return VolumeRetentionMode.fromValue(volumeRetentionMode);
    }

    /**
     * <p>
     * Determine if an EBS volume created from this streaming session will be backed up.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #volumeRetentionMode} will return {@link VolumeRetentionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #volumeRetentionModeAsString}.
     * </p>
     * 
     * @return Determine if an EBS volume created from this streaming session will be backed up.
     * @see VolumeRetentionMode
     */
    public final String volumeRetentionModeAsString() {
        return volumeRetentionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(automaticTerminationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(launchProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(maxBackupsToRetain());
        hashCode = 31 * hashCode + Objects.hashCode(ownedBy());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionPersistenceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(startedFromBackupId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(stopAt());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedBy());
        hashCode = 31 * hashCode + Objects.hashCode(streamingImageId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(terminateAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(volumeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(volumeRetentionModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingSession)) {
            return false;
        }
        StreamingSession other = (StreamingSession) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(automaticTerminationModeAsString(), other.automaticTerminationModeAsString())
                && Objects.equals(backupModeAsString(), other.backupModeAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(ec2InstanceType(), other.ec2InstanceType())
                && Objects.equals(launchProfileId(), other.launchProfileId())
                && Objects.equals(maxBackupsToRetain(), other.maxBackupsToRetain()) && Objects.equals(ownedBy(), other.ownedBy())
                && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(sessionPersistenceModeAsString(), other.sessionPersistenceModeAsString())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(startedBy(), other.startedBy())
                && Objects.equals(startedFromBackupId(), other.startedFromBackupId())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(stopAt(), other.stopAt())
                && Objects.equals(stoppedAt(), other.stoppedAt()) && Objects.equals(stoppedBy(), other.stoppedBy())
                && Objects.equals(streamingImageId(), other.streamingImageId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(terminateAt(), other.terminateAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy())
                && Objects.equals(volumeConfiguration(), other.volumeConfiguration())
                && Objects.equals(volumeRetentionModeAsString(), other.volumeRetentionModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamingSession").add("Arn", arn())
                .add("AutomaticTerminationMode", automaticTerminationModeAsString()).add("BackupMode", backupModeAsString())
                .add("CreatedAt", createdAt()).add("CreatedBy", createdBy()).add("Ec2InstanceType", ec2InstanceType())
                .add("LaunchProfileId", launchProfileId()).add("MaxBackupsToRetain", maxBackupsToRetain())
                .add("OwnedBy", ownedBy()).add("SessionId", sessionId())
                .add("SessionPersistenceMode", sessionPersistenceModeAsString()).add("StartedAt", startedAt())
                .add("StartedBy", startedBy()).add("StartedFromBackupId", startedFromBackupId()).add("State", stateAsString())
                .add("StatusCode", statusCodeAsString()).add("StatusMessage", statusMessage()).add("StopAt", stopAt())
                .add("StoppedAt", stoppedAt()).add("StoppedBy", stoppedBy()).add("StreamingImageId", streamingImageId())
                .add("Tags", hasTags() ? tags() : null).add("TerminateAt", terminateAt()).add("UpdatedAt", updatedAt())
                .add("UpdatedBy", updatedBy()).add("VolumeConfiguration", volumeConfiguration())
                .add("VolumeRetentionMode", volumeRetentionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "automaticTerminationMode":
            return Optional.ofNullable(clazz.cast(automaticTerminationModeAsString()));
        case "backupMode":
            return Optional.ofNullable(clazz.cast(backupModeAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "ec2InstanceType":
            return Optional.ofNullable(clazz.cast(ec2InstanceType()));
        case "launchProfileId":
            return Optional.ofNullable(clazz.cast(launchProfileId()));
        case "maxBackupsToRetain":
            return Optional.ofNullable(clazz.cast(maxBackupsToRetain()));
        case "ownedBy":
            return Optional.ofNullable(clazz.cast(ownedBy()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "sessionPersistenceMode":
            return Optional.ofNullable(clazz.cast(sessionPersistenceModeAsString()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "startedBy":
            return Optional.ofNullable(clazz.cast(startedBy()));
        case "startedFromBackupId":
            return Optional.ofNullable(clazz.cast(startedFromBackupId()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "stopAt":
            return Optional.ofNullable(clazz.cast(stopAt()));
        case "stoppedAt":
            return Optional.ofNullable(clazz.cast(stoppedAt()));
        case "stoppedBy":
            return Optional.ofNullable(clazz.cast(stoppedBy()));
        case "streamingImageId":
            return Optional.ofNullable(clazz.cast(streamingImageId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "terminateAt":
            return Optional.ofNullable(clazz.cast(terminateAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "volumeConfiguration":
            return Optional.ofNullable(clazz.cast(volumeConfiguration()));
        case "volumeRetentionMode":
            return Optional.ofNullable(clazz.cast(volumeRetentionModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingSession, T> g) {
        return obj -> g.apply((StreamingSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingSession> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely identifies it. ARNs are
         * unique across all Regions.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely identifies it. ARNs
         *        are unique across all Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Indicates if a streaming session created from this launch profile should be terminated automatically or
         * retained without termination after being in a <code>STOPPED</code> state.
         * </p>
         * <ul>
         * <li>
         * <p>
         * When <code>ACTIVATED</code>, the streaming session is scheduled for termination after being in the
         * <code>STOPPED</code> state for the time specified in <code>maxStoppedSessionLengthInMinutes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>DEACTIVATED</code>, the streaming session can remain in the <code>STOPPED</code> state
         * indefinitely.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>. When
         * allowed, the default value for this parameter is <code>DEACTIVATED</code>.
         * </p>
         * 
         * @param automaticTerminationMode
         *        Indicates if a streaming session created from this launch profile should be terminated automatically
         *        or retained without termination after being in a <code>STOPPED</code> state.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        When <code>ACTIVATED</code>, the streaming session is scheduled for termination after being in the
         *        <code>STOPPED</code> state for the time specified in <code>maxStoppedSessionLengthInMinutes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When <code>DEACTIVATED</code>, the streaming session can remain in the <code>STOPPED</code> state
         *        indefinitely.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>.
         *        When allowed, the default value for this parameter is <code>DEACTIVATED</code>.
         * @see AutomaticTerminationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomaticTerminationMode
         */
        Builder automaticTerminationMode(String automaticTerminationMode);

        /**
         * <p>
         * Indicates if a streaming session created from this launch profile should be terminated automatically or
         * retained without termination after being in a <code>STOPPED</code> state.
         * </p>
         * <ul>
         * <li>
         * <p>
         * When <code>ACTIVATED</code>, the streaming session is scheduled for termination after being in the
         * <code>STOPPED</code> state for the time specified in <code>maxStoppedSessionLengthInMinutes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>DEACTIVATED</code>, the streaming session can remain in the <code>STOPPED</code> state
         * indefinitely.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>. When
         * allowed, the default value for this parameter is <code>DEACTIVATED</code>.
         * </p>
         * 
         * @param automaticTerminationMode
         *        Indicates if a streaming session created from this launch profile should be terminated automatically
         *        or retained without termination after being in a <code>STOPPED</code> state.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        When <code>ACTIVATED</code>, the streaming session is scheduled for termination after being in the
         *        <code>STOPPED</code> state for the time specified in <code>maxStoppedSessionLengthInMinutes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When <code>DEACTIVATED</code>, the streaming session can remain in the <code>STOPPED</code> state
         *        indefinitely.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>.
         *        When allowed, the default value for this parameter is <code>DEACTIVATED</code>.
         * @see AutomaticTerminationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomaticTerminationMode
         */
        Builder automaticTerminationMode(AutomaticTerminationMode automaticTerminationMode);

        /**
         * <p>
         * Shows the current backup setting of the session.
         * </p>
         * 
         * @param backupMode
         *        Shows the current backup setting of the session.
         * @see SessionBackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionBackupMode
         */
        Builder backupMode(String backupMode);

        /**
         * <p>
         * Shows the current backup setting of the session.
         * </p>
         * 
         * @param backupMode
         *        Shows the current backup setting of the session.
         * @see SessionBackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionBackupMode
         */
        Builder backupMode(SessionBackupMode backupMode);

        /**
         * <p>
         * The ISO timestamp in seconds for when the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The ISO timestamp in seconds for when the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user ID of the user that created the streaming session.
         * </p>
         * 
         * @param createdBy
         *        The user ID of the user that created the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The EC2 Instance type used for the streaming session.
         * </p>
         * 
         * @param ec2InstanceType
         *        The EC2 Instance type used for the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceType(String ec2InstanceType);

        /**
         * <p>
         * The ID of the launch profile used to control access from the streaming session.
         * </p>
         * 
         * @param launchProfileId
         *        The ID of the launch profile used to control access from the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfileId(String launchProfileId);

        /**
         * <p>
         * The maximum number of backups of a streaming session that you can have. When the maximum number of backups is
         * reached, the oldest backup is deleted.
         * </p>
         * 
         * @param maxBackupsToRetain
         *        The maximum number of backups of a streaming session that you can have. When the maximum number of
         *        backups is reached, the oldest backup is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBackupsToRetain(Integer maxBackupsToRetain);

        /**
         * <p>
         * The user ID of the user that owns the streaming session. The user that owns the session will be logging into
         * the session and interacting with the virtual workstation.
         * </p>
         * 
         * @param ownedBy
         *        The user ID of the user that owns the streaming session. The user that owns the session will be
         *        logging into the session and interacting with the virtual workstation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownedBy(String ownedBy);

        /**
         * <p>
         * The session ID.
         * </p>
         * 
         * @param sessionId
         *        The session ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Determine if a streaming session created from this launch profile can configure persistent storage. This
         * means that <code>volumeConfiguration</code> and <code>automaticTerminationMode</code> are configured.
         * </p>
         * 
         * @param sessionPersistenceMode
         *        Determine if a streaming session created from this launch profile can configure persistent storage.
         *        This means that <code>volumeConfiguration</code> and <code>automaticTerminationMode</code> are
         *        configured.
         * @see SessionPersistenceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionPersistenceMode
         */
        Builder sessionPersistenceMode(String sessionPersistenceMode);

        /**
         * <p>
         * Determine if a streaming session created from this launch profile can configure persistent storage. This
         * means that <code>volumeConfiguration</code> and <code>automaticTerminationMode</code> are configured.
         * </p>
         * 
         * @param sessionPersistenceMode
         *        Determine if a streaming session created from this launch profile can configure persistent storage.
         *        This means that <code>volumeConfiguration</code> and <code>automaticTerminationMode</code> are
         *        configured.
         * @see SessionPersistenceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionPersistenceMode
         */
        Builder sessionPersistenceMode(SessionPersistenceMode sessionPersistenceMode);

        /**
         * <p>
         * The time the session entered <code>START_IN_PROGRESS</code> state.
         * </p>
         * 
         * @param startedAt
         *        The time the session entered <code>START_IN_PROGRESS</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The user ID of the user that started the streaming session.
         * </p>
         * 
         * @param startedBy
         *        The user ID of the user that started the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedBy(String startedBy);

        /**
         * <p>
         * The backup ID used to restore a streaming session.
         * </p>
         * 
         * @param startedFromBackupId
         *        The backup ID used to restore a streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedFromBackupId(String startedFromBackupId);

        /**
         * <p>
         * The current state.
         * </p>
         * 
         * @param state
         *        The current state.
         * @see StreamingSessionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingSessionState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state.
         * </p>
         * 
         * @param state
         *        The current state.
         * @see StreamingSessionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingSessionState
         */
        Builder state(StreamingSessionState state);

        /**
         * <p>
         * The status code.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code.
         * @see StreamingSessionStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingSessionStatusCode
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * The status code.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code.
         * @see StreamingSessionStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingSessionStatusCode
         */
        Builder statusCode(StreamingSessionStatusCode statusCodeValue);

        /**
         * <p>
         * The status message for the streaming session.
         * </p>
         * 
         * @param statusMessage
         *        The status message for the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The time the streaming session will automatically be stopped if the user doesn’t stop the session themselves.
         * </p>
         * 
         * @param stopAt
         *        The time the streaming session will automatically be stopped if the user doesn’t stop the session
         *        themselves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopAt(Instant stopAt);

        /**
         * <p>
         * The time the session entered <code>STOP_IN_PROGRESS</code> state.
         * </p>
         * 
         * @param stoppedAt
         *        The time the session entered <code>STOP_IN_PROGRESS</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedAt(Instant stoppedAt);

        /**
         * <p>
         * The user ID of the user that stopped the streaming session.
         * </p>
         * 
         * @param stoppedBy
         *        The user ID of the user that stopped the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedBy(String stoppedBy);

        /**
         * <p>
         * The ID of the streaming image.
         * </p>
         * 
         * @param streamingImageId
         *        The ID of the streaming image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingImageId(String streamingImageId);

        /**
         * <p>
         * A collection of labels, in the form of key-value pairs, that apply to this resource.
         * </p>
         * 
         * @param tags
         *        A collection of labels, in the form of key-value pairs, that apply to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The time the streaming session will automatically terminate if not terminated by the user.
         * </p>
         * 
         * @param terminateAt
         *        The time the streaming session will automatically terminate if not terminated by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateAt(Instant terminateAt);

        /**
         * <p>
         * The ISO timestamp in seconds for when the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The ISO timestamp in seconds for when the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user ID of the user that most recently updated the resource.
         * </p>
         * 
         * @param updatedBy
         *        The user ID of the user that most recently updated the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * Custom volume configuration for the root volumes that are attached to streaming sessions.
         * </p>
         * <p>
         * This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>.
         * </p>
         * 
         * @param volumeConfiguration
         *        Custom volume configuration for the root volumes that are attached to streaming sessions.</p>
         *        <p>
         *        This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfiguration(VolumeConfiguration volumeConfiguration);

        /**
         * <p>
         * Custom volume configuration for the root volumes that are attached to streaming sessions.
         * </p>
         * <p>
         * This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link VolumeConfiguration.Builder} avoiding the
         * need to create one manually via {@link VolumeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VolumeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #volumeConfiguration(VolumeConfiguration)}.
         * 
         * @param volumeConfiguration
         *        a consumer that will call methods on {@link VolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeConfiguration(VolumeConfiguration)
         */
        default Builder volumeConfiguration(Consumer<VolumeConfiguration.Builder> volumeConfiguration) {
            return volumeConfiguration(VolumeConfiguration.builder().applyMutation(volumeConfiguration).build());
        }

        /**
         * <p>
         * Determine if an EBS volume created from this streaming session will be backed up.
         * </p>
         * 
         * @param volumeRetentionMode
         *        Determine if an EBS volume created from this streaming session will be backed up.
         * @see VolumeRetentionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeRetentionMode
         */
        Builder volumeRetentionMode(String volumeRetentionMode);

        /**
         * <p>
         * Determine if an EBS volume created from this streaming session will be backed up.
         * </p>
         * 
         * @param volumeRetentionMode
         *        Determine if an EBS volume created from this streaming session will be backed up.
         * @see VolumeRetentionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeRetentionMode
         */
        Builder volumeRetentionMode(VolumeRetentionMode volumeRetentionMode);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String automaticTerminationMode;

        private String backupMode;

        private Instant createdAt;

        private String createdBy;

        private String ec2InstanceType;

        private String launchProfileId;

        private Integer maxBackupsToRetain;

        private String ownedBy;

        private String sessionId;

        private String sessionPersistenceMode;

        private Instant startedAt;

        private String startedBy;

        private String startedFromBackupId;

        private String state;

        private String statusCodeValue;

        private String statusMessage;

        private Instant stopAt;

        private Instant stoppedAt;

        private String stoppedBy;

        private String streamingImageId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant terminateAt;

        private Instant updatedAt;

        private String updatedBy;

        private VolumeConfiguration volumeConfiguration;

        private String volumeRetentionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingSession model) {
            arn(model.arn);
            automaticTerminationMode(model.automaticTerminationMode);
            backupMode(model.backupMode);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            ec2InstanceType(model.ec2InstanceType);
            launchProfileId(model.launchProfileId);
            maxBackupsToRetain(model.maxBackupsToRetain);
            ownedBy(model.ownedBy);
            sessionId(model.sessionId);
            sessionPersistenceMode(model.sessionPersistenceMode);
            startedAt(model.startedAt);
            startedBy(model.startedBy);
            startedFromBackupId(model.startedFromBackupId);
            state(model.state);
            statusCode(model.statusCodeValue);
            statusMessage(model.statusMessage);
            stopAt(model.stopAt);
            stoppedAt(model.stoppedAt);
            stoppedBy(model.stoppedBy);
            streamingImageId(model.streamingImageId);
            tags(model.tags);
            terminateAt(model.terminateAt);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            volumeConfiguration(model.volumeConfiguration);
            volumeRetentionMode(model.volumeRetentionMode);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAutomaticTerminationMode() {
            return automaticTerminationMode;
        }

        public final void setAutomaticTerminationMode(String automaticTerminationMode) {
            this.automaticTerminationMode = automaticTerminationMode;
        }

        @Override
        public final Builder automaticTerminationMode(String automaticTerminationMode) {
            this.automaticTerminationMode = automaticTerminationMode;
            return this;
        }

        @Override
        public final Builder automaticTerminationMode(AutomaticTerminationMode automaticTerminationMode) {
            this.automaticTerminationMode(automaticTerminationMode == null ? null : automaticTerminationMode.toString());
            return this;
        }

        public final String getBackupMode() {
            return backupMode;
        }

        public final void setBackupMode(String backupMode) {
            this.backupMode = backupMode;
        }

        @Override
        public final Builder backupMode(String backupMode) {
            this.backupMode = backupMode;
            return this;
        }

        @Override
        public final Builder backupMode(SessionBackupMode backupMode) {
            this.backupMode(backupMode == null ? null : backupMode.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getEc2InstanceType() {
            return ec2InstanceType;
        }

        public final void setEc2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        public final String getLaunchProfileId() {
            return launchProfileId;
        }

        public final void setLaunchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
        }

        @Override
        public final Builder launchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
            return this;
        }

        public final Integer getMaxBackupsToRetain() {
            return maxBackupsToRetain;
        }

        public final void setMaxBackupsToRetain(Integer maxBackupsToRetain) {
            this.maxBackupsToRetain = maxBackupsToRetain;
        }

        @Override
        public final Builder maxBackupsToRetain(Integer maxBackupsToRetain) {
            this.maxBackupsToRetain = maxBackupsToRetain;
            return this;
        }

        public final String getOwnedBy() {
            return ownedBy;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        @Override
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionPersistenceMode() {
            return sessionPersistenceMode;
        }

        public final void setSessionPersistenceMode(String sessionPersistenceMode) {
            this.sessionPersistenceMode = sessionPersistenceMode;
        }

        @Override
        public final Builder sessionPersistenceMode(String sessionPersistenceMode) {
            this.sessionPersistenceMode = sessionPersistenceMode;
            return this;
        }

        @Override
        public final Builder sessionPersistenceMode(SessionPersistenceMode sessionPersistenceMode) {
            this.sessionPersistenceMode(sessionPersistenceMode == null ? null : sessionPersistenceMode.toString());
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStartedBy() {
            return startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final String getStartedFromBackupId() {
            return startedFromBackupId;
        }

        public final void setStartedFromBackupId(String startedFromBackupId) {
            this.startedFromBackupId = startedFromBackupId;
        }

        @Override
        public final Builder startedFromBackupId(String startedFromBackupId) {
            this.startedFromBackupId = startedFromBackupId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StreamingSessionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(StreamingSessionStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getStopAt() {
            return stopAt;
        }

        public final void setStopAt(Instant stopAt) {
            this.stopAt = stopAt;
        }

        @Override
        public final Builder stopAt(Instant stopAt) {
            this.stopAt = stopAt;
            return this;
        }

        public final Instant getStoppedAt() {
            return stoppedAt;
        }

        public final void setStoppedAt(Instant stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Instant stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final String getStoppedBy() {
            return stoppedBy;
        }

        public final void setStoppedBy(String stoppedBy) {
            this.stoppedBy = stoppedBy;
        }

        @Override
        public final Builder stoppedBy(String stoppedBy) {
            this.stoppedBy = stoppedBy;
            return this;
        }

        public final String getStreamingImageId() {
            return streamingImageId;
        }

        public final void setStreamingImageId(String streamingImageId) {
            this.streamingImageId = streamingImageId;
        }

        @Override
        public final Builder streamingImageId(String streamingImageId) {
            this.streamingImageId = streamingImageId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Instant getTerminateAt() {
            return terminateAt;
        }

        public final void setTerminateAt(Instant terminateAt) {
            this.terminateAt = terminateAt;
        }

        @Override
        public final Builder terminateAt(Instant terminateAt) {
            this.terminateAt = terminateAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final VolumeConfiguration.Builder getVolumeConfiguration() {
            return volumeConfiguration != null ? volumeConfiguration.toBuilder() : null;
        }

        public final void setVolumeConfiguration(VolumeConfiguration.BuilderImpl volumeConfiguration) {
            this.volumeConfiguration = volumeConfiguration != null ? volumeConfiguration.build() : null;
        }

        @Override
        public final Builder volumeConfiguration(VolumeConfiguration volumeConfiguration) {
            this.volumeConfiguration = volumeConfiguration;
            return this;
        }

        public final String getVolumeRetentionMode() {
            return volumeRetentionMode;
        }

        public final void setVolumeRetentionMode(String volumeRetentionMode) {
            this.volumeRetentionMode = volumeRetentionMode;
        }

        @Override
        public final Builder volumeRetentionMode(String volumeRetentionMode) {
            this.volumeRetentionMode = volumeRetentionMode;
            return this;
        }

        @Override
        public final Builder volumeRetentionMode(VolumeRetentionMode volumeRetentionMode) {
            this.volumeRetentionMode(volumeRetentionMode == null ? null : volumeRetentionMode.toString());
            return this;
        }

        @Override
        public StreamingSession build() {
            return new StreamingSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
