/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of network function groups and edge overrides for the service insertion action. Used for both the
 * <code>send-to</code> and <code>send-via</code> actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Via implements SdkPojo, Serializable, ToCopyableBuilder<Via.Builder, Via> {
    private static final SdkField<List<NetworkFunctionGroup>> NETWORK_FUNCTION_GROUPS_FIELD = SdkField
            .<List<NetworkFunctionGroup>> builder(MarshallingType.LIST)
            .memberName("NetworkFunctionGroups")
            .getter(getter(Via::networkFunctionGroups))
            .setter(setter(Builder::networkFunctionGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFunctionGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkFunctionGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkFunctionGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EdgeOverride>> WITH_EDGE_OVERRIDES_FIELD = SdkField
            .<List<EdgeOverride>> builder(MarshallingType.LIST)
            .memberName("WithEdgeOverrides")
            .getter(getter(Via::withEdgeOverrides))
            .setter(setter(Builder::withEdgeOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithEdgeOverrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EdgeOverride> builder(MarshallingType.SDK_POJO)
                                            .constructor(EdgeOverride::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_FUNCTION_GROUPS_FIELD,
            WITH_EDGE_OVERRIDES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<NetworkFunctionGroup> networkFunctionGroups;

    private final List<EdgeOverride> withEdgeOverrides;

    private Via(BuilderImpl builder) {
        this.networkFunctionGroups = builder.networkFunctionGroups;
        this.withEdgeOverrides = builder.withEdgeOverrides;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkFunctionGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNetworkFunctionGroups() {
        return networkFunctionGroups != null && !(networkFunctionGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of network function groups associated with the service insertion action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkFunctionGroups} method.
     * </p>
     * 
     * @return The list of network function groups associated with the service insertion action.
     */
    public final List<NetworkFunctionGroup> networkFunctionGroups() {
        return networkFunctionGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the WithEdgeOverrides property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWithEdgeOverrides() {
        return withEdgeOverrides != null && !(withEdgeOverrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes any edge overrides. An edge override is a specific edge to be used for traffic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWithEdgeOverrides} method.
     * </p>
     * 
     * @return Describes any edge overrides. An edge override is a specific edge to be used for traffic.
     */
    public final List<EdgeOverride> withEdgeOverrides() {
        return withEdgeOverrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkFunctionGroups() ? networkFunctionGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWithEdgeOverrides() ? withEdgeOverrides() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Via)) {
            return false;
        }
        Via other = (Via) obj;
        return hasNetworkFunctionGroups() == other.hasNetworkFunctionGroups()
                && Objects.equals(networkFunctionGroups(), other.networkFunctionGroups())
                && hasWithEdgeOverrides() == other.hasWithEdgeOverrides()
                && Objects.equals(withEdgeOverrides(), other.withEdgeOverrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Via").add("NetworkFunctionGroups", hasNetworkFunctionGroups() ? networkFunctionGroups() : null)
                .add("WithEdgeOverrides", hasWithEdgeOverrides() ? withEdgeOverrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkFunctionGroups":
            return Optional.ofNullable(clazz.cast(networkFunctionGroups()));
        case "WithEdgeOverrides":
            return Optional.ofNullable(clazz.cast(withEdgeOverrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Via, T> g) {
        return obj -> g.apply((Via) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Via> {
        /**
         * <p>
         * The list of network function groups associated with the service insertion action.
         * </p>
         * 
         * @param networkFunctionGroups
         *        The list of network function groups associated with the service insertion action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFunctionGroups(Collection<NetworkFunctionGroup> networkFunctionGroups);

        /**
         * <p>
         * The list of network function groups associated with the service insertion action.
         * </p>
         * 
         * @param networkFunctionGroups
         *        The list of network function groups associated with the service insertion action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFunctionGroups(NetworkFunctionGroup... networkFunctionGroups);

        /**
         * <p>
         * The list of network function groups associated with the service insertion action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.NetworkFunctionGroup.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.networkmanager.model.NetworkFunctionGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.NetworkFunctionGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #networkFunctionGroups(List<NetworkFunctionGroup>)}.
         * 
         * @param networkFunctionGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.NetworkFunctionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkFunctionGroups(java.util.Collection<NetworkFunctionGroup>)
         */
        Builder networkFunctionGroups(Consumer<NetworkFunctionGroup.Builder>... networkFunctionGroups);

        /**
         * <p>
         * Describes any edge overrides. An edge override is a specific edge to be used for traffic.
         * </p>
         * 
         * @param withEdgeOverrides
         *        Describes any edge overrides. An edge override is a specific edge to be used for traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder withEdgeOverrides(Collection<EdgeOverride> withEdgeOverrides);

        /**
         * <p>
         * Describes any edge overrides. An edge override is a specific edge to be used for traffic.
         * </p>
         * 
         * @param withEdgeOverrides
         *        Describes any edge overrides. An edge override is a specific edge to be used for traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder withEdgeOverrides(EdgeOverride... withEdgeOverrides);

        /**
         * <p>
         * Describes any edge overrides. An edge override is a specific edge to be used for traffic.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.EdgeOverride.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.networkmanager.model.EdgeOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.EdgeOverride.Builder#build()} is called
         * immediately and its result is passed to {@link #withEdgeOverrides(List<EdgeOverride>)}.
         * 
         * @param withEdgeOverrides
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.EdgeOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #withEdgeOverrides(java.util.Collection<EdgeOverride>)
         */
        Builder withEdgeOverrides(Consumer<EdgeOverride.Builder>... withEdgeOverrides);
    }

    static final class BuilderImpl implements Builder {
        private List<NetworkFunctionGroup> networkFunctionGroups = DefaultSdkAutoConstructList.getInstance();

        private List<EdgeOverride> withEdgeOverrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Via model) {
            networkFunctionGroups(model.networkFunctionGroups);
            withEdgeOverrides(model.withEdgeOverrides);
        }

        public final List<NetworkFunctionGroup.Builder> getNetworkFunctionGroups() {
            List<NetworkFunctionGroup.Builder> result = NetworkFunctionGroupListCopier.copyToBuilder(this.networkFunctionGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkFunctionGroups(Collection<NetworkFunctionGroup.BuilderImpl> networkFunctionGroups) {
            this.networkFunctionGroups = NetworkFunctionGroupListCopier.copyFromBuilder(networkFunctionGroups);
        }

        @Override
        public final Builder networkFunctionGroups(Collection<NetworkFunctionGroup> networkFunctionGroups) {
            this.networkFunctionGroups = NetworkFunctionGroupListCopier.copy(networkFunctionGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkFunctionGroups(NetworkFunctionGroup... networkFunctionGroups) {
            networkFunctionGroups(Arrays.asList(networkFunctionGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkFunctionGroups(Consumer<NetworkFunctionGroup.Builder>... networkFunctionGroups) {
            networkFunctionGroups(Stream.of(networkFunctionGroups)
                    .map(c -> NetworkFunctionGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EdgeOverride.Builder> getWithEdgeOverrides() {
            List<EdgeOverride.Builder> result = WithEdgeOverridesListCopier.copyToBuilder(this.withEdgeOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWithEdgeOverrides(Collection<EdgeOverride.BuilderImpl> withEdgeOverrides) {
            this.withEdgeOverrides = WithEdgeOverridesListCopier.copyFromBuilder(withEdgeOverrides);
        }

        @Override
        public final Builder withEdgeOverrides(Collection<EdgeOverride> withEdgeOverrides) {
            this.withEdgeOverrides = WithEdgeOverridesListCopier.copy(withEdgeOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder withEdgeOverrides(EdgeOverride... withEdgeOverrides) {
            withEdgeOverrides(Arrays.asList(withEdgeOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder withEdgeOverrides(Consumer<EdgeOverride.Builder>... withEdgeOverrides) {
            withEdgeOverrides(Stream.of(withEdgeOverrides).map(c -> EdgeOverride.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Via build() {
            return new Via(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
